/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.renderer;

import com.vividsolutions.jump.task.LayerView;
import com.vividsolutions.jump.workbench.ui.LayerViewPanel;
import com.vividsolutions.jump.workbench.ui.renderer.AbstractSelectionRenderer;
import com.vividsolutions.jump.workbench.ui.renderer.ImageCachingRenderer;
import com.vividsolutions.jump.workbench.ui.renderer.RenderContext;
import com.vividsolutions.jump.workbench.ui.renderer.ThreadSafeImage;
import com.vividsolutions.jump.workbench.ui.selection.SelectionListener;
import com.vividsolutions.jump.workbench.ui.selection.SelectionManager;
import de.riwagis.util.thread.CancelableRunnable;
import java.awt.Color;
import java.awt.Graphics2D;
import java.util.Collection;

public class FeatureSelectionRenderer
extends AbstractSelectionRenderer {
    public static final String CONTENT_ID = "SELECTED_FEATURES";
    private ImageCachingRenderer imageCachingRenderer;

    public FeatureSelectionRenderer(RenderContext renderContext, SelectionManager selectionManager) {
        super(CONTENT_ID, renderContext, selectionManager, Color.MAGENTA, true, true);
        this.imageCachingRenderer = new ImageCachingRenderer(CONTENT_ID, (LayerView)renderContext){

            @Override
            protected void renderHook(ThreadSafeImage image, CancelableRunnable runnable) throws Exception {
                FeatureSelectionRenderer.super.copyTo(image.getGraphics());
            }
        };
        selectionManager.addSelectionListener(new SelectionListener(){

            @Override
            public void selectionChanged() {
                FeatureSelectionRenderer.this.createRunnable().run();
                FeatureSelectionRenderer.this.imageCachingRenderer.copyTo((Graphics2D)((LayerViewPanel)FeatureSelectionRenderer.this.imageCachingRenderer.getPanel()).getGraphics());
            }
        });
    }

    @Override
    public Runnable createRunnable() {
        super.createRunnable().run();
        return this.imageCachingRenderer.createRunnable();
    }

    @Override
    public void clearImageCache() {
        super.clearImageCache();
        this.imageCachingRenderer.clearImageCache();
    }

    @Override
    public void copyTo(Graphics2D graphics) {
        this.imageCachingRenderer.copyTo(graphics);
    }

    @Override
    protected Collection<?> getSelectedItems() {
        return this.getSelectionManager().getFeatureSelection().getSelectedItems();
    }
}

