/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.renderer;

import com.vividsolutions.jump.workbench.model.FeatureIteratorProxy;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.model.Layerable;
import com.vividsolutions.jump.workbench.ui.LayerViewPanelContext;
import com.vividsolutions.jump.workbench.ui.Viewport;
import com.vividsolutions.jump.workbench.ui.WorkbenchFrame;
import com.vividsolutions.jump.workbench.ui.renderer.RenderContext;
import com.vividsolutions.jump.workbench.ui.renderer.Renderer;
import com.vividsolutions.jump.workbench.ui.renderer.style.StyleRenderer;
import de.riwagis.geotools.feature.ShapeFeatureSTRtree;
import de.riwagis.riwajump.model.style.StyleModel;
import de.riwagis.util.thread.CancelableRunnable;
import java.awt.Graphics2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.lang.time.StopWatch;
import org.geotools.feature.FeatureIterator;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.opengis.feature.simple.SimpleFeature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class FeatureProxyRenderer
implements Renderer {
    private static final Logger LOG = LoggerFactory.getLogger((String)FeatureProxyRenderer.class.getName());
    private final Collection<SimpleFeature> lstFeatures4Rendering = new ArrayList<SimpleFeature>();
    private final Lock lockRendering = new ReentrantLock();
    private final Lock lockCopyTo = new ReentrantLock();
    private final Object contentID;
    private CancelableRunnable lastRunnable = null;
    private final LayerViewPanelContext userContext;
    private volatile boolean rendering = false;
    private final Viewport viewport;

    public FeatureProxyRenderer(Object contentID, RenderContext renderContext) {
        this(contentID, renderContext.getViewport(), renderContext.getContext());
    }

    public FeatureProxyRenderer(Object contentID, Viewport viewport, LayerViewPanelContext userContext) {
        this.contentID = contentID;
        this.viewport = viewport;
        this.userContext = userContext;
    }

    @Override
    public void clearImageCache() {
        this.lockCopyTo.lock();
        try {
            this.lstFeatures4Rendering.clear();
        }
        finally {
            this.lockCopyTo.unlock();
        }
    }

    private void setCopyToFeatures(Collection<SimpleFeature> lstFeatures) {
        this.lockCopyTo.lock();
        try {
            this.lstFeatures4Rendering.clear();
            if (lstFeatures != null) {
                this.lstFeatures4Rendering.addAll(lstFeatures);
            }
        }
        finally {
            this.lockCopyTo.unlock();
        }
    }

    @Override
    public boolean isRendering() {
        return this.rendering;
    }

    @Override
    public Object getContentID() {
        return this.contentID;
    }

    public final Viewport getViewport() {
        return this.viewport;
    }

    public final LayerViewPanelContext getUserContext() {
        return this.userContext;
    }

    protected abstract FeatureIteratorProxy getFeatureIteratorProxy();

    protected abstract Collection<StyleModel> styles();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void copyTo(Graphics2D graphics) {
        ShapeFeatureSTRtree tree;
        StopWatch sw;
        block15: {
            sw = new StopWatch();
            LOG.debug("strt copyTo: '{}', {}", this.contentID, (Object)this.lstFeatures4Rendering.size());
            this.lockCopyTo.lock();
            tree = null;
            try {
                tree = this.getIndex4Selection();
                if (graphics.getRenderingHint(Viewport.KEY_IS4PRINT) == Viewport.VALUE_IS4PRINT) {
                    LOG.debug("Printing, don't use ShapeFeatureSTRtree for selections.");
                    tree = ShapeFeatureSTRtree.DUMMY_SHAPEFEATURESTRTREE;
                }
                sw.start();
                if (!this.noRenderError()) break block15;
                Drawer grxDrawer = (style, feature, vp, tree1) -> style.paint(feature, graphics, vp, tree1);
                try {
                    for (StyleModel style2 : this.styles()) {
                        if (!style2.isEnabled()) continue;
                        StyleRenderer styleRenderer = (StyleRenderer)style2.getIntelligence();
                        this.renderWithDrawer(grxDrawer, styleRenderer, null, tree, this.lstFeatures4Rendering);
                    }
                    this.setRenderError(null);
                }
                catch (Throwable t) {
                    if (this.getUserContext() != null) {
                        this.getUserContext().warnUser(WorkbenchFrame.toMessage(t));
                    }
                    LOG.warn("Error on rendering", t);
                    this.setRenderError(String.format("%s: %s", t.getClass().getName(), t.getMessage()));
                }
            }
            catch (Throwable throwable) {
                try {
                    FeatureIteratorProxy fProxy = this.getFeatureIteratorProxy();
                    if (fProxy instanceof Layer) {
                        if (tree == null) {
                            tree = new ShapeFeatureSTRtree();
                        }
                        Layer layer = (Layer)fProxy;
                        layer.setRenderIndex(tree);
                    }
                }
                catch (Exception e) {
                    LOG.error("Error setting render index for layer", (Throwable)e);
                }
                this.lockCopyTo.unlock();
                sw.stop();
                LOG.info("done copyTo {} ms: '{}', #feat: {}", new Object[]{sw.getTime(), this.contentID, this.lstFeatures4Rendering.size()});
                throw throwable;
            }
        }
        try {
            FeatureIteratorProxy fProxy = this.getFeatureIteratorProxy();
            if (fProxy instanceof Layer) {
                if (tree == null) {
                    tree = new ShapeFeatureSTRtree();
                }
                Layer layer = (Layer)fProxy;
                layer.setRenderIndex(tree);
            }
        }
        catch (Exception e) {
            LOG.error("Error setting render index for layer", (Throwable)e);
        }
        this.lockCopyTo.unlock();
        sw.stop();
        LOG.info("done copyTo {} ms: '{}', #feat: {}", new Object[]{sw.getTime(), this.contentID, this.lstFeatures4Rendering.size()});
    }

    @Override
    public Runnable createRunnable() {
        this.cancel();
        this.rendering = true;
        this.lastRunnable = new CancelableRunnable(){
            private boolean cancelled = false;

            public boolean isCanceled() {
                return this.cancelled;
            }

            public void cancel() {
                this.cancelled = true;
            }

            public void run() {
                block9: {
                    block8: {
                        if (!this.cancelled) break block8;
                        FeatureProxyRenderer.this.rendering = false;
                        return;
                    }
                    if (!(FeatureProxyRenderer.this.contentID instanceof Layerable) || ((Layerable)FeatureProxyRenderer.this.contentID).isVisibleOnScreen()) break block9;
                    FeatureProxyRenderer.this.clearImageCache();
                    FeatureProxyRenderer.this.rendering = false;
                    return;
                }
                try {
                    try {
                        FeatureProxyRenderer.this.renderFeatures(this);
                        FeatureProxyRenderer.this.setRenderError(null);
                    }
                    catch (Throwable t) {
                        FeatureProxyRenderer.this.clearImageCache();
                        if (FeatureProxyRenderer.this.getUserContext() != null) {
                            FeatureProxyRenderer.this.getUserContext().warnUser(WorkbenchFrame.toMessage(t));
                        }
                        LOG.warn("Error rendering with FeatureProxy", t);
                        FeatureProxyRenderer.this.setRenderError(String.format("%s: %s", t.getClass().getName(), t.getMessage()));
                    }
                }
                finally {
                    FeatureProxyRenderer.this.rendering = false;
                }
            }
        };
        return this.lastRunnable;
    }

    private void setRenderError(String strError) {
        if (this.contentID instanceof Layerable) {
            ((Layerable)this.contentID).setRenderError(strError);
        }
    }

    private boolean noRenderError() {
        if (this.contentID instanceof Layerable) {
            return ((Layerable)this.contentID).getRenderError() == null;
        }
        return true;
    }

    @Override
    public void cancel() {
        if (this.lastRunnable != null) {
            this.lastRunnable.cancel();
        }
    }

    private long fillFeatureList(Collection<SimpleFeature> lstFeatures, CancelableRunnable runnable) throws Exception {
        long count = 0L;
        try (FeatureIterator<SimpleFeature> fi = this.getFeatureIteratorProxy().getRenderIterator(this.getEnvelope());){
            while (fi.hasNext()) {
                SimpleFeature feature = (SimpleFeature)fi.next();
                if (runnable.isCanceled()) break;
                Geometry geom = (Geometry)feature.getDefaultGeometry();
                if (geom == null || geom.isEmpty()) continue;
                count += (long)geom.getCoordinates().length;
                lstFeatures.add(feature);
            }
            long l = count;
            return l;
        }
    }

    private void renderWithDrawer(Drawer drawer, StyleRenderer style, CancelableRunnable runnable, ShapeFeatureSTRtree tree, Collection<SimpleFeature> lstFeatures) throws Exception {
        if (style == null) {
            throw new NullPointerException(String.format("drawer '%s', content '%s': style is null (maybe JumpModelIntelligence is not initialized?)", drawer.getClass().getName(), this.contentID));
        }
        long count = 0L;
        FeatureIteratorProxy fProxy = this.getFeatureIteratorProxy();
        if (fProxy instanceof Layer) {
            Layer layer = (Layer)fProxy;
            if (!layer.isVisibleOnScreen()) {
                this.clearImageCache();
                return;
            }
            style.initialize(layer.getValidStyleCollection());
        }
        if (runnable != null && runnable.isCanceled()) {
            return;
        }
        boolean bolNoRendering = true;
        if (style.needsRendering()) {
            bolNoRendering = false;
            for (SimpleFeature feature : lstFeatures) {
                if (runnable != null && runnable.isCanceled()) break;
                Geometry geom = (Geometry)feature.getDefaultGeometry();
                if (geom == null || geom.isEmpty()) continue;
                count += (long)geom.getCoordinates().length;
                drawer.draw(style, feature, this.getViewport(), tree);
            }
        }
        if (runnable != null && runnable.isCanceled()) {
            return;
        }
        if ((count > 0L || bolNoRendering) && style.getDecorationRenderer() != null && style.getDecorationRenderer().size() > 0) {
            for (StyleRenderer decStyle : style.getDecorationRenderer()) {
                if (!decStyle.isEnabled()) continue;
                this.renderWithDrawer(drawer, decStyle, runnable, tree, lstFeatures);
            }
        }
    }

    private ShapeFeatureSTRtree getIndex4Selection() {
        FeatureIteratorProxy fProxy = this.getFeatureIteratorProxy();
        if (fProxy instanceof Layer) {
            return ((Layer)fProxy).createEmptyRenderIndex();
        }
        return new ShapeFeatureSTRtree();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void renderFeatures(CancelableRunnable runnable) throws Exception {
        this.lockRendering.lock();
        try {
            ArrayList<SimpleFeature> lstFeatures = new ArrayList<SimpleFeature>();
            StopWatch sw = new StopWatch();
            sw.start();
            long count = this.fillFeatureList(lstFeatures, runnable);
            sw.stop();
            LOG.info("fill: {} ms, Layer: '{}', #features: {}", new Object[]{sw.getTime(), this.contentID, lstFeatures.size()});
            if (count == 0L) {
                this.clearImageCache();
            } else if (!runnable.isCanceled()) {
                this.setCopyToFeatures(lstFeatures);
            }
        }
        finally {
            this.lockRendering.unlock();
        }
    }

    public Envelope getEnvelope() {
        return this.getViewport().getEnvelopeInModelCoordinates();
    }

    private static interface Drawer {
        public void draw(StyleRenderer var1, SimpleFeature var2, Viewport var3, ShapeFeatureSTRtree var4) throws Exception;
    }
}

