/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.renderer;

import com.vividsolutions.jump.workbench.model.FeatureIteratorProxy;
import com.vividsolutions.jump.workbench.model.StyleCollection;
import com.vividsolutions.jump.workbench.ui.GUIUtil;
import com.vividsolutions.jump.workbench.ui.Viewport;
import com.vividsolutions.jump.workbench.ui.renderer.FeatureProxyRenderer;
import com.vividsolutions.jump.workbench.ui.renderer.RenderContext;
import com.vividsolutions.jump.workbench.ui.renderer.style.RenderUtil;
import com.vividsolutions.jump.workbench.ui.renderer.style.StyleRenderer;
import com.vividsolutions.jump.workbench.ui.selection.SelectionManager;
import de.riwagis.geotools.feature.CollectionFeatureIterator;
import de.riwagis.geotools.feature.ShapeFeatureSTRtree;
import de.riwagis.geotools.feature.util.FeatureUtil;
import de.riwagis.riwajump.model.JumpModel;
import de.riwagis.riwajump.model.event.JumpModelEvent;
import de.riwagis.riwajump.model.intelligence.JumpModelIntelligence;
import de.riwagis.riwajump.model.style.StyleModel;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import org.geotools.feature.FeatureIterator;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.Point;
import org.opengis.feature.simple.SimpleFeature;

public abstract class AbstractSelectionRenderer
extends FeatureProxyRenderer
implements StyleRenderer,
JumpModelIntelligence {
    private static final int HANDLE_WIDTH = 5;
    private static final int HANDLE_WIDTH_POINT = 9;
    private static final Collection<SimpleFeature> lstDummyFeature = Arrays.asList(FeatureUtil.getWKTFeature((String)"POINT(0 0)"));
    private boolean enabled = true;
    private final Stroke handleStroke = new BasicStroke(1.0f);
    private final Color handleFillColor;
    private final Color handleLineColor = Color.black;
    private final Stroke lineStroke = new BasicStroke(2.0f);
    private final Color lineColor;
    private final Stroke fillStroke = new BasicStroke(1.0f);
    private final Color fillColor;
    private final boolean filling;
    private final boolean paintingHandles;
    private final SelectionManager selectionManager;
    private final StyleModel fakeModel;

    public AbstractSelectionRenderer(Object contentID, RenderContext renderContext, SelectionManager selectionManager, Color color, boolean paintingHandles, boolean filling) {
        super(contentID, renderContext);
        this.handleFillColor = color;
        this.lineColor = color;
        this.fillColor = GUIUtil.alphaColor(Color.MAGENTA, 75);
        this.paintingHandles = paintingHandles;
        this.filling = filling;
        this.selectionManager = selectionManager;
        this.fakeModel = new StyleModel(){

            public JumpModelIntelligence getIntelligence() {
                return AbstractSelectionRenderer.this;
            }

            public void cleanUp() {
            }

            public boolean isEnabled() {
                return true;
            }
        };
    }

    public JumpModel getModel() {
        return this.fakeModel;
    }

    public void fireJumpModelChanged(JumpModelEvent modelEvent) {
    }

    public AbstractSelectionRenderer clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException("Cloning of AbstractSelectionRenderer is not supported.");
    }

    public String getName() {
        throw new UnsupportedOperationException();
    }

    public Icon getIcon() {
        throw new UnsupportedOperationException();
    }

    public SelectionManager getSelectionManager() {
        return this.selectionManager;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public void initialize(StyleCollection sCol) {
    }

    @Override
    public List<StyleRenderer> getDecorationRenderer() {
        return null;
    }

    @Override
    public void paint(SimpleFeature f, Graphics2D g, Viewport viewport, ShapeFeatureSTRtree tree) throws NoninvertibleTransformException {
        Envelope env = viewport.getEnvelopeInModelCoordinates();
        for (Object currObj : this.getSelectedItems()) {
            this.paint(env, (Geometry)currObj, g, viewport);
        }
    }

    private void paint(Envelope env, Geometry geometry, Graphics2D g, Viewport viewport) throws NoninvertibleTransformException {
        if (geometry == null) {
            return;
        }
        if (env.intersects(geometry.getEnvelopeInternal())) {
            RenderUtil.paint(geometry, g, viewport, this.filling, this.fillStroke, this.fillColor, true, this.lineStroke, this.lineColor, false, true);
            if (this.paintingHandles) {
                AbstractSelectionRenderer.paintHandles(env, g, geometry, this.handleStroke, this.handleFillColor, this.handleLineColor, this.getViewport());
            }
        }
    }

    @Override
    protected Collection<StyleModel> styles() {
        return Collections.singleton(this.fakeModel);
    }

    @Override
    protected FeatureIteratorProxy getFeatureIteratorProxy() {
        FeatureIteratorProxy fread = new FeatureIteratorProxy(this){

            @Override
            public FeatureIterator<SimpleFeature> getRenderIterator(Envelope env) {
                return new CollectionFeatureIterator(lstDummyFeature);
            }
        };
        return fread;
    }

    protected int featureCount() {
        int counter = 10000;
        return counter;
    }

    protected abstract Collection<?> getSelectedItems();

    private static Shape handle(Point2D point, int intHandleWidth) {
        Rectangle2D.Double handle = new Rectangle2D.Double(0.0, 0.0, intHandleWidth, intHandleWidth);
        handle.x = point.getX() - (double)intHandleWidth / 2.0;
        handle.y = point.getY() - (double)intHandleWidth / 2.0;
        return handle;
    }

    private static void paintHandles(Envelope env, Graphics2D g, Geometry geometry, Stroke stroke, Color fillColor, Color lineColor, Viewport viewport) throws NoninvertibleTransformException {
        if (geometry instanceof GeometryCollection) {
            GeometryCollection gcol = (GeometryCollection)geometry;
            for (int i = 0; i < gcol.getNumGeometries(); ++i) {
                AbstractSelectionRenderer.paintHandles(env, g, gcol.getGeometryN(i), stroke, fillColor, lineColor, viewport);
            }
            return;
        }
        Coordinate[] coordinates = geometry.getCoordinates();
        int intHandleWidth = 5;
        if (geometry instanceof Point) {
            intHandleWidth = 9;
        }
        g.setStroke(stroke);
        g.setColor(fillColor);
        for (Coordinate coordinate : coordinates) {
            if (!env.contains(coordinate)) continue;
            g.fill(AbstractSelectionRenderer.handle(viewport.toViewPoint(new Point2D.Double(coordinate.x, coordinate.y)), intHandleWidth));
        }
        g.setColor(lineColor);
        for (Coordinate coordinate : coordinates) {
            if (!viewport.getEnvelopeInModelCoordinates().contains(coordinate)) continue;
            g.draw(AbstractSelectionRenderer.handle(viewport.toViewPoint(new Point2D.Double(coordinate.x, coordinate.y)), intHandleWidth));
        }
    }

    @Override
    public boolean needsRendering() {
        return true;
    }
}

