/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.plugin.wmts;

import com.vividsolutions.jump.workbench.model.StyleCollection;
import com.vividsolutions.jump.workbench.ui.Viewport;
import com.vividsolutions.jump.workbench.ui.renderer.style.AbstractRasterStyleRenderer;
import com.vividsolutions.jump.workbench.ui.renderer.style.StyleRenderer;
import com.vividsolutions.ows.wmts.WMTService;
import de.riwagis.geotools.feature.ShapeFeatureSTRtree;
import de.riwagis.riwajump.model.JumpModel;
import de.riwagis.riwajump.model.event.JumpModelEvent;
import de.riwagis.riwajump.model.intelligence.IntelligenceFactory;
import de.riwagis.riwajump.model.style.WMTSStyleModel;
import java.awt.Graphics2D;
import java.io.IOException;
import java.util.List;
import org.opengis.feature.simple.SimpleFeature;

public class WMTSStyleRenderer
extends AbstractRasterStyleRenderer {
    private WMTService wmtService = null;
    private boolean bolURLChanged = true;
    private final WMTSStyleModel wmtsStyle;

    public WMTSStyleRenderer(WMTSStyleModel wmtsStyle) {
        this.wmtsStyle = wmtsStyle;
    }

    public JumpModel getModel() {
        return this.wmtsStyle;
    }

    public void fireJumpModelChanged(JumpModelEvent modelEvent) {
        if (modelEvent.getPropertyName().equalsIgnoreCase("serverNeedsLogin") || modelEvent.getPropertyName().equalsIgnoreCase("serverLoginName") || modelEvent.getPropertyName().equalsIgnoreCase("serverLoginPwd") || modelEvent.getPropertyName().equalsIgnoreCase("strServerURL") || modelEvent.getPropertyName().equalsIgnoreCase("strVersion")) {
            this.bolURLChanged = true;
        }
    }

    @Override
    public boolean isEnabled() {
        return this.wmtsStyle.isEnabled();
    }

    @Override
    public void initialize(StyleCollection _sCol) {
    }

    @Override
    public List<StyleRenderer> getDecorationRenderer() {
        return null;
    }

    @Override
    public void paint(SimpleFeature f, Graphics2D g, Viewport viewport, ShapeFeatureSTRtree tree) throws Exception {
    }

    public void setWMTService(WMTService wmtService) {
        this.wmtService = wmtService;
        this.wmtsStyle.setServerURL(wmtService.getServerUrlExt());
        this.wmtsStyle.setVersion(wmtService.getVersion());
        this.wmtsStyle.setServerNeedsLogin(wmtService.getServerNeedsLogin());
        this.wmtsStyle.setServerLoginName(wmtService.getServerLoginName());
        this.wmtsStyle.setServerLoginPwd(wmtService.getServerLoginPwd());
        this.bolURLChanged = false;
    }

    public synchronized WMTService getWMTService() throws IOException {
        if (this.doesWMTServiceNeedInitialisation()) {
            WMTService wmtServiceTmp = new WMTService(this.wmtsStyle.getServerURL());
            wmtServiceTmp.setServerNeedsLogin(this.wmtsStyle.isServerNeedsLogin());
            wmtServiceTmp.setServerLoginName(this.wmtsStyle.getServerLoginName());
            wmtServiceTmp.setServerLoginPwd(this.wmtsStyle.getServerLoginPwd());
            wmtServiceTmp.initialize();
            this.bolURLChanged = false;
            this.wmtService = wmtServiceTmp;
        }
        return this.wmtService;
    }

    public synchronized boolean doesWMTServiceNeedInitialisation() {
        return this.wmtService == null || this.wmtService.getCapabilities() == null || this.bolURLChanged;
    }

    @Override
    public boolean needsRendering() {
        return true;
    }

    static {
        IntelligenceFactory.register(WMTSStyleModel.class, WMTSStyleRenderer::new);
    }
}

