/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.plugin.wmts;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.workbench.model.RiwaJumpModelUtilities;
import com.vividsolutions.jump.workbench.model.SimpleStyleCollection;
import com.vividsolutions.jump.workbench.model.StyleCollection;
import com.vividsolutions.jump.workbench.ui.ColorChooserPanel;
import com.vividsolutions.jump.workbench.ui.GUIUtil;
import com.vividsolutions.jump.workbench.ui.TransparencyPanel;
import com.vividsolutions.jump.workbench.ui.plugin.wms.OWSURLDialog;
import com.vividsolutions.jump.workbench.ui.renderer.style.RenderUtil;
import com.vividsolutions.jump.workbench.ui.style.AbstractStylePanel;
import com.vividsolutions.ows.OWService;
import com.vividsolutions.ows.wms.MapImageFormatChooser;
import com.vividsolutions.ows.wmts.Layer;
import com.vividsolutions.ows.wmts.Style;
import com.vividsolutions.ows.wmts.WMTService;
import de.riwagis.riwajump.model.style.StyleModel;
import de.riwagis.riwajump.model.style.WMTSStyleModel;
import de.riwagis.util.gui.GUISupport;
import de.riwagis.util.lang.StringComparator;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Hashtable;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.commons.lang3.ObjectUtils;
import org.locationtech.jts.util.Assert;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WMTSLayerPanel
extends AbstractStylePanel {
    private SimpleStyleCollection sCol = null;
    private WMTSStyleModel style = null;
    private static final Logger LOG = LoggerFactory.getLogger(WMTSLayerPanel.class);
    private boolean blockEvents = false;
    private JButton butURL;
    private JCheckBox cboUseClearColor;
    private JComboBox<String> cmbFormat;
    private JComboBox<String> cmbStyle;
    private JComboBox<String> cmbTMS;
    private ColorChooserPanel colorChooserClearColor;
    private Box.Filler filler1;
    private JPanel jPanel1;
    private JPanel jPanel4;
    private JScrollPane jScrollPane1;
    private JTabbedPane jTabbedPane1;
    private JLabel lblFormat;
    private JLabel lblLayer;
    private JLabel lblServerURL;
    private JLabel lblStyle;
    private JLabel lblTMS;
    private JLabel lblTransparency;
    private JLabel lblURL;
    private JLabel lblVersion;
    private JLabel lblWMTSVersion;
    private JList<String> liLayer;
    private JPanel pnlOptions;
    private JPanel pnlWMTSLayer;
    private JTextField thresholdField;
    private JPanel tileSetPanel;
    private JSlider tileSetThresholdSlider;
    private TransparencyPanel transparencyPanel;
    private JTextField txtTransparency;

    public WMTSLayerPanel() {
        this.initComponents();
        this.i18n();
        this.init();
    }

    private void i18n() {
        this.butURL.setText(I18N.get("ui.plugin.wmts.WMTSLayerPanel.choose-url"));
        this.lblServerURL.setText(I18N.get("ui.plugin.wmts.WMTSLayerPanel.url"));
        this.lblTMS.setText(I18N.get("ui.plugin.wmts.WMTSLayerPanel.tms"));
        this.lblFormat.setText(I18N.get("ui.plugin.wmts.WMTSLayerPanel.format"));
        this.lblStyle.setText(I18N.get("ui.plugin.wmts.WMTSLayerPanel.style"));
        this.lblLayer.setText(I18N.get("ui.plugin.wmts.WMTSLayerPanel.layer"));
        this.lblVersion.setText(I18N.get("ui.plugin.wmts.WMTSLayerPanel.version"));
        this.lblTransparency.setText(I18N.get("ui.plugin.wmts.WMTSLayerPanel.transparency"));
        this.cboUseClearColor.setText(I18N.get("ui.plugin.wmts.WMTSLayerPanel.useClearColor"));
        this.jTabbedPane1.setTitleAt(0, I18N.get("ui.plugin.wmts.WMTSLayerPanel.tab-layer"));
        this.jTabbedPane1.setTitleAt(1, I18N.get("ui.plugin.wmts.WMTSLayerPanel.tab-options"));
        this.jPanel1.setBorder(BorderFactory.createTitledBorder(I18N.get("ui.plugin.wmts.WMTSLayerPanel.border-transparency")));
        Hashtable<Integer, JLabel> labels = new Hashtable<Integer, JLabel>();
        labels.put(0, new JLabel(I18N.get("ui.plugin.wmts.WMTSLayerPanel.tileset-threshold-value-min")));
        labels.put(50, new JLabel(I18N.get("ui.plugin.wmts.WMTSLayerPanel.tileset-threshold-value-avg")));
        labels.put(100, new JLabel(I18N.get("ui.plugin.wmts.WMTSLayerPanel.tileset-threshold-value-max")));
        this.tileSetThresholdSlider.setLabelTable(labels);
        this.tileSetPanel.setBorder(BorderFactory.createTitledBorder(I18N.get("ui.plugin.wmts.WMTSLayerPanel.tileset-threshold-title")));
    }

    private void init() {
        this.lblURL.setText("");
        this.lblVersion.setText("");
        this.setEnabledState();
        this.updateControls();
        this.liLayer.setSelectionMode(0);
        this.liLayer.addListSelectionListener(e -> {
            if (this.blockEvents) {
                return;
            }
            boolean bolTemp = this.blockEvents;
            this.blockEvents = true;
            try {
                this.fillTMSComboBox();
                this.fillStyleComboBox();
                this.fillFormatComboBox();
                if (this.style != null && this.cmbTMS.getSelectedItem() != null) {
                    this.style.setTileMatrixSet(this.cmbTMS.getSelectedItem().toString());
                    this.style.setLayerName(this.liLayer.getSelectedValue());
                }
            }
            finally {
                this.blockEvents = bolTemp;
            }
        });
        this.transparencyPanel.addChangeListener(event -> {
            if (this.blockEvents) {
                return;
            }
            if (this.style != null) {
                this.style.setAlpha(this.transparencyPanel.getAlpha());
            }
        });
    }

    private Layer getLayer() {
        if (this.liLayer.getSelectionModel().isSelectionEmpty()) {
            return null;
        }
        try {
            return this.getWMTService().getCapabilities().getLayerByName(this.liLayer.getSelectedValue());
        }
        catch (IOException ex) {
            return null;
        }
    }

    private void fillLayerList() throws IOException {
        String oldLayer = null;
        if (this.style != null) {
            oldLayer = this.style.getLayerName();
        }
        this.liLayer.removeAll();
        ArrayList<String> layers = new ArrayList<String>(this.getWMTService().getCapabilities().getLayerNames());
        if (layers.isEmpty()) {
            return;
        }
        Collections.sort(layers, new StringComparator());
        DefaultListModel<String> model = new DefaultListModel<String>();
        this.liLayer.setModel(model);
        for (String layer : layers) {
            model.addElement(layer);
        }
        this.liLayer.setSelectedValue(oldLayer, true);
    }

    private void fillTMSComboBox() {
        String oldTMS = null;
        if (this.style != null) {
            oldTMS = this.style.getTileMatrixSet();
        }
        this.cmbTMS.removeAllItems();
        Layer layer = this.getLayer();
        if (layer == null) {
            return;
        }
        ArrayList<String> lstTMS = new ArrayList<String>(layer.getTileMatrixSetLinks());
        if (lstTMS.isEmpty()) {
            return;
        }
        Collections.sort(lstTMS, new StringComparator());
        for (String tms : lstTMS) {
            this.cmbTMS.addItem(tms);
        }
        this.cmbTMS.setSelectedItem(oldTMS);
    }

    private void fillStyleComboBox() {
        String oldStyle = null;
        if (this.style != null) {
            oldStyle = this.style.getStyle();
        }
        this.cmbStyle.removeAllItems();
        Layer layer = this.getLayer();
        if (layer == null) {
            return;
        }
        ArrayList<Style> styles = new ArrayList<Style>(layer.getStyles());
        if (styles.isEmpty()) {
            return;
        }
        Collections.sort(styles, new Comparator<Style>(this){

            @Override
            public int compare(Style o1, Style o2) {
                if (o1.isDefault()) {
                    return 1;
                }
                if (o2.isDefault()) {
                    return -1;
                }
                return o1.getIdentifier().compareTo(o2.getIdentifier());
            }
        });
        for (Style style : styles) {
            this.cmbStyle.addItem(style.getIdentifier());
            if (!style.isDefault() || oldStyle != null) continue;
            oldStyle = style.getIdentifier();
        }
        this.cmbStyle.setSelectedItem(oldStyle);
    }

    private void fillFormatComboBox() {
        String oldFormat = null;
        if (this.style != null) {
            oldFormat = this.style.getFormat();
        }
        this.cmbFormat.removeAllItems();
        Layer layer = this.getLayer();
        if (layer == null) {
            return;
        }
        ArrayList<String> formats = new ArrayList<String>(layer.getFormats());
        if (formats.isEmpty()) {
            return;
        }
        Collections.sort(formats, new StringComparator());
        for (String format : formats) {
            this.cmbFormat.addItem(format);
        }
        this.cmbFormat.setSelectedItem(oldFormat);
    }

    private void setEnabledState() {
        boolean enabled = this.style != null;
        this.lblURL.setEnabled(enabled);
        this.lblVersion.setEnabled(enabled);
        this.transparencyPanel.setEnabled(enabled);
        this.txtTransparency.setEnabled(enabled);
        this.cmbTMS.setEnabled(enabled);
        this.liLayer.setEnabled(enabled);
        this.tileSetThresholdSlider.setEnabled(enabled);
        this.thresholdField.setEnabled(enabled);
    }

    @Override
    public String validateInput() {
        if (this.style == null) {
            return I18N.get("common.error") + " : " + I18N.get("ui.plugin.wmts.WMTSLayerPanel.choose-url");
        }
        if (this.liLayer.getSelectedValue() == null) {
            return I18N.get("common.error") + " : " + I18N.get("ui.plugin.wmts.WMTSLayerPanel.choose-layer");
        }
        this.style.setLayerName(this.liLayer.getSelectedValue());
        if (this.cmbTMS.getSelectedItem() == null) {
            return I18N.get("common.error") + " : " + I18N.get("ui.plugin.wmts.WMTSLayerPanel.choose-tms");
        }
        this.style.setTileMatrixSet((String)this.cmbTMS.getSelectedItem());
        if (this.cmbFormat.getSelectedItem() == null) {
            return I18N.get("common.error") + " : " + I18N.get("ui.plugin.wmts.WMTSLayerPanel.choose-format");
        }
        this.style.setFormat((String)this.cmbFormat.getSelectedItem());
        if (this.cmbStyle.getSelectedItem() == null) {
            return I18N.get("common.error") + " : " + I18N.get("ui.plugin.wmts.WMTSLayerPanel.choose-style");
        }
        this.style.setStyle((String)this.cmbStyle.getSelectedItem());
        return null;
    }

    @Override
    public String getTitle() {
        return I18N.get("ui.plugin.wmts.WMTSLayerPanel.edit-title");
    }

    @Override
    public void setStyleCollection(StyleCollection _sCol) {
        this.sCol = (SimpleStyleCollection)_sCol;
        WMTSStyleModel wmtsStyle = this.sCol.getStyle(WMTSStyleModel.class);
        if (wmtsStyle != null) {
            this.setWMTSStyle(wmtsStyle);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateStyles() {
        if (this.sCol != null) {
            boolean firingEvents = this.sCol.getLayerable().getLayerManager().isFiringEvents();
            this.sCol.getLayerable().getLayerManager().setFiringEvents(false);
            try {
                WMTSStyleModel oldStyle = this.sCol.getStyle(WMTSStyleModel.class);
                WMTSStyleModel newStyle = this.getWMTSStyle();
                if (oldStyle != null) {
                    this.sCol.removeStyle((StyleModel)oldStyle);
                }
                this.sCol.addStyle((StyleModel)newStyle);
            }
            finally {
                this.sCol.getLayerable().getLayerManager().setFiringEvents(firingEvents);
            }
        } else {
            Assert.shouldNeverReachHere();
        }
    }

    public void showURLDialog() {
        OWSURLDialog urlDialog = null;
        Window parent = SwingUtilities.windowForComponent(this);
        if (parent instanceof Frame) {
            urlDialog = new OWSURLDialog((Frame)parent, OWService.OWSType.WMTS);
        }
        if (parent instanceof Dialog) {
            urlDialog = new OWSURLDialog((Dialog)parent, OWService.OWSType.WMTS);
        }
        GUIUtil.centreOnScreen(urlDialog);
        if (this.style != null) {
            urlDialog.setURL(this.style.getServerURL());
            urlDialog.setVersion(this.style.getVersion());
            urlDialog.setServerNeedsLogin(this.style.isServerNeedsLogin());
            urlDialog.setServerLoginName(this.style.getServerLoginName());
            urlDialog.setServerLoginPwd(this.style.getServerLoginPwd());
        }
        urlDialog.setVisible(true);
        if (urlDialog.wasOKPressed()) {
            if (this.style == null) {
                this.style = new WMTSStyleModel();
            }
            String strURL = urlDialog.getURL();
            String strVersion = urlDialog.getVersion();
            WMTService tmpWMTS = null;
            try {
                tmpWMTS = new WMTService(strURL);
                tmpWMTS.setServerNeedsLogin(urlDialog.getServerNeedsLogin());
                tmpWMTS.setServerLoginName(urlDialog.getServerLoginName());
                tmpWMTS.setServerLoginPwd(urlDialog.getServerLoginPwd());
                tmpWMTS.initialize();
            }
            catch (Exception e) {
                LOG.error(I18N.get("ui.plugin.ows.OWSURLDialog.url-error"), (Throwable)e);
                JOptionPane.showMessageDialog(this, I18N.get("ui.plugin.ows.OWSURLDialog.url-error"), I18N.get("common.error"), 0);
                this.style.setServerURL(strURL);
                this.style.setVersion(strVersion);
                this.style.setServerNeedsLogin(urlDialog.getServerNeedsLogin());
                this.style.setServerLoginName(urlDialog.getServerLoginName());
                this.style.setServerLoginPwd(urlDialog.getServerLoginPwd());
                this.updateControls();
                return;
            }
            RenderUtil.getRenderer(this.style).setWMTService(tmpWMTS);
            MapImageFormatChooser formatChooser = new MapImageFormatChooser(this.style.getVersion());
            formatChooser.setPreferLossyCompression(false);
            formatChooser.setTransparencyRequired(true);
            try {
                Layer layer = this.getLayer();
                if (layer != null) {
                    this.style.setFormat(formatChooser.chooseFormat(layer.getFormats()));
                }
            }
            catch (Exception ioe) {
                GUISupport.msgbox((Component)this, (String)"Error connecting WMTS Server", (String)I18N.get("common.error"));
                LOG.error("Error connecting WMTS Server", (Throwable)ioe);
            }
            this.updateControls();
        }
    }

    private WMTService getWMTService() throws IOException {
        return RenderUtil.getRenderer(this.style).getWMTService();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateControls() {
        block12: {
            boolean bolTemp = this.blockEvents;
            this.blockEvents = true;
            try {
                this.setEnabledState();
                this.lblURL.setForeground(Color.BLACK);
                if (this.style == null) break block12;
                this.lblURL.setText(this.style.getServerURL());
                this.lblURL.setToolTipText(this.style.getServerURL());
                this.lblVersion.setText(this.style.getVersion());
                this.txtTransparency.setText("" + (255 - this.style.getAlpha()));
                WMTService srv = null;
                String strURL = ObjectUtils.toString((Object)this.style.getServerURL());
                String strError = null;
                if (!strURL.isEmpty()) {
                    try {
                        srv = this.getWMTService();
                    }
                    catch (IOException ioe) {
                        srv = null;
                        LOG.error("Error connection: " + strURL, (Throwable)ioe);
                        strError = ioe.getMessage();
                        strError = strError.replaceAll("<", "&lt;");
                        strError = strError.replaceAll(">", "&gt;");
                        strError = strError.replaceAll("\\n", "<br>");
                    }
                }
                if (srv != null) {
                    this.cmbTMS.setEnabled(true);
                    this.cmbFormat.setEnabled(true);
                    this.cmbStyle.setEnabled(true);
                    this.liLayer.setEnabled(true);
                    this.transparencyPanel.getSlider().setEnabled(true);
                    this.tileSetThresholdSlider.setEnabled(true);
                    this.thresholdField.setEnabled(true);
                    this.fillLayerList();
                    this.fillTMSComboBox();
                    this.fillStyleComboBox();
                    this.fillFormatComboBox();
                    this.cboUseClearColor.setEnabled(true);
                    this.cboUseClearColor.setSelected(this.style.isUseClearColor());
                    this.colorChooserClearColor.setAlpha(255);
                    this.colorChooserClearColor.setColor(RiwaJumpModelUtilities.colorByColorModel(this.style.getClearColor()));
                    this.colorChooserClearColor.setEnabled(this.style.isUseClearColor());
                    this.tileSetThresholdSlider.setValue((int)(this.style.getTileSetThreshold() * 100.0));
                    this.thresholdField.setText(String.valueOf((int)(this.style.getTileSetThreshold() * 100.0)));
                } else {
                    this.cmbTMS.setEnabled(false);
                    this.cmbFormat.setEnabled(false);
                    this.cmbStyle.setEnabled(false);
                    this.liLayer.setEnabled(false);
                    this.transparencyPanel.getSlider().setEnabled(false);
                    this.tileSetThresholdSlider.setEnabled(false);
                    this.thresholdField.setEnabled(false);
                    if (!strURL.isEmpty()) {
                        this.lblURL.setForeground(Color.RED);
                        this.lblURL.setToolTipText(I18N.getMessage("ui.plugin.wmts.WMTSLayerPanel.error-net", strURL, strError));
                        this.lblURL.setText(I18N.get("common.error") + ": " + strURL);
                    } else {
                        this.lblURL.setToolTipText("");
                        this.lblURL.setText(I18N.get("ui.plugin.wmts.WMTSLayerPanel.choose-url"));
                    }
                    this.colorChooserClearColor.setEnabled(false);
                    this.cboUseClearColor.setEnabled(false);
                }
            }
            catch (Exception ioe) {
                LOG.error("WMTSLayerPanel. Error updating controls:", (Throwable)ioe);
                GUISupport.msgbox((Component)this, (String)"WMTSLayerPanel. Error updating controls.", (String)I18N.get("common.error"));
            }
            finally {
                this.blockEvents = bolTemp;
            }
        }
    }

    public void setWMTSStyle(WMTSStyleModel _style) {
        try {
            this.style = _style.clone();
        }
        catch (CloneNotSupportedException cns) {
            throw new RuntimeException("Should never reach here", cns);
        }
        this.updateControls();
    }

    public WMTSStyleModel getWMTSStyle() {
        return this.style;
    }

    public void setOptionsTabEnabled(boolean enabled) {
        this.pnlOptions.setEnabled(enabled);
        this.jTabbedPane1.setEnabledAt(1, enabled);
    }

    private void initComponents() {
        this.jPanel4 = new JPanel();
        this.lblServerURL = new JLabel();
        this.lblURL = new JLabel();
        this.butURL = new JButton();
        this.lblWMTSVersion = new JLabel();
        this.lblVersion = new JLabel();
        this.jTabbedPane1 = new JTabbedPane();
        this.pnlWMTSLayer = new JPanel();
        this.lblLayer = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.liLayer = new JList();
        this.lblTMS = new JLabel();
        this.cmbTMS = new JComboBox();
        this.lblFormat = new JLabel();
        this.cmbFormat = new JComboBox();
        this.lblStyle = new JLabel();
        this.cmbStyle = new JComboBox();
        this.pnlOptions = new JPanel();
        this.jPanel1 = new JPanel();
        this.lblTransparency = new JLabel();
        this.transparencyPanel = new TransparencyPanel();
        this.txtTransparency = GUIUtil.createSyncdTextField(this.transparencyPanel.getSlider(), 3);
        this.cboUseClearColor = new JCheckBox();
        this.colorChooserClearColor = new ColorChooserPanel();
        this.tileSetPanel = new JPanel();
        this.tileSetThresholdSlider = new JSlider();
        this.thresholdField = GUIUtil.createSyncdTextField(this.tileSetThresholdSlider, 3);
        this.filler1 = new Box.Filler(new Dimension(0, 0), new Dimension(0, 0), new Dimension(Short.MAX_VALUE, Short.MAX_VALUE));
        this.setLayout(new BorderLayout(0, 10));
        this.jPanel4.setLayout(new GridBagLayout());
        this.lblServerURL.setText("Server URL:");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(9, 6, 3, 3);
        this.jPanel4.add((Component)this.lblServerURL, gridBagConstraints);
        this.lblURL.setText("URL...");
        this.lblURL.setMaximumSize(new Dimension(250, 14));
        this.lblURL.setMinimumSize(new Dimension(250, 14));
        this.lblURL.setPreferredSize(new Dimension(250, 14));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 2.0;
        gridBagConstraints.insets = new Insets(9, 3, 3, 3);
        this.jPanel4.add((Component)this.lblURL, gridBagConstraints);
        this.butURL.setText("URL w\u00e4hlen");
        this.butURL.setPreferredSize(new Dimension(130, 23));
        this.butURL.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                WMTSLayerPanel.this.butURL_onActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 3, 3, 7);
        this.jPanel4.add((Component)this.butURL, gridBagConstraints);
        this.lblWMTSVersion.setText("WMTS-Version:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(3, 6, 3, 3);
        this.jPanel4.add((Component)this.lblWMTSVersion, gridBagConstraints);
        this.lblVersion.setText("1.0.0");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel4.add((Component)this.lblVersion, gridBagConstraints);
        this.add((Component)this.jPanel4, "North");
        this.pnlWMTSLayer.setLayout(new GridBagLayout());
        this.lblLayer.setText("Layer:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 12;
        gridBagConstraints.insets = new Insets(3, 6, 3, 3);
        this.pnlWMTSLayer.add((Component)this.lblLayer, gridBagConstraints);
        this.liLayer.setModel(new DefaultListModel());
        this.jScrollPane1.setViewportView(this.liLayer);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 19;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.pnlWMTSLayer.add((Component)this.jScrollPane1, gridBagConstraints);
        this.lblTMS.setText("Tile Matrix Set:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(3, 6, 3, 3);
        this.pnlWMTSLayer.add((Component)this.lblTMS, gridBagConstraints);
        this.cmbTMS.setMinimumSize(new Dimension(130, 22));
        this.cmbTMS.setPreferredSize(new Dimension(130, 22));
        this.cmbTMS.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                WMTSLayerPanel.this.cmbTMS_onActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.pnlWMTSLayer.add(this.cmbTMS, gridBagConstraints);
        this.lblFormat.setText("Format:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(3, 6, 3, 3);
        this.pnlWMTSLayer.add((Component)this.lblFormat, gridBagConstraints);
        this.cmbFormat.setMinimumSize(new Dimension(130, 22));
        this.cmbFormat.setPreferredSize(new Dimension(130, 22));
        this.cmbFormat.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                WMTSLayerPanel.this.cmbFormat_onActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.pnlWMTSLayer.add(this.cmbFormat, gridBagConstraints);
        this.lblStyle.setText("Style:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new Insets(3, 6, 3, 3);
        this.pnlWMTSLayer.add((Component)this.lblStyle, gridBagConstraints);
        this.cmbStyle.setMinimumSize(new Dimension(130, 22));
        this.cmbStyle.setPreferredSize(new Dimension(130, 22));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.pnlWMTSLayer.add(this.cmbStyle, gridBagConstraints);
        this.jTabbedPane1.addTab("WMTS Layer", this.pnlWMTSLayer);
        this.pnlOptions.setLayout(new GridBagLayout());
        this.jPanel1.setBorder(BorderFactory.createTitledBorder("Transparenz"));
        this.jPanel1.setLayout(new GridBagLayout());
        this.lblTransparency.setText("Transparenz:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.jPanel1.add((Component)this.lblTransparency, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.jPanel1.add((Component)this.transparencyPanel, gridBagConstraints);
        this.txtTransparency.setMinimumSize(new Dimension(200, 20));
        this.txtTransparency.setPreferredSize(new Dimension(200, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.jPanel1.add((Component)this.txtTransparency, gridBagConstraints);
        this.cboUseClearColor.setText("transparente Farbe");
        this.cboUseClearColor.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.cboUseClearColor.setMargin(new Insets(0, 0, 0, 0));
        this.cboUseClearColor.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                WMTSLayerPanel.this.cboUseClearColor_onActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.jPanel1.add((Component)this.cboUseClearColor, gridBagConstraints);
        this.colorChooserClearColor.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                WMTSLayerPanel.this.colorChooserClearColor_onActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.jPanel1.add((Component)this.colorChooserClearColor, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        this.pnlOptions.add((Component)this.jPanel1, gridBagConstraints);
        this.tileSetPanel.setBorder(BorderFactory.createTitledBorder("Ma\u00dfstabsbereichwechsel"));
        this.tileSetPanel.setPreferredSize(new Dimension(430, 83));
        this.tileSetPanel.setLayout(new GridBagLayout());
        this.tileSetThresholdSlider.setMajorTickSpacing(50);
        this.tileSetThresholdSlider.setPaintLabels(true);
        this.tileSetThresholdSlider.setPaintTicks(true);
        this.tileSetThresholdSlider.setName("");
        this.tileSetThresholdSlider.setPreferredSize(new Dimension(300, 45));
        this.tileSetThresholdSlider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                WMTSLayerPanel.this.tileSetThresholdSliderStateChanged(evt);
            }
        });
        this.tileSetPanel.add((Component)this.tileSetThresholdSlider, new GridBagConstraints());
        this.thresholdField.setText("100");
        this.tileSetPanel.add((Component)this.thresholdField, new GridBagConstraints());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        this.pnlOptions.add((Component)this.tileSetPanel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.pnlOptions.add((Component)this.filler1, gridBagConstraints);
        this.jTabbedPane1.addTab("Optionen", this.pnlOptions);
        this.add((Component)this.jTabbedPane1, "Center");
    }

    private void colorChooserClearColor_onActionPerformed(ActionEvent evt) {
        if (this.blockEvents) {
            return;
        }
        if (this.style == null) {
            return;
        }
        this.style.setClearColor(RiwaJumpModelUtilities.colorModelByColor(this.colorChooserClearColor.getColor()));
        this.updateControls();
    }

    private void cboUseClearColor_onActionPerformed(ActionEvent evt) {
        if (this.blockEvents) {
            return;
        }
        if (this.style == null) {
            return;
        }
        this.style.setUseClearColor(this.cboUseClearColor.isSelected());
        this.updateControls();
    }

    private void cmbFormat_onActionPerformed(ActionEvent evt) {
        if (this.blockEvents) {
            return;
        }
        if (this.style == null) {
            return;
        }
        this.style.setFormat(this.cmbFormat.getSelectedItem().toString());
    }

    private void cmbTMS_onActionPerformed(ActionEvent evt) {
        if (this.blockEvents) {
            return;
        }
        if (this.style == null) {
            return;
        }
        this.style.setTileMatrixSet(this.cmbTMS.getSelectedItem().toString());
    }

    private void butURL_onActionPerformed(ActionEvent evt) {
        if (this.blockEvents) {
            return;
        }
        this.showURLDialog();
    }

    private void tileSetThresholdSliderStateChanged(ChangeEvent evt) {
        if (this.blockEvents) {
            return;
        }
        if (this.style == null) {
            return;
        }
        this.style.setTileSetThreshold((double)this.tileSetThresholdSlider.getValue() / 100.0);
    }
}

