/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.plugin.wms;

import com.vividsolutions.jump.workbench.model.StyleCollection;
import com.vividsolutions.jump.workbench.model.Task;
import com.vividsolutions.jump.workbench.ui.Viewport;
import com.vividsolutions.jump.workbench.ui.renderer.style.AbstractRasterStyleRenderer;
import com.vividsolutions.jump.workbench.ui.renderer.style.StyleRenderer;
import com.vividsolutions.ows.wms.WMService;
import de.riwagis.geotools.feature.ShapeFeatureSTRtree;
import de.riwagis.riwajump.model.JumpModel;
import de.riwagis.riwajump.model.event.JumpModelEvent;
import de.riwagis.riwajump.model.intelligence.IntelligenceFactory;
import de.riwagis.riwajump.model.style.WMSStyleModel;
import java.awt.Graphics2D;
import java.io.IOException;
import java.util.List;
import org.apache.http.client.config.RequestConfig;
import org.opengis.feature.simple.SimpleFeature;

public class WMSStyleRenderer
extends AbstractRasterStyleRenderer {
    private static final int TIMEOUT_FASTER = 5000;
    private WMService wmService = null;
    private boolean bolURLChanged = true;
    private final WMSStyleModel wmsStyle;

    public WMSStyleRenderer(WMSStyleModel wmsStyle) {
        this.wmsStyle = wmsStyle;
    }

    public JumpModel getModel() {
        return this.wmsStyle;
    }

    public void fireJumpModelChanged(JumpModelEvent modelEvent) {
        if (modelEvent.getPropertyName().equalsIgnoreCase("serverNeedsLogin") || modelEvent.getPropertyName().equalsIgnoreCase("serverLoginName") || modelEvent.getPropertyName().equalsIgnoreCase("serverLoginPwd") || modelEvent.getPropertyName().equalsIgnoreCase("strServerURL") || modelEvent.getPropertyName().equalsIgnoreCase("strVersion")) {
            this.bolURLChanged = true;
        }
    }

    @Override
    public boolean isEnabled() {
        return this.wmsStyle.isEnabled();
    }

    @Override
    public void initialize(StyleCollection _sCol) {
    }

    @Override
    public List<StyleRenderer> getDecorationRenderer() {
        return null;
    }

    @Override
    public void paint(SimpleFeature f, Graphics2D g, Viewport viewport, ShapeFeatureSTRtree tree) throws Exception {
    }

    public void setWMService(WMService _wmService) {
        this.wmService = _wmService;
        this.wmsStyle.setServerURL(this.wmService.getServerUrlExt());
        this.wmsStyle.setVersion(this.wmService.getVersion());
        this.wmsStyle.setServerNeedsLogin(this.wmService.getServerNeedsLogin());
        this.wmsStyle.setServerLoginName(this.wmService.getServerLoginName());
        this.wmsStyle.setServerLoginPwd(this.wmService.getServerLoginPwd());
        this.bolURLChanged = false;
    }

    private synchronized WMService getWMService(Task task, boolean fasterTimeout) throws IOException {
        if (this.doesWMServiceNeedInitialisation()) {
            WMService wmServiceTmp = new WMService(this.wmsStyle.getServerURL(), this.wmsStyle.getVersion());
            wmServiceTmp.setServerNeedsLogin(this.wmsStyle.isServerNeedsLogin());
            wmServiceTmp.setServerLoginName(this.wmsStyle.getServerLoginName());
            wmServiceTmp.setServerLoginPwd(this.wmsStyle.getServerLoginPwd());
            RequestConfig customRequestConfig = fasterTimeout ? RequestConfig.custom().setConnectTimeout(5000).setSocketTimeout(5000).build() : null;
            wmServiceTmp.initialize(task, customRequestConfig);
            this.bolURLChanged = false;
            this.wmService = wmServiceTmp;
        }
        return this.wmService;
    }

    public WMService getWMService() throws IOException {
        return this.getWMService(null, false);
    }

    public WMService getWMServiceFasterAndCache(Task task) throws IOException {
        return this.getWMService(task, true);
    }

    public synchronized boolean doesWMServiceNeedInitialisation() throws IOException {
        return this.wmService == null || this.wmService.getCapabilities() == null || this.bolURLChanged;
    }

    @Override
    public boolean needsRendering() {
        return true;
    }

    static {
        IntelligenceFactory.register(WMSStyleModel.class, WMSStyleRenderer::new);
    }
}

