/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.plugin.wms;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.model.Layerable;
import com.vividsolutions.jump.workbench.model.WMSLayer;
import com.vividsolutions.jump.workbench.model.WMTSLayer;
import com.vividsolutions.jump.workbench.plugin.AbstractPlugIn;
import com.vividsolutions.jump.workbench.plugin.EnableCheck;
import com.vividsolutions.jump.workbench.plugin.EnableCheckFactory;
import com.vividsolutions.jump.workbench.plugin.MultiEnableCheck;
import com.vividsolutions.jump.workbench.plugin.OrEnableCheck;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.tools.LayerTools;
import com.vividsolutions.jump.workbench.ui.GUIUtil;
import com.vividsolutions.ows.wms.MapLayer;
import com.vividsolutions.ows.wms.MapRequest;
import com.vividsolutions.ows.wmts.GetLegendGraphicRequest;
import com.vividsolutions.ows.wmts.Layer;
import com.vividsolutions.ows.wmts.Style;
import de.riwagis.icons.IconLoader;
import de.riwagis.riwajump.model.style.WMSStyleModel;
import de.riwagis.riwajump.model.style.WMTSStyleModel;
import de.riwagis.util.gui.components.WaitDialog;
import java.awt.Color;
import java.awt.Component;
import java.awt.Image;
import java.awt.LayoutManager;
import java.awt.Window;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import org.apache.commons.lang3.StringUtils;
import org.jdesktop.swingx.JXPanel;
import org.jdesktop.swingx.JXTaskPane;
import org.jdesktop.swingx.JXTaskPaneContainer;
import org.jdesktop.swingx.ScrollableSizeHint;
import org.jdesktop.swingx.VerticalLayout;

public class WMSLegendPlugIn
extends AbstractPlugIn {
    private static final String PLUGIN = I18N.get("org.openjump.core.ui.plugin.wms.WMSLegendPlugIn");
    private static final String PANEL = I18N.get("org.openjump.core.ui.plugin.wms.WMSLegendPlugIn.panel");
    private static final String MESSAGE = I18N.get("org.openjump.core.ui.plugin.wms.WMSLegendPlugIn.message");
    private static final ImageIcon ICON = IconLoader.svgIcon((String)"show_wms_legend.svg");
    private JScrollPane scrollPane = new JScrollPane();

    @Override
    public boolean execute(final PlugInContext context) throws Exception {
        final WaitDialog dlgWait = new WaitDialog((Window)WorkbenchContext.getFrame(), I18N.get("common.wait"));
        Runnable work = new Runnable(){

            @Override
            public void run() {
                try {
                    Layerable layer = LayerTools.getSelectedLayerable(context, Layerable.class);
                    JDialog dlg = new JDialog(WorkbenchContext.getFrame());
                    dlg.setTitle(PANEL + " (" + layer.getName() + ")");
                    dlg.setResizable(true);
                    dlg.setModal(false);
                    dlg.setIconImage(ICON.getImage());
                    WMSLegendPlugIn.this.scrollPane = new JScrollPane(WMSLegendPlugIn.this.getLegendPanel(context));
                    dlg.add((Component)WMSLegendPlugIn.this.scrollPane, "Center");
                    dlg.setSize(250, 500);
                    GUIUtil.centreOnScreen(dlg);
                    dlg.setVisible(true);
                }
                catch (Exception e) {
                    dlgWait.setError(e);
                }
            }
        };
        dlgWait.addWorkToDo(work);
        dlgWait.setVisible(true);
        if (dlgWait.getError() != null) {
            throw dlgWait.getError();
        }
        return true;
    }

    public JPanel getLegendPanel(PlugInContext context) throws IOException, Exception {
        WMSLayer layer = (WMSLayer)LayerTools.getSelectedLayerable(context, WMSLayer.class);
        if (layer != null) {
            String[] names = layer.getWMSLayerContext().getActiveServiceLayers();
            MapRequest req = new MapRequest(layer.getService());
            req.setLayerNames(Arrays.asList(names));
            Image[] images = req.getLegendGraphics(null);
            JXTaskPaneContainer taskPaneContainer = new JXTaskPaneContainer();
            VerticalLayout verticalLayout = new VerticalLayout();
            verticalLayout.setGap(1);
            taskPaneContainer.setLayout((LayoutManager)verticalLayout);
            taskPaneContainer.setBackground(new Color(212, 208, 200));
            taskPaneContainer.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
            taskPaneContainer.setOpaque(false);
            taskPaneContainer.setScrollableWidthHint(ScrollableSizeHint.FIT);
            for (int i = 0; i < names.length; ++i) {
                String layerName = names[i];
                MapLayer mapLayer = layer.getService().getCapabilities().getLayer(layerName);
                String layerTitle = StringUtils.isNotEmpty((CharSequence)mapLayer.getTitle()) ? mapLayer.getTitle() : layerName;
                JXTaskPane taskPane = new JXTaskPane();
                taskPane.setForeground(Color.black);
                taskPane.setTitle(I18N.getMessage("org.openjump.core.ui.plugin.queries.SimpleQuery.layer", layerTitle));
                taskPane.setCollapsed(i > 0);
                Image image = images[i];
                ImageIcon legendIcon = image == null ? null : new ImageIcon(image);
                JXPanel taskPanel = (JXPanel)taskPane.getContentPane();
                taskPanel.setOpaque(false);
                if (legendIcon != null) {
                    JLabel labelIcon = new JLabel(legendIcon, 2);
                    taskPanel.add((Component)labelIcon);
                } else {
                    JLabel textLabel = new JLabel(MESSAGE);
                    taskPanel.add((Component)textLabel);
                }
                CompoundBorder compoundBorder = BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0), BorderFactory.createEmptyBorder(0, 0, 0, 0));
                taskPanel.setBorder((Border)compoundBorder);
                taskPaneContainer.add((Component)taskPane);
            }
            return taskPaneContainer;
        }
        WMTSLayer wmtsLayer = (WMTSLayer)LayerTools.getSelectedLayerable(context, WMTSLayer.class);
        if (wmtsLayer != null) {
            String styleName = wmtsLayer.getValidWMTSStyle().getStyle();
            Style style = null;
            Layer mapLayer = wmtsLayer.getService().getCapabilities().getLayerByName(wmtsLayer.getValidWMTSStyle().getLayerName());
            List<Style> styles = mapLayer.getStyles();
            for (Style s : styles) {
                if (!s.getIdentifier().equals(styleName)) continue;
                style = s;
                break;
            }
            if (style == null) {
                return null;
            }
            GetLegendGraphicRequest req = new GetLegendGraphicRequest(wmtsLayer.getService());
            req.setStyle(style);
            Image image = req.getImage(null);
            JXTaskPaneContainer taskPaneContainer = new JXTaskPaneContainer();
            VerticalLayout verticalLayout = new VerticalLayout();
            verticalLayout.setGap(1);
            taskPaneContainer.setLayout((LayoutManager)verticalLayout);
            taskPaneContainer.setBackground(new Color(212, 208, 200));
            taskPaneContainer.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
            taskPaneContainer.setOpaque(false);
            taskPaneContainer.setScrollableWidthHint(ScrollableSizeHint.FIT);
            String layerTitle = StringUtils.isNotEmpty((CharSequence)mapLayer.getTitle()) ? mapLayer.getTitle() : wmtsLayer.getName();
            JXTaskPane taskPane = new JXTaskPane();
            taskPane.setForeground(Color.black);
            taskPane.setTitle(I18N.getMessage("org.openjump.core.ui.plugin.queries.SimpleQuery.layer", layerTitle));
            taskPane.setCollapsed(false);
            ImageIcon legendIcon = image == null ? null : new ImageIcon(image);
            JXPanel taskPanel = (JXPanel)taskPane.getContentPane();
            taskPanel.setOpaque(false);
            if (legendIcon != null) {
                JLabel labelIcon = new JLabel(legendIcon, 2);
                taskPanel.add((Component)labelIcon);
            } else {
                JLabel textLabel = new JLabel(MESSAGE);
                taskPanel.add((Component)textLabel);
            }
            CompoundBorder compoundBorder = BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0), BorderFactory.createEmptyBorder(0, 0, 0, 0));
            taskPanel.setBorder((Border)compoundBorder);
            taskPaneContainer.add((Component)taskPane);
            return taskPaneContainer;
        }
        return null;
    }

    @Override
    public EnableCheck createEnableCheck() {
        EnableCheckFactory checkFactory = EnableCheckFactory.getInstance();
        return new MultiEnableCheck().add(checkFactory.createWindowWithLayerNamePanelMustBeActiveCheck()).add(new OrEnableCheck().add(checkFactory.createExactlyNLayerablesMustBeSelectedCheck(1, WMSLayer.class)).add(checkFactory.createExactlyNLayerablesMustBeSelectedCheck(1, WMTSLayer.class))).add(new OrEnableCheck().add(new EnableCheck(this){

            @Override
            public String check(JComponent component) {
                WMSLayer layer = (WMSLayer)LayerTools.getSelectedLayerable(WorkbenchContext.getInstance().createPlugInContext(), WMSLayer.class);
                if (layer == null) {
                    return "no wms layer selected";
                }
                WMSStyleModel style = layer.getValidWMSStyle();
                if (style == null) {
                    return "no valid wms style found";
                }
                return null;
            }
        }).add(new EnableCheck(this){

            @Override
            public String check(JComponent component) {
                WMTSLayer layer = (WMTSLayer)LayerTools.getSelectedLayerable(WorkbenchContext.getInstance().createPlugInContext(), WMTSLayer.class);
                if (layer == null) {
                    return "no wmts layer selected";
                }
                WMTSStyleModel style = layer.getValidWMTSStyle();
                if (style == null) {
                    return "no valid wmts style found";
                }
                return null;
            }
        }));
    }

    @Override
    public String getName() {
        return PLUGIN;
    }
}

