/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.plugin.wms;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.util.CollectionUtil;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.model.RiwaJumpModelUtilities;
import com.vividsolutions.jump.workbench.model.SimpleStyleCollection;
import com.vividsolutions.jump.workbench.model.StyleCollection;
import com.vividsolutions.jump.workbench.ui.ColorChooserPanel;
import com.vividsolutions.jump.workbench.ui.GUIUtil;
import com.vividsolutions.jump.workbench.ui.TransparencyPanel;
import com.vividsolutions.jump.workbench.ui.plugin.wms.MapLayerPanel;
import com.vividsolutions.jump.workbench.ui.plugin.wms.OWSURLDialog;
import com.vividsolutions.jump.workbench.ui.renderer.style.RenderUtil;
import com.vividsolutions.jump.workbench.ui.style.AbstractStylePanel;
import com.vividsolutions.ows.OWService;
import com.vividsolutions.ows.wms.MapImageFormatChooser;
import com.vividsolutions.ows.wms.MapLayer;
import com.vividsolutions.ows.wms.WMService;
import com.vividsolutions.ows.wms.wmscapabilities.RequestType;
import de.riwagis.riwajump.model.style.StyleModel;
import de.riwagis.riwajump.model.style.WMSStyleModel;
import de.riwagis.util.gui.GUISupport;
import de.riwagis.util.lang.StringComparator;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.UnsupportedCharsetException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import org.apache.commons.lang3.StringUtils;
import org.locationtech.jts.util.Assert;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WMSLayerPanel
extends AbstractStylePanel {
    public static final String SERVICE_WMS = "WMS";
    public static final String SERVICE_WMTS = "WMTS";
    private SimpleStyleCollection sCol = null;
    private WMSStyleModel style = null;
    private static final Logger LOG = LoggerFactory.getLogger(WMSLayerPanel.class);
    private boolean blockEvents = false;
    private JButton butURL;
    private JComboBox<String> cbCharset;
    private JCheckBox cboIgnoreFeatureInfo;
    private JCheckBox cboShowLayersInTree;
    private JCheckBox cboUseClearColor;
    private JComboBox<String> cmbFormat;
    private JComboBox<String> cmbSRS;
    private ColorChooserPanel colorChooserClearColor;
    private Box.Filler filler1;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JTabbedPane jTabbedPane1;
    private JLabel lblCharset;
    private JLabel lblFormat;
    private JLabel lblRegExp;
    private JLabel lblSRS;
    private JLabel lblServerURL;
    private JLabel lblTransparency;
    private JLabel lblURL;
    private JLabel lblVersion;
    private JLabel lblWMSVersion;
    private JPanel pnlOptions;
    private JPanel pnlWMSLayer;
    private JTextField tfRegExp;
    private TransparencyPanel transparencyPanel;
    private JTextField txtTransparency;
    private MapLayerPanel wmsLayerPanel;

    public WMSLayerPanel() {
        this.initComponents();
        this.i18n();
        this.init();
    }

    private void i18n() {
        this.butURL.setText(I18N.get("ui.plugin.wms.WMSLayerPanel.choose-url"));
        this.lblServerURL.setText(I18N.get("ui.plugin.wms.WMSLayerPanel.url"));
        this.lblSRS.setText(I18N.get("ui.plugin.wms.WMSLayerPanel.srs"));
        this.lblFormat.setText(I18N.get("ui.plugin.wms.WMSLayerPanel.format"));
        this.lblVersion.setText(I18N.get("ui.plugin.wms.WMSLayerPanel.version"));
        this.lblTransparency.setText(I18N.get("ui.plugin.wms.WMSLayerPanel.transparency"));
        this.cboUseClearColor.setText(I18N.get("ui.plugin.wms.WMSLayerPanel.useClearColor"));
        this.cboShowLayersInTree.setText(I18N.get("ui.plugin.wms.WMSLayerPanel.show-layers-in-tree"));
        this.lblRegExp.setText(I18N.get("ui.plugin.wms.WMSLayerPanel.featureinfo-regexp"));
        this.lblRegExp.setToolTipText(I18N.get("ui.plugin.wms.WMSLayerPanel.featureinfo-regexp-tooltip"));
        this.lblCharset.setText(I18N.get("ui.plugin.wms.WMSLayerPanel.featureinfo-charset"));
        this.cboIgnoreFeatureInfo.setText(I18N.get("ui.plugin.wms.WMSLayerPanel.ignore-featureinfo"));
        this.jTabbedPane1.setTitleAt(0, I18N.get("ui.plugin.wms.WMSLayerPanel.tab-layer"));
        this.jTabbedPane1.setTitleAt(1, I18N.get("ui.plugin.wms.WMSLayerPanel.tab-options"));
        this.jPanel1.setBorder(BorderFactory.createTitledBorder(I18N.get("ui.plugin.wms.WMSLayerPanel.border-transparency")));
        this.jPanel3.setBorder(BorderFactory.createTitledBorder(I18N.get("ui.plugin.wms.WMSLayerPanel.border-feature-info")));
    }

    private void init() {
        this.lblURL.setText("");
        this.lblVersion.setText("");
        this.setEnabledState();
        this.updateControls();
        this.wmsLayerPanel.add(() -> {
            if (this.blockEvents) {
                return;
            }
            boolean bolTemp = this.blockEvents;
            this.blockEvents = true;
            try {
                if (this.wmsLayerPanel.getChkSort().isEnabled()) {
                    this.fillSRSComboBox();
                    if (this.style != null) {
                        this.style.setSRS(this.cmbSRS.getSelectedItem() == null ? "" : this.cmbSRS.getSelectedItem().toString());
                        this.style.setLayerNames(CollectionUtil.reverse(this.wmsLayerPanel.getChosenMapLayersAsString()));
                    }
                }
            }
            finally {
                this.blockEvents = bolTemp;
            }
        });
        this.transparencyPanel.addChangeListener(event -> {
            if (this.blockEvents) {
                return;
            }
            if (this.style != null) {
                this.style.setAlpha(this.transparencyPanel.getAlpha());
            }
        });
    }

    private void fillSRSComboBox() {
        String strDefaultSRS;
        String strStyleSRS = null;
        if (this.style != null) {
            strStyleSRS = this.style.getSRS();
        }
        this.cmbSRS.removeAllItems();
        List<String> lstSRS = this.wmsLayerPanel.commonSRSList();
        lstSRS.sort((Comparator<String>)new StringComparator());
        if (lstSRS.isEmpty()) {
            return;
        }
        for (String srs : lstSRS) {
            this.cmbSRS.addItem(srs);
        }
        if (!Objects.toString(strStyleSRS, "").isEmpty()) {
            this.setSRSIgnoreCase(strStyleSRS);
        } else if (this.cmbSRS.getItemCount() > 0 && !this.setSRSIgnoreCase(strDefaultSRS = WorkbenchContext.getTask().getCRSDefinition().getCode())) {
            this.cmbSRS.setSelectedIndex(0);
        }
    }

    private boolean setSRSIgnoreCase(String strSRS) {
        for (int i = 0; i < this.cmbSRS.getItemCount(); ++i) {
            if (!this.cmbSRS.getItemAt(i).equalsIgnoreCase(strSRS)) continue;
            this.cmbSRS.setSelectedIndex(i);
            return true;
        }
        return false;
    }

    private void setEnabledState() {
        if (this.style == null) {
            this.lblURL.setEnabled(false);
            this.lblVersion.setEnabled(false);
            this.transparencyPanel.setEnabled(false);
            this.txtTransparency.setEnabled(false);
            this.cmbSRS.setEnabled(false);
            this.wmsLayerPanel.setEnabled(false);
        } else {
            this.lblURL.setEnabled(true);
            this.lblVersion.setEnabled(true);
            this.transparencyPanel.setEnabled(true);
            this.txtTransparency.setEnabled(true);
            this.cmbSRS.setEnabled(true);
            this.wmsLayerPanel.setEnabled(true);
        }
    }

    @Override
    public String validateInput() {
        this.wmsLayerPanel.fireInputChanged();
        if (this.style == null) {
            return I18N.get("common.error") + " : " + I18N.get("ui.plugin.wms.WMSLayerPanel.choose-url");
        }
        String strRegEx = this.tfRegExp.getText();
        try {
            Pattern.compile(strRegEx);
        }
        catch (PatternSyntaxException e) {
            return I18N.get("common.error") + " : " + I18N.get("ui.plugin.wms.WMSLayerPanel.featureinfo-regexp-error") + "\n" + e.getLocalizedMessage();
        }
        this.style.setFeatureInfoRegExp(strRegEx);
        String strCharset = Objects.toString(this.cbCharset.getSelectedItem(), null);
        try {
            if (StringUtils.isNotEmpty((CharSequence)strCharset)) {
                Charset.forName(strCharset);
            }
        }
        catch (UnsupportedCharsetException e) {
            return I18N.get("common.error") + " : " + I18N.get("ui.plugin.wms.WMSLayerPanel.featureinfo-charset-error") + " " + strCharset + "\n" + e.getLocalizedMessage();
        }
        this.style.setDefaultFeatureInfoCharset(strCharset);
        this.style.setIgnoreFeatureInfo(this.cboIgnoreFeatureInfo.isSelected());
        boolean hasDeadLayers = this.wmsLayerPanel.getChosenMapLayers().stream().anyMatch(MapLayer::isDead);
        if (hasDeadLayers) {
            return I18N.get("ui.plugin.wms.WMSLayerPanel.dead-layers-not-allowed-error");
        }
        return null;
    }

    @Override
    public String getTitle() {
        return I18N.get("ui.plugin.wms.WMSLayerPanel.edit-title");
    }

    @Override
    public void setStyleCollection(StyleCollection sCol) {
        this.sCol = (SimpleStyleCollection)sCol;
        WMSStyleModel wmsStyle = this.sCol.getStyle(WMSStyleModel.class);
        if (wmsStyle != null) {
            this.setWMSStyle(wmsStyle);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateStyles() {
        if (this.sCol != null) {
            boolean firingEvents = this.sCol.getLayerable().getLayerManager().isFiringEvents();
            this.sCol.getLayerable().getLayerManager().setFiringEvents(false);
            try {
                WMSStyleModel oldStyle = this.sCol.getStyle(WMSStyleModel.class);
                WMSStyleModel newStyle = this.getWMSStyle();
                if (oldStyle != null) {
                    this.sCol.removeStyle((StyleModel)oldStyle);
                    if (!newStyle.isHideWmsLayers()) {
                        newStyle.setLstLayerInvisible(oldStyle.getLstLayerInvisible());
                    } else {
                        newStyle.setLstLayerInvisible(new ArrayList());
                    }
                }
                this.sCol.addStyle((StyleModel)newStyle);
            }
            finally {
                this.sCol.getLayerable().getLayerManager().setFiringEvents(firingEvents);
            }
        } else {
            Assert.shouldNeverReachHere();
        }
    }

    public void showURLDialog() {
        this.butURL_onActionPerformed(null);
    }

    private WMService getWMService() throws IOException {
        return RenderUtil.getRenderer(this.style).getWMService();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateControls() {
        block12: {
            boolean bolTemp = this.blockEvents;
            this.blockEvents = true;
            try {
                this.setEnabledState();
                this.lblURL.setForeground(Color.BLACK);
                if (this.style == null) break block12;
                this.lblURL.setText(this.style.getServerURL());
                this.lblURL.setToolTipText(this.style.getServerURL());
                this.lblVersion.setText(this.style.getVersion());
                this.txtTransparency.setText("" + (255 - this.style.getAlpha()));
                WMService srv = null;
                String strURL = Objects.toString(this.style.getServerURL(), "");
                String strError = null;
                if (!strURL.isEmpty()) {
                    try {
                        srv = this.getWMService();
                    }
                    catch (IOException ioe) {
                        srv = null;
                        LOG.error("Error connection: " + strURL, (Throwable)ioe);
                        strError = ioe.getMessage();
                        strError = strError.replace("<", "&lt;");
                        strError = strError.replace(">", "&gt;");
                        strError = strError.replace("\\n", "<br>");
                    }
                }
                if (srv != null) {
                    this.cmbSRS.setEnabled(true);
                    this.cmbFormat.setEnabled(true);
                    this.wmsLayerPanel.setEnabled(true);
                    this.transparencyPanel.getSlider().setEnabled(true);
                    this.wmsLayerPanel.init(srv, this.style.getLstLayerNames());
                    this.setSRSIgnoreCase(this.style.getSRS());
                    this.cmbFormat.removeAllItems();
                    srv.getCapabilities().getRequestFormats(RequestType.GET_MAP).stream().forEach(this.cmbFormat::addItem);
                    this.cmbFormat.setSelectedItem(this.style.getFormat());
                    this.cboShowLayersInTree.setEnabled(true);
                    this.cboShowLayersInTree.setSelected(!this.style.isHideWmsLayers());
                    this.cboUseClearColor.setSelected(this.style.isUseClearColor());
                    this.colorChooserClearColor.setAlpha(255);
                    this.colorChooserClearColor.setColor(RiwaJumpModelUtilities.colorByColorModel(this.style.getClearColor()));
                    this.colorChooserClearColor.setEnabled(this.style.isUseClearColor());
                    this.tfRegExp.setText(this.style.getFeatureInfoRegExp());
                    this.cbCharset.setSelectedItem(this.style.getDefaultFeatureInfoCharset());
                    this.cboIgnoreFeatureInfo.setSelected(this.style.isIgnoreFeatureInfo());
                    this.cboUseClearColor.setEnabled(true);
                    this.tfRegExp.setEnabled(true);
                    this.cbCharset.setEnabled(true);
                    this.cboIgnoreFeatureInfo.setEnabled(true);
                } else {
                    this.cmbSRS.setEnabled(false);
                    this.cmbFormat.setEnabled(false);
                    this.wmsLayerPanel.setEnabled(false);
                    this.wmsLayerPanel.clear();
                    this.transparencyPanel.getSlider().setEnabled(false);
                    this.cboUseClearColor.setEnabled(false);
                    this.colorChooserClearColor.setEnabled(false);
                    this.tfRegExp.setEnabled(false);
                    this.cbCharset.setEnabled(false);
                    this.cboIgnoreFeatureInfo.setEnabled(false);
                    if (!strURL.isEmpty()) {
                        this.lblURL.setForeground(Color.RED);
                        this.lblURL.setToolTipText(I18N.getMessage("ui.plugin.wms.WMSLayerPanel.error-net", strURL, strError));
                        this.lblURL.setText(I18N.get("common.error") + ": " + strURL);
                    } else {
                        this.lblURL.setToolTipText("");
                        this.lblURL.setText(I18N.get("ui.plugin.wms.WMSLayerPanel.choose-url"));
                    }
                    this.cboShowLayersInTree.setEnabled(false);
                }
            }
            catch (IOException ioe) {
                LOG.error("WMSLayerPanel. Error updating controls:", (Throwable)ioe);
                GUISupport.msgbox((Component)this, (String)"WMSLayerPanel. Error updating controls.", (String)I18N.get("common.error"));
            }
            finally {
                this.blockEvents = bolTemp;
            }
        }
    }

    public void setWMSStyle(WMSStyleModel style) {
        try {
            this.style = style.clone();
        }
        catch (CloneNotSupportedException cns) {
            throw new RuntimeException("Should never reach here", cns);
        }
        this.updateControls();
        boolean bolTemp = this.blockEvents;
        this.blockEvents = true;
        try {
            this.fillSRSComboBox();
        }
        finally {
            this.blockEvents = bolTemp;
        }
    }

    public WMSStyleModel getWMSStyle() {
        this.wmsLayerPanel.fireInputChanged();
        return this.style;
    }

    private void initComponents() {
        this.jPanel4 = new JPanel();
        this.lblServerURL = new JLabel();
        this.lblURL = new JLabel();
        this.butURL = new JButton();
        this.lblWMSVersion = new JLabel();
        this.lblVersion = new JLabel();
        this.jTabbedPane1 = new JTabbedPane();
        this.pnlWMSLayer = new JPanel();
        this.wmsLayerPanel = new MapLayerPanel();
        this.jPanel2 = new JPanel();
        this.lblSRS = new JLabel();
        this.cmbSRS = new JComboBox();
        this.lblFormat = new JLabel();
        this.cmbFormat = new JComboBox();
        this.cboShowLayersInTree = new JCheckBox();
        this.pnlOptions = new JPanel();
        this.jPanel1 = new JPanel();
        this.lblTransparency = new JLabel();
        this.transparencyPanel = new TransparencyPanel();
        this.txtTransparency = GUIUtil.createSyncdTextField(this.transparencyPanel.getSlider(), 3);
        this.cboUseClearColor = new JCheckBox();
        this.colorChooserClearColor = new ColorChooserPanel();
        this.jPanel3 = new JPanel();
        this.lblRegExp = new JLabel();
        this.tfRegExp = new JTextField();
        this.lblCharset = new JLabel();
        this.cbCharset = new JComboBox();
        this.cboIgnoreFeatureInfo = new JCheckBox();
        this.filler1 = new Box.Filler(new Dimension(0, 0), new Dimension(0, 0), new Dimension(Short.MAX_VALUE, 0));
        this.setLayout(new BorderLayout(0, 10));
        this.jPanel4.setLayout(new GridBagLayout());
        this.lblServerURL.setText("Server URL:");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(9, 6, 3, 3);
        this.jPanel4.add((Component)this.lblServerURL, gridBagConstraints);
        this.lblURL.setText("URL...");
        this.lblURL.setMaximumSize(new Dimension(250, 14));
        this.lblURL.setMinimumSize(new Dimension(250, 14));
        this.lblURL.setPreferredSize(new Dimension(250, 14));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 2.0;
        gridBagConstraints.insets = new Insets(9, 3, 3, 3);
        this.jPanel4.add((Component)this.lblURL, gridBagConstraints);
        this.butURL.setText("URL w\u00e4hlen");
        this.butURL.setPreferredSize(new Dimension(130, 23));
        this.butURL.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                WMSLayerPanel.this.butURL_onActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 3, 3, 7);
        this.jPanel4.add((Component)this.butURL, gridBagConstraints);
        this.lblWMSVersion.setText("WMS-Version:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(3, 6, 3, 3);
        this.jPanel4.add((Component)this.lblWMSVersion, gridBagConstraints);
        this.lblVersion.setText("1.0.0");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel4.add((Component)this.lblVersion, gridBagConstraints);
        this.add((Component)this.jPanel4, "North");
        this.pnlWMSLayer.setLayout(new GridBagLayout());
        this.wmsLayerPanel.setMinimumSize(new Dimension(500, 230));
        this.wmsLayerPanel.setPreferredSize(new Dimension(500, 230));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(3, 6, 3, 3);
        this.pnlWMSLayer.add((Component)this.wmsLayerPanel, gridBagConstraints);
        this.jPanel2.setLayout(new FlowLayout(0));
        this.lblSRS.setText("Koordinatensystem:");
        this.jPanel2.add(this.lblSRS);
        this.cmbSRS.setMinimumSize(new Dimension(130, 22));
        this.cmbSRS.setPreferredSize(new Dimension(130, 22));
        this.cmbSRS.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                WMSLayerPanel.this.cmbSRS_onActionPerformed(evt);
            }
        });
        this.jPanel2.add(this.cmbSRS);
        this.lblFormat.setText("Format:");
        this.jPanel2.add(this.lblFormat);
        this.cmbFormat.setMinimumSize(new Dimension(130, 22));
        this.cmbFormat.setPreferredSize(new Dimension(130, 22));
        this.cmbFormat.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                WMSLayerPanel.this.cmbFormat_onActionPerformed(evt);
            }
        });
        this.jPanel2.add(this.cmbFormat);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(3, 6, 3, 3);
        this.pnlWMSLayer.add((Component)this.jPanel2, gridBagConstraints);
        this.cboShowLayersInTree.setText("gew\u00e4hlte Ebenen in Ebenenbaum anzeigen");
        this.cboShowLayersInTree.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                WMSLayerPanel.this.cboShowLayersInTreeActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 7, 3, 2);
        this.pnlWMSLayer.add((Component)this.cboShowLayersInTree, gridBagConstraints);
        this.jTabbedPane1.addTab("WMS Layer", this.pnlWMSLayer);
        this.pnlOptions.setLayout(new GridBagLayout());
        this.jPanel1.setBorder(BorderFactory.createTitledBorder("Transparenz"));
        this.jPanel1.setLayout(new GridBagLayout());
        this.lblTransparency.setText("Transparenz:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.jPanel1.add((Component)this.lblTransparency, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.jPanel1.add((Component)this.transparencyPanel, gridBagConstraints);
        this.txtTransparency.setMinimumSize(new Dimension(200, 20));
        this.txtTransparency.setPreferredSize(new Dimension(200, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.jPanel1.add((Component)this.txtTransparency, gridBagConstraints);
        this.cboUseClearColor.setText("transparente Farbe");
        this.cboUseClearColor.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.cboUseClearColor.setMargin(new Insets(0, 0, 0, 0));
        this.cboUseClearColor.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                WMSLayerPanel.this.cboUseClearColor_onActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.jPanel1.add((Component)this.cboUseClearColor, gridBagConstraints);
        this.colorChooserClearColor.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                WMSLayerPanel.this.colorChooserClearColor_onActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.jPanel1.add((Component)this.colorChooserClearColor, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        this.pnlOptions.add((Component)this.jPanel1, gridBagConstraints);
        this.jPanel3.setBorder(BorderFactory.createTitledBorder("Feature Info"));
        this.jPanel3.setLayout(new GridBagLayout());
        this.lblRegExp.setText("leerer Feature Info");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.jPanel3.add((Component)this.lblRegExp, gridBagConstraints);
        this.tfRegExp.setMinimumSize(new Dimension(300, 20));
        this.tfRegExp.setPreferredSize(new Dimension(300, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.jPanel3.add((Component)this.tfRegExp, gridBagConstraints);
        this.lblCharset.setText("Default Feature Info Charset");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.jPanel3.add((Component)this.lblCharset, gridBagConstraints);
        this.cbCharset.setEditable(true);
        this.cbCharset.setModel(new DefaultComboBoxModel<String>(new String[]{null, "ISO-8859-1", "cp850", "UTF-8"}));
        this.cbCharset.setMinimumSize(new Dimension(100, 22));
        this.cbCharset.setPreferredSize(new Dimension(100, 22));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.jPanel3.add(this.cbCharset, gridBagConstraints);
        this.cboIgnoreFeatureInfo.setText("Feature Info ignorieren");
        this.cboIgnoreFeatureInfo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                WMSLayerPanel.this.cboIgnoreFeatureInfoActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 13;
        this.jPanel3.add((Component)this.cboIgnoreFeatureInfo, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weighty = 1.0;
        this.pnlOptions.add((Component)this.jPanel3, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        this.pnlOptions.add((Component)this.filler1, gridBagConstraints);
        this.jTabbedPane1.addTab("Optionen", this.pnlOptions);
        this.add((Component)this.jTabbedPane1, "Center");
    }

    private void colorChooserClearColor_onActionPerformed(ActionEvent evt) {
        if (this.blockEvents) {
            return;
        }
        if (this.style == null) {
            return;
        }
        this.style.setClearColor(RiwaJumpModelUtilities.colorModelByColor(this.colorChooserClearColor.getColor()));
        this.updateControls();
    }

    private void cboUseClearColor_onActionPerformed(ActionEvent evt) {
        if (this.blockEvents) {
            return;
        }
        if (this.style == null) {
            return;
        }
        this.style.setUseClearColor(this.cboUseClearColor.isSelected());
        this.updateControls();
    }

    private void cmbFormat_onActionPerformed(ActionEvent evt) {
        if (this.blockEvents) {
            return;
        }
        if (this.style == null) {
            return;
        }
        this.style.setFormat(this.cmbFormat.getSelectedItem().toString());
    }

    private void cmbSRS_onActionPerformed(ActionEvent evt) {
        if (this.blockEvents) {
            return;
        }
        if (this.style == null) {
            return;
        }
        this.style.setSRS(this.cmbSRS.getSelectedItem().toString());
    }

    private void butURL_onActionPerformed(ActionEvent evt) {
        if (this.blockEvents) {
            return;
        }
        OWSURLDialog urlDialog = null;
        Window parent = SwingUtilities.windowForComponent(this);
        if (parent instanceof Frame) {
            urlDialog = new OWSURLDialog((Frame)parent, OWService.OWSType.WMS);
        }
        if (parent instanceof Dialog) {
            urlDialog = new OWSURLDialog((Dialog)parent, OWService.OWSType.WMS);
        }
        GUIUtil.centreOnScreen(urlDialog);
        if (this.style != null) {
            urlDialog.setURL(this.style.getServerURL());
            urlDialog.setVersion(this.style.getVersion());
            urlDialog.setServerNeedsLogin(this.style.isServerNeedsLogin());
            urlDialog.setServerLoginName(this.style.getServerLoginName());
            urlDialog.setServerLoginPwd(this.style.getServerLoginPwd());
        }
        urlDialog.setVisible(true);
        if (urlDialog.wasOKPressed()) {
            WMService tmpWMS;
            if (this.style == null) {
                this.style = new WMSStyleModel();
            }
            String strURL = urlDialog.getURL();
            String strVersion = urlDialog.getVersion();
            try {
                tmpWMS = new WMService(strURL, strVersion);
                tmpWMS.setServerNeedsLogin(urlDialog.getServerNeedsLogin());
                tmpWMS.setServerLoginName(urlDialog.getServerLoginName());
                tmpWMS.setServerLoginPwd(urlDialog.getServerLoginPwd());
                tmpWMS.initialize();
            }
            catch (Exception e) {
                LOG.error(I18N.get("ui.plugin.ows.OWSURLDialog.url-error"), (Throwable)e);
                JOptionPane.showMessageDialog(this, I18N.get("ui.plugin.ows.OWSURLDialog.url-error"), I18N.get("common.error"), 0);
                this.style.setServerURL(strURL);
                this.style.setVersion(strVersion);
                this.style.setServerNeedsLogin(urlDialog.getServerNeedsLogin());
                this.style.setServerLoginName(urlDialog.getServerLoginName());
                this.style.setServerLoginPwd(urlDialog.getServerLoginPwd());
                this.updateControls();
                return;
            }
            RenderUtil.getRenderer(this.style).setWMService(tmpWMS);
            MapImageFormatChooser formatChooser = new MapImageFormatChooser(this.style.getVersion());
            formatChooser.setPreferLossyCompression(false);
            formatChooser.setTransparencyRequired(true);
            try {
                this.style.setFormat(formatChooser.chooseFormat(this.getWMService().getCapabilities().getRequestFormats(RequestType.GET_MAP)));
            }
            catch (IOException ioe) {
                GUISupport.msgbox((Component)this, (String)"Error connecting WMS Server", (String)I18N.get("common.error"));
                LOG.error("Error connecting WMS Server", (Throwable)ioe);
            }
            this.updateControls();
        }
    }

    private void cboShowLayersInTreeActionPerformed(ActionEvent evt) {
        if (this.blockEvents) {
            return;
        }
        if (this.style == null) {
            return;
        }
        this.style.setHideWmsLayers(!this.cboShowLayersInTree.isSelected());
    }

    private void cboIgnoreFeatureInfoActionPerformed(ActionEvent evt) {
    }
}

