/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.plugin.wms;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.util.Blackboard;
import com.vividsolutions.jump.workbench.ui.plugin.PersistentBlackboardPlugIn;
import com.vividsolutions.ows.OWService;
import de.riwagis.util.Support;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;

public class OWSURLDialog
extends JDialog {
    private static final int MAX_CACHED_URLS = 4;
    private static final String WMS_URL_KEY = "com.vividsolutions.jump.workbench.ui.plugin.wms.WMSLayerDialog";
    private static final String WMTS_URL_KEY = "com.vividsolutions.jump.workbench.ui.plugin.wmts.WMTSLayerDialog";
    private boolean bolOKPressed = false;
    private String strURL = "";
    private ArrayList lstURL = new ArrayList();
    private ArrayList lstURL_BB = new ArrayList();
    private String strVersion = "";
    private boolean serverNeedsLogin = false;
    private String serverLoginName;
    private String serverLoginPwd;
    private String serverLoginMethod;
    private OWService.OWSType type;
    private JButton butCancel;
    private JButton butOK;
    private JCheckBox cboUseLogin;
    private JComboBox cmbURL;
    private JComboBox cmbVersion;
    private JPanel jPanel1;
    private JLabel lblHeader;
    private JLabel lblLoginName;
    private JLabel lblLoginPwd;
    private JLabel lblURL;
    private JLabel lblVersion;
    private JTextField txtLoginName;
    private JPasswordField txtLoginPwd;

    public OWSURLDialog(Dialog owner, OWService.OWSType type) {
        super(owner, true);
        this.type = type;
        this.initComponents();
        this.setSize(500, 260);
        this.setResizable(false);
        this.i18n();
        this.init();
    }

    public OWSURLDialog(Frame owner, OWService.OWSType type) {
        super(owner, true);
        this.type = type;
        this.initComponents();
        this.setSize(500, 160);
        this.setResizable(false);
        this.i18n();
        this.init();
    }

    private void i18n() {
        this.setTitle(I18N.get("ui.plugin.ows.OWSURLDialog.title"));
        this.lblHeader.setText(I18N.get("ui.plugin.ows.OWSURLDialog.header"));
        this.lblURL.setText(I18N.get("ui.plugin.ows.OWSURLDialog.url"));
        this.lblVersion.setText(I18N.get("ui.plugin.ows.OWSURLDialog.version"));
        this.cboUseLogin.setText(I18N.get("ui.plugin.ows.OWSURLDialog.use-login"));
        this.lblLoginName.setText(I18N.get("ui.plugin.ows.OWSURLDialog.login-name"));
        this.lblLoginPwd.setText(I18N.get("ui.plugin.ows.OWSURLDialog.login-password"));
        this.butOK.setText(I18N.get("common.ok"));
        this.butCancel.setText(I18N.get("common.cancel"));
    }

    private void init() {
        Blackboard bb;
        this.cmbURL.removeAllItems();
        String strDefault = I18N.get("ui.plugin.ows.OWSURLDialog.url-default-1");
        if (strDefault != null && !strDefault.equals("")) {
            this.lstURL.add(strDefault);
        }
        if ((strDefault = I18N.get("ui.plugin.ows.OWSURLDialog.url-default-2")) != null && !strDefault.equals("")) {
            this.lstURL.add(strDefault);
        }
        if ((strDefault = I18N.get("ui.plugin.ows.OWSURLDialog.url-default-3")) != null && !strDefault.equals("")) {
            this.lstURL.add(strDefault);
        }
        if ((bb = PersistentBlackboardPlugIn.get()).contains(this.getKey4OWSType())) {
            this.lstURL_BB = (ArrayList)bb.get(this.getKey4OWSType());
            for (Object nextURL : this.lstURL_BB) {
                if (!this.lstURL.contains(nextURL)) continue;
                this.lstURL_BB.remove(nextURL);
            }
        }
        Iterator i = this.lstURL.iterator();
        while (i.hasNext()) {
            this.cmbURL.addItem(i.next());
        }
        i = this.lstURL_BB.iterator();
        while (i.hasNext()) {
            this.cmbURL.addItem(i.next());
        }
        if (this.cmbURL.getItemCount() > 0) {
            this.cmbURL.setSelectedIndex(0);
        }
        this.setServiceType(this.type);
        this.cboUseLogin.setSelected(false);
        this.txtLoginName.setEnabled(false);
        this.txtLoginPwd.setEnabled(false);
    }

    public boolean wasOKPressed() {
        return this.bolOKPressed;
    }

    public String getURL() {
        return this.strURL;
    }

    public void setURL(String _strURL) {
        this.strURL = _strURL;
        this.cmbURL.setSelectedItem(this.strURL);
    }

    public String getVersion() {
        return this.strVersion;
    }

    public void setVersion(String _strVersion) {
        this.strVersion = _strVersion;
        this.cmbVersion.setSelectedItem(this.strVersion);
    }

    public boolean getServerNeedsLogin() {
        return this.serverNeedsLogin;
    }

    public void setServerNeedsLogin(boolean _serverNeedsLogin) {
        this.serverNeedsLogin = _serverNeedsLogin;
        this.cboUseLogin.setSelected(this.serverNeedsLogin);
        this.txtLoginName.setEnabled(this.serverNeedsLogin);
        this.txtLoginPwd.setEnabled(this.serverNeedsLogin);
    }

    public String getServerLoginName() {
        return this.serverLoginName;
    }

    public void setServerLoginName(String _serverLoginName) {
        this.serverLoginName = Support.toString((Object)_serverLoginName);
        this.txtLoginName.setText(this.serverLoginName);
    }

    public String getServerLoginPwd() {
        return this.serverLoginPwd;
    }

    public void setServerLoginPwd(String _serverLoginPwd) {
        this.serverLoginPwd = Support.toString((Object)_serverLoginPwd);
        this.txtLoginPwd.setText(this.serverLoginPwd);
    }

    public void setServiceType(OWService.OWSType type) {
        this.type = type;
        this.cmbVersion.removeAllItems();
        if (type == OWService.OWSType.WMS) {
            this.cmbVersion.addItem("1.1.0");
            this.cmbVersion.addItem("1.1.1");
            this.cmbVersion.addItem("1.3.0");
            this.cmbVersion.setSelectedItem("1.1.1");
        } else if (type == OWService.OWSType.WMTS) {
            this.cmbVersion.addItem("1.0.0");
        }
    }

    public OWService.OWSType getServiceType() {
        return this.type;
    }

    private void initComponents() {
        this.lblURL = new JLabel();
        this.cmbURL = new JComboBox();
        this.cmbVersion = new JComboBox();
        this.lblVersion = new JLabel();
        this.lblHeader = new JLabel();
        this.jPanel1 = new JPanel();
        this.butOK = new JButton();
        this.butCancel = new JButton();
        this.lblLoginName = new JLabel();
        this.lblLoginPwd = new JLabel();
        this.txtLoginName = new JTextField();
        this.txtLoginPwd = new JPasswordField();
        this.cboUseLogin = new JCheckBox();
        this.getContentPane().setLayout(new GridBagLayout());
        this.lblURL.setText("Server URL:");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 6, 3, 3);
        this.getContentPane().add((Component)this.lblURL, gridBagConstraints);
        this.cmbURL.setEditable(true);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.getContentPane().add((Component)this.cmbURL, gridBagConstraints);
        this.cmbVersion.setMinimumSize(new Dimension(100, 22));
        this.cmbVersion.setPreferredSize(new Dimension(100, 22));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.getContentPane().add((Component)this.cmbVersion, gridBagConstraints);
        this.lblVersion.setText("WMS-Version:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 6, 3, 0);
        this.getContentPane().add((Component)this.lblVersion, gridBagConstraints);
        this.lblHeader.setText("Bitte w\u00e4hlen Sie die URL des WebMap-Dienstes");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(9, 9, 3, 3);
        this.getContentPane().add((Component)this.lblHeader, gridBagConstraints);
        this.butOK.setText("OK");
        this.butOK.setPreferredSize(new Dimension(100, 23));
        this.butOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OWSURLDialog.this.butOK_onActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.butOK);
        this.butCancel.setText("abbrechen");
        this.butCancel.setPreferredSize(new Dimension(100, 23));
        this.butCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OWSURLDialog.this.butCancel_onActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.butCancel);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.getContentPane().add((Component)this.jPanel1, gridBagConstraints);
        this.lblLoginName.setText("Benutzername:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(3, 14, 3, 3);
        this.getContentPane().add((Component)this.lblLoginName, gridBagConstraints);
        this.lblLoginPwd.setText("Passwort:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(3, 14, 3, 3);
        this.getContentPane().add((Component)this.lblLoginPwd, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 9);
        this.getContentPane().add((Component)this.txtLoginName, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 9);
        this.getContentPane().add((Component)this.txtLoginPwd, gridBagConstraints);
        this.cboUseLogin.setText("Server erfordert Anmeldung");
        this.cboUseLogin.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OWSURLDialog.this.cboUseLogin_onActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 10, 3, 7);
        this.getContentPane().add((Component)this.cboUseLogin, gridBagConstraints);
        this.pack();
    }

    private void butCancel_onActionPerformed(ActionEvent evt) {
        this.bolOKPressed = false;
        this.setVisible(false);
    }

    private void butOK_onActionPerformed(ActionEvent evt) {
        this.strURL = this.cmbURL.getSelectedItem().toString();
        this.strVersion = this.cmbVersion.getSelectedItem().toString();
        this.serverNeedsLogin = this.cboUseLogin.isSelected();
        this.serverLoginName = this.txtLoginName.getText();
        this.serverLoginPwd = new String(this.txtLoginPwd.getPassword());
        if (!this.lstURL_BB.contains(this.strURL) && !this.lstURL.contains(this.strURL)) {
            this.lstURL_BB.add(0, this.strURL);
            this.cmbURL.addItem(this.strURL);
            this.cmbURL.setSelectedItem(this.strURL);
        }
        int i = this.lstURL_BB.size();
        while (4 < this.lstURL_BB.size()) {
            this.lstURL_BB.remove(i - 1);
            --i;
        }
        Blackboard bb = PersistentBlackboardPlugIn.get();
        bb.put(this.getKey4OWSType(), this.lstURL_BB);
        this.bolOKPressed = true;
        this.setVisible(false);
    }

    private String getKey4OWSType() {
        if (this.type == OWService.OWSType.WMS) {
            return WMS_URL_KEY;
        }
        if (this.type == OWService.OWSType.WMTS) {
            return WMTS_URL_KEY;
        }
        return WMS_URL_KEY;
    }

    private void cboUseLogin_onActionPerformed(ActionEvent evt) {
        this.txtLoginName.setEnabled(this.cboUseLogin.isSelected());
        this.txtLoginPwd.setEnabled(this.cboUseLogin.isSelected());
        this.serverNeedsLogin = this.cboUseLogin.isSelected();
    }
}

