/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.plugin.wms;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.workbench.ui.InputChangedFirer;
import com.vividsolutions.jump.workbench.ui.InputChangedListener;
import com.vividsolutions.jump.workbench.ui.addremove.AddRemoveList;
import com.vividsolutions.jump.workbench.ui.addremove.AddRemoveListModel;
import com.vividsolutions.jump.workbench.ui.addremove.AddRemovePanel;
import com.vividsolutions.jump.workbench.ui.addremove.DefaultAddRemoveList;
import com.vividsolutions.jump.workbench.ui.addremove.TreeAddRemoveList;
import com.vividsolutions.jump.workbench.ui.addremove.TreeAddRemoveListModel;
import com.vividsolutions.jump.workbench.ui.plugin.wms.MapLayerTreeModel;
import com.vividsolutions.ows.wms.MapLayer;
import com.vividsolutions.ows.wms.WMService;
import de.riwagis.icons.IconLoader;
import de.riwagis.util.gui.GUISupport;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeModel;
import org.apache.commons.lang.WordUtils;
import org.locationtech.jts.util.Assert;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MapLayerPanel
extends JPanel {
    private static final Logger LOG = LoggerFactory.getLogger(MapLayerPanel.class);
    public static final ImageIcon ICON = IconLoader.svgIconSmall((String)"layer_select.svg");
    private final InputChangedFirer inputChangedFirer = new InputChangedFirer();
    private final GridBagLayout gridBagLayout1 = new GridBagLayout();
    private final AddRemovePanel<MapLayerTreeModel.LayerNode> addRemovePanel = new AddRemovePanel(true);
    private final JCheckBox checkBox = new JCheckBox(I18N.get("ui.plugin.wms.MapLayerPanel.sort"), true);

    public MapLayerPanel() {
        try {
            this.jbInit();
        }
        catch (Exception e) {
            LOG.error("Error initializing Panel", (Throwable)e);
        }
        this.initAddRemovePanel();
    }

    public List<MapLayer> getChosenMapLayers() {
        ArrayList<MapLayer> mapLayers = new ArrayList<MapLayer>();
        for (MapLayerTreeModel.LayerNode node : this.addRemovePanel.getRightItems()) {
            Assert.isTrue((node.getLayer().getName() != null ? 1 : 0) != 0);
            mapLayers.add(node.getLayer());
        }
        return mapLayers;
    }

    public List<String> getChosenMapLayersAsString() {
        ArrayList<String> mapLayers = new ArrayList<String>();
        for (MapLayerTreeModel.LayerNode node : this.addRemovePanel.getRightItems()) {
            Assert.isTrue((node.getLayer().getName() != null ? 1 : 0) != 0);
            mapLayers.add(node.getLayer().getName());
        }
        return mapLayers;
    }

    private void setRendererText(JLabel renderer, MapLayer layer, boolean hasFocus) {
        if (layer.getName().isBlank()) {
            renderer.setText(layer.getTitle());
        } else {
            renderer.setText(layer.getTitle() + " (" + layer.getName() + ")");
        }
        if (!hasFocus) {
            return;
        }
        String srss = String.join((CharSequence)", ", layer.getFullSRSList());
        StringBuilder tooltipBuilder = new StringBuilder();
        tooltipBuilder.append("<html>");
        if (!layer.getAbstract().isBlank()) {
            String wrappedAbstract = WordUtils.wrap((String)layer.getAbstract(), (int)120, (String)"<br>", (boolean)false);
            tooltipBuilder.append(wrappedAbstract);
            if (!srss.isBlank()) {
                tooltipBuilder.append("<br><br>");
            }
        }
        if (!srss.isBlank()) {
            String abbreviatedSRSs = WordUtils.abbreviate((String)srss, (int)1000, (int)-1, (String)"...");
            String wrappedSRSs = WordUtils.wrap((String)abbreviatedSRSs, (int)120, (String)"<br>", (boolean)false);
            tooltipBuilder.append(wrappedSRSs);
        }
        tooltipBuilder.append("</html>");
        renderer.setToolTipText(tooltipBuilder.toString());
    }

    final void jbInit() {
        this.addRemovePanel.setRightText(I18N.get("ui.plugin.wms.MapLayerPanel.chosen-layers"));
        this.setLayout(this.gridBagLayout1);
        this.add(this.addRemovePanel, new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    public void add(InputChangedListener listener) {
        this.inputChangedFirer.add(listener);
    }

    public void remove(InputChangedListener listener) {
        this.inputChangedFirer.remove(listener);
    }

    public void fireInputChanged() {
        this.inputChangedFirer.fire();
    }

    private void addIfOnList(MapLayer layer, AddRemoveListModel<MapLayerTreeModel.LayerNode> model, Collection<String> names) {
        ArrayList<String> lstNames = new ArrayList<String>(names);
        Collections.reverse(lstNames);
        for (String name : lstNames) {
            if (this.addIfOnList(layer, model, name)) continue;
            MapLayer deadLayer = new MapLayer("", name, I18N.get("ui.plugin.wms.MapLayerPanel.layer-not-available"), Collections.emptyList(), Collections.emptyList(), null, null, false, true);
            model.add(new MapLayerTreeModel.LayerNode(deadLayer, null));
        }
    }

    private boolean addIfOnList(MapLayer layer, AddRemoveListModel<MapLayerTreeModel.LayerNode> model, String name) {
        if (name.equals(layer.getName())) {
            model.add(new MapLayerTreeModel.LayerNode(layer, null));
            return true;
        }
        for (MapLayer child : layer.getSubLayerList()) {
            if (!this.addIfOnList(child, model, name)) continue;
            return true;
        }
        return false;
    }

    public List<String> commonSRSList() {
        List<MapLayer> mapLayers = this.getChosenMapLayers();
        if (mapLayers.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<String> commonSRSList = new ArrayList<String>(mapLayers.get(0).getFullSRSList());
        for (MapLayer layer : mapLayers) {
            commonSRSList.retainAll(layer.getFullSRSList());
        }
        return commonSRSList;
    }

    private void initAddRemovePanel() {
        TreeAddRemoveList<MapLayerTreeModel.LayerNode> leftList = new TreeAddRemoveList<MapLayerTreeModel.LayerNode>(){

            @Override
            public List<MapLayerTreeModel.LayerNode> getSelectedItems() {
                ArrayList<MapLayerTreeModel.LayerNode> selectedItems = new ArrayList<MapLayerTreeModel.LayerNode>(super.getSelectedItems());
                selectedItems.removeIf(MapLayerTreeModel.LayerNode::isContainer);
                return selectedItems;
            }
        };
        this.addRemovePanel.setLeftList((AddRemoveList<MapLayerTreeModel.LayerNode>)leftList);
        leftList.getTree().setCellRenderer(new DefaultTreeCellRenderer(){

            @Override
            public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                JLabel component = (JLabel)super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
                if (!(value instanceof MapLayerTreeModel.LayerNode)) {
                    return component;
                }
                MapLayer layer = ((MapLayerTreeModel.LayerNode)value).getLayer();
                MapLayerPanel.this.setRendererText(component, layer, hasFocus);
                if (layer.getName() == null) {
                    if (expanded) {
                        component.setIcon(UIManager.getIcon("Tree.openIcon"));
                    } else {
                        component.setIcon(UIManager.getIcon("Tree.closedIcon"));
                    }
                } else {
                    component.setIcon(ICON);
                }
                return component;
            }
        });
        DefaultAddRemoveList<MapLayerTreeModel.LayerNode> rightList = new DefaultAddRemoveList<MapLayerTreeModel.LayerNode>(new DefaultListModel<MapLayerTreeModel.LayerNode>(){

            @Override
            public void addElement(MapLayerTreeModel.LayerNode obj) {
                if (this.contains(obj)) {
                    return;
                }
                super.addElement(obj);
            }
        });
        this.addRemovePanel.setRightList(rightList);
        rightList.getList().setCellRenderer(new ListCellRenderer<MapLayerTreeModel.LayerNode>(){
            private final DefaultListCellRenderer renderer = new DefaultListCellRenderer();
            private final Font defaultFont = this.renderer.getFont();
            private final Font errorFont = this.renderer.getFont().deriveFont(2);
            private final Color defaultColor = this.renderer.getForeground();
            private final Color errorColor = Color.RED;

            @Override
            public Component getListCellRendererComponent(JList<? extends MapLayerTreeModel.LayerNode> list, MapLayerTreeModel.LayerNode value, int index, boolean isSelected, boolean cellHasFocus) {
                JLabel component = (JLabel)this.renderer.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
                MapLayer layer = value.getLayer();
                MapLayerPanel.this.setRendererText(component, layer, cellHasFocus);
                component.setIcon(ICON);
                if (layer.isDead()) {
                    this.renderer.setFont(this.errorFont);
                    this.renderer.setForeground(this.errorColor);
                } else {
                    this.renderer.setFont(this.defaultFont);
                    this.renderer.setForeground(this.defaultColor);
                }
                return component;
            }
        });
        leftList.add(this.inputChangedFirer::fire);
        rightList.add(this.inputChangedFirer::fire);
        rightList.getList().getModel().addListDataListener(new ListDataListener(){

            @Override
            public void intervalAdded(ListDataEvent e) {
                MapLayerPanel.this.inputChangedFirer.fire();
            }

            @Override
            public void intervalRemoved(ListDataEvent e) {
                MapLayerPanel.this.inputChangedFirer.fire();
            }

            @Override
            public void contentsChanged(ListDataEvent e) {
                MapLayerPanel.this.inputChangedFirer.fire();
            }
        });
        JPanel leftLabelPanel = new JPanel();
        leftLabelPanel.setLayout(new GridBagLayout());
        leftLabelPanel.add((Component)new JLabel(I18N.get("ui.plugin.wms.MapLayerPanel.available-layers")), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        leftLabelPanel.add((Component)new JPanel(), new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.checkBox.addActionListener(e -> this.setSorted(this.checkBox.isSelected()));
        leftLabelPanel.add((Component)this.checkBox, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.addRemovePanel.setLeftLabel(leftLabelPanel);
    }

    private void setSorted(boolean isSorted) {
        TreeAddRemoveList tarl = (TreeAddRemoveList)this.addRemovePanel.getLeftList();
        TreeAddRemoveListModel tarlm = (TreeAddRemoveListModel)tarl.getModel();
        MapLayerTreeModel mltm = (MapLayerTreeModel)tarlm.getTreeModel();
        mltm.setSorted(isSorted);
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.addRemovePanel.setEnabled(enabled);
        this.checkBox.setEnabled(enabled);
    }

    public void init(WMService service, Collection<String> initialChosenMapLayers) {
        try {
            MapLayer topLayer = service.getCapabilities().getTopLayer();
            final MapLayerTreeModel treeModel = new MapLayerTreeModel(topLayer);
            treeModel.setSorted(this.checkBox.isSelected());
            TreeAddRemoveListModel<MapLayerTreeModel.LayerNode> treeAddRemoveListModel = new TreeAddRemoveListModel<MapLayerTreeModel.LayerNode>((TreeModel)treeModel){

                @Override
                public List<MapLayerTreeModel.LayerNode> getItems() {
                    ArrayList<MapLayerTreeModel.LayerNode> items = new ArrayList<MapLayerTreeModel.LayerNode>(MapLayerPanel.this.items((MapLayerTreeModel.LayerNode)treeModel.getRoot()));
                    items.removeIf(MapLayerTreeModel.LayerNode::isContainer);
                    return items;
                }
            };
            this.setLeftModel(treeAddRemoveListModel);
            this.clearRightList();
            if (initialChosenMapLayers != null) {
                this.addIfOnList(topLayer, this.addRemovePanel.getRightList().getModel(), initialChosenMapLayers);
            }
            this.addRemovePanel.updateEnabled();
        }
        catch (IOException ioe) {
            GUISupport.msgbox((Component)this, (String)"Error connecting WMS Server.", (String)I18N.get("common.error"));
            LOG.error("Error connecting WMS Server.", (Throwable)ioe);
        }
    }

    private List<MapLayerTreeModel.LayerNode> items(MapLayerTreeModel.LayerNode node) {
        ArrayList<MapLayerTreeModel.LayerNode> items = new ArrayList<MapLayerTreeModel.LayerNode>();
        items.add(node);
        for (MapLayerTreeModel.LayerNode child : node.childList()) {
            items.addAll(this.items(child));
        }
        items.removeAll(this.addRemovePanel.getRightItems());
        return items;
    }

    public JCheckBox getChkSort() {
        return this.checkBox;
    }

    void clear() {
        this.setLeftModel(null);
        this.clearRightList();
    }

    private void setLeftModel(TreeAddRemoveListModel<MapLayerTreeModel.LayerNode> o) {
        ((TreeAddRemoveList)this.addRemovePanel.getLeftList()).setModel(o);
    }

    private void clearRightList() {
        List<MapLayerTreeModel.LayerNode> lstToRemove = this.addRemovePanel.getRightList().getModel().getItems();
        for (MapLayerTreeModel.LayerNode layerNode : lstToRemove) {
            this.addRemovePanel.getRightList().getModel().remove(layerNode);
        }
    }
}

