/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.plugin.visibility;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.model.Layerable;
import com.vividsolutions.jump.workbench.model.UndoableCommand;
import com.vividsolutions.jump.workbench.plugin.AbstractPlugIn;
import com.vividsolutions.jump.workbench.plugin.EnableCheck;
import com.vividsolutions.jump.workbench.plugin.EnableCheckFactory;
import com.vividsolutions.jump.workbench.plugin.MultiEnableCheck;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import java.util.Collection;

public class SelectionInvisiblePlugIn
extends AbstractPlugIn {
    @Override
    public String getName() {
        return I18N.get("ui.plugin.visibility.SelectionInvisiblePlugIn.name");
    }

    @Override
    public boolean execute(final PlugInContext context) throws Exception {
        final Collection<Layer> colLy = context.getLayerViewPanel().getSelectionManager().getLayersWithSelectedItems();
        UndoableCommand command = new UndoableCommand(this, "selection invisible"){

            @Override
            public void execute() {
                for (Layerable ly : colLy) {
                    ly.setVisible(false);
                }
                context.getLayerViewPanel().getSelectionManager().clear();
            }

            @Override
            public void unexecute() {
                for (Layerable ly : colLy) {
                    ly.setVisible(true);
                }
            }
        };
        this.execute(command, context);
        return true;
    }

    @Override
    public EnableCheck createEnableCheck() {
        EnableCheckFactory checkFactory = EnableCheckFactory.getInstance();
        return new MultiEnableCheck().add(checkFactory.createWindowWithLayerViewPanelMustBeActiveCheck()).add(checkFactory.createAtLeastNItemsMustBeSelectedCheck(1));
    }
}

