/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.plugin.validation;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.qa.ValidationError;
import com.vividsolutions.jump.qa.Validator;
import com.vividsolutions.jump.task.TaskMonitor;
import com.vividsolutions.jump.workbench.model.Category;
import com.vividsolutions.jump.workbench.model.LayerManager;
import com.vividsolutions.jump.workbench.model.RedlineLayer;
import com.vividsolutions.jump.workbench.model.StandardCategoryNames;
import com.vividsolutions.jump.workbench.ui.plugin.layer.cad.CadFeatureAtts;
import com.vividsolutions.jump.workbench.ui.plugin.validation.ValidationResultHandler;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.lang.reflect.InvocationTargetException;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.swing.SwingUtilities;
import lombok.Generated;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.geometry.jts.JTSFactoryFinder;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.Point;
import org.opengis.feature.simple.SimpleFeature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ViolationLayerCreator {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ViolationLayerCreator.class);
    private static final String ATTENTION_SVG_URL = "/de/riwagis/icons/common_attention.svg";
    private static final String ATTENTION_SVG_NAME = "attention.svg";
    private final GeometryFactory geometryFactory = JTSFactoryFinder.getGeometryFactory();
    private final Map<String, Collection<SimpleFeature>> featuresPerLayer;
    private final RedlineLayerCreator layerCreator;

    ViolationLayerCreator(Map<String, Collection<SimpleFeature>> featuresPerLayer, RedlineLayerCreator layerCreator) {
        this.featuresPerLayer = featuresPerLayer;
        this.layerCreator = layerCreator;
    }

    public void check(TaskMonitor monitor, ValidationResultHandler resultHandler, LayerManager layerManager) throws InterruptedException, InvocationTargetException {
        log.info("Starting geometry validation (async part)...");
        monitor.allowCancellationRequests();
        monitor.report(I18N.get("ui.plugin.spatial.validation.ViolationLayerCreator.validating"));
        AtomicInteger progressCounter = new AtomicInteger(0);
        int featureCount = this.sumUpCollectionSizes(this.featuresPerLayer);
        Map<String, Collection<ValidationError>> violationsPerLayer = this.detectViolations(monitor::isCancelRequested, () -> monitor.report(progressCounter.incrementAndGet(), featureCount, I18N.get("ui.plugin.spatial.validation.ViolationLayerCreator.geometries")));
        if (monitor.isCancelRequested()) {
            log.info("Cancelled geometry validation by user request.");
            resultHandler.cancelledByUser();
            return;
        }
        int invalidFeatures = this.sumUpCollectionSizes(violationsPerLayer);
        int validFeatures = featureCount - invalidFeatures;
        log.info("Finished geometry validation. {} of {} geometries are valid.", (Object)validFeatures, (Object)featureCount);
        if (invalidFeatures > 0) {
            RedlineLayer layer = this.createViolationLayer(layerManager);
            this.fillViolationLayer(layer, violationsPerLayer);
            resultHandler.withViolations(validFeatures, featureCount, layer);
        } else {
            resultHandler.noViolations(featureCount);
        }
    }

    private Map<String, Collection<ValidationError>> detectViolations(Supplier<Boolean> isCancelRequested, Runnable progressInformer) {
        Validator validator = new Validator();
        return this.featuresPerLayer.entrySet().parallelStream().collect(Collectors.toMap(Map.Entry::getKey, entry -> validator.validate((Collection)entry.getValue(), isCancelRequested, progressInformer)));
    }

    private void fillViolationLayer(RedlineLayer violationLayer, Map<String, Collection<ValidationError>> violationsPerLayer) throws InterruptedException, InvocationTargetException {
        SimpleFeatureBuilder featureBuilder = new SimpleFeatureBuilder(RedlineLayer.REDLINE_FEATURE_TYPE);
        List violationFeatures = violationsPerLayer.entrySet().stream().flatMap(kv -> this.mapErrorsToFeatures(violationLayer, featureBuilder, (Map.Entry<String, Collection<ValidationError>>)kv)).collect(Collectors.toList());
        SwingUtilities.invokeAndWait(() -> violationLayer.editFeature(violationFeatures, 1));
    }

    private Stream<SimpleFeature> mapErrorsToFeatures(RedlineLayer violationLayer, SimpleFeatureBuilder featureBuilder, Map.Entry<String, Collection<ValidationError>> errorsForLayers) {
        return errorsForLayers.getValue().stream().map(error -> this.createValidationFeature(violationLayer, featureBuilder, (String)errorsForLayers.getKey(), (ValidationError)error));
    }

    private SimpleFeature createValidationFeature(RedlineLayer violationLayer, SimpleFeatureBuilder simpleFeatureBuilder, String layer, ValidationError error) {
        SimpleFeature violationFeature = simpleFeatureBuilder.buildFeature(null);
        violationLayer.copyDefaultStyleToFeature(violationFeature);
        if (error.getLocation() != null) {
            Point firstErrorLocation = this.geometryFactory.createPoint(error.getLocation());
            violationFeature.setDefaultGeometry((Object)firstErrorLocation);
        }
        violationFeature.setAttribute(CadFeatureAtts.LAYERNAME.getName(), (Object)layer);
        violationFeature.setAttribute(CadFeatureAtts.DRAWING.getName(), (Object)error.getFeature().getID());
        violationFeature.setAttribute(CadFeatureAtts.SYMBOL.getName(), (Object)ATTENTION_SVG_NAME);
        violationFeature.setAttribute(CadFeatureAtts.NAME.getName(), (Object)I18N.getMessage("ui.plugin.spatial.validation.ViolationLayerCreator.layer-validation-text", error.getType().getMessage(), error.getMessage(), error.getFeature().getID()));
        violationFeature.getUserData().put("RL_KEEP_ATTRIBUTES", true);
        return violationFeature;
    }

    private RedlineLayer createViolationLayer(LayerManager layerManager) throws InterruptedException, InvocationTargetException {
        AtomicReference atomicViolationLayer = new AtomicReference();
        ByteBuffer icon = this.loadSymbolFromResource(ATTENTION_SVG_URL);
        SwingUtilities.invokeAndWait(() -> {
            Category category = layerManager.addCategory(StandardCategoryNames.GEOMETRY_VALIDATION);
            RedlineLayer newLayer = this.layerCreator.create(layerManager, category, I18N.get("ui.plugin.spatial.validation.ViolationLayerCreator.validation-errors"));
            newLayer.getRedlineSymbolStore().addSymbol(ATTENTION_SVG_NAME, icon);
            atomicViolationLayer.set(newLayer);
        });
        return (RedlineLayer)atomicViolationLayer.get();
    }

    private ByteBuffer loadSymbolFromResource(String iconUrl) {
        try {
            InputStream iconStream = this.getClass().getResourceAsStream(iconUrl);
            if (iconStream == null) {
                throw new IOException("Icon is missing");
            }
            return ByteBuffer.wrap(iconStream.readAllBytes());
        }
        catch (IOException ex) {
            throw new UncheckedIOException("Could not read icon", ex);
        }
    }

    private <T, U> int sumUpCollectionSizes(Map<T, Collection<U>> collectionMap) {
        return collectionMap.values().stream().mapToInt(Collection::size).sum();
    }

    @FunctionalInterface
    static interface RedlineLayerCreator {
        public RedlineLayer create(LayerManager var1, Category var2, String var3);
    }
}

