/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.plugin.validation;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.task.TaskMonitor;
import com.vividsolutions.jump.workbench.model.AbstractLayerable;
import com.vividsolutions.jump.workbench.plugin.AbstractPlugIn;
import com.vividsolutions.jump.workbench.plugin.EnableCheck;
import com.vividsolutions.jump.workbench.plugin.EnableCheckFactory;
import com.vividsolutions.jump.workbench.plugin.MultiEnableCheck;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.plugin.ThreadedPlugIn;
import com.vividsolutions.jump.workbench.ui.plugin.layer.redline.AddRedlineLayerPlugIn;
import com.vividsolutions.jump.workbench.ui.plugin.validation.DefaultValidationResultHandler;
import com.vividsolutions.jump.workbench.ui.plugin.validation.ViolationLayerCreator;
import com.vividsolutions.jump.workbench.ui.selection.SelectionManager;
import com.vividsolutions.jump.workbench.ui.selection.SelectionManagerProxy;
import de.riwagis.icons.IconLoader;
import java.util.Collection;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.swing.ImageIcon;
import lombok.Generated;
import org.opengis.feature.simple.SimpleFeature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ValidateSelectionPlugIn
extends AbstractPlugIn
implements ThreadedPlugIn {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ValidateSelectionPlugIn.class);
    private ViolationLayerCreator violationLayerCreator;
    private final Function<Map<String, Collection<SimpleFeature>>, ViolationLayerCreator> validatorSupplier;
    private final Supplier<EnableCheckFactory> checkFactorySupplier;

    public ValidateSelectionPlugIn() {
        this(featuresPerLayer -> new ViolationLayerCreator((Map<String, Collection<SimpleFeature>>)featuresPerLayer, AddRedlineLayerPlugIn::addLayer), EnableCheckFactory::getInstance);
    }

    ValidateSelectionPlugIn(Function<Map<String, Collection<SimpleFeature>>, ViolationLayerCreator> validatorSupplier, Supplier<EnableCheckFactory> checkFactorySupplier) {
        this.validatorSupplier = validatorSupplier;
        this.checkFactorySupplier = checkFactorySupplier;
    }

    @Override
    public ImageIcon getIcon() {
        return IconLoader.svgIcon((String)"geometry_validate.svg");
    }

    @Override
    public String getName() {
        return I18N.get("ui.plugin.spatial.validation.ValidateSelectionPlugIn.name");
    }

    @Override
    public boolean execute(PlugInContext context) throws Exception {
        SelectionManager selectionManager = ((SelectionManagerProxy)((Object)context.getActiveInternalFrame())).getSelectionManager();
        Map<String, Collection> selectedFeaturesPerLayer = selectionManager.getLayersWithSelectedItems().stream().collect(Collectors.toMap(AbstractLayerable::toString, selectionManager::getFeaturesWithSelectedItems));
        this.violationLayerCreator = this.validatorSupplier.apply(selectedFeaturesPerLayer);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run(TaskMonitor monitor, PlugInContext context) throws Exception {
        try {
            if (this.violationLayerCreator == null) {
                return;
            }
            DefaultValidationResultHandler resultHandler = new DefaultValidationResultHandler(context.getWorkbenchFrame());
            this.violationLayerCreator.check(monitor, resultHandler, context.getLayerManager());
        }
        finally {
            this.violationLayerCreator = null;
        }
    }

    @Override
    public EnableCheck createEnableCheck() {
        EnableCheckFactory checkFactory = this.checkFactorySupplier.get();
        return new MultiEnableCheck().add(checkFactory.createWindowWithSelectionManagerMustBeActiveCheck()).add(checkFactory.createAtLeastNItemsMustBeSelectedCheck(1));
    }
}

