/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.plugin.validation;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.task.TaskMonitor;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.plugin.AbstractPlugIn;
import com.vividsolutions.jump.workbench.plugin.EnableCheck;
import com.vividsolutions.jump.workbench.plugin.EnableCheckFactory;
import com.vividsolutions.jump.workbench.plugin.MultiEnableCheck;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.plugin.ThreadedPlugIn;
import com.vividsolutions.jump.workbench.ui.plugin.layer.redline.AddRedlineLayerPlugIn;
import com.vividsolutions.jump.workbench.ui.plugin.validation.DefaultValidationResultHandler;
import com.vividsolutions.jump.workbench.ui.plugin.validation.ViolationLayerCreator;
import de.riwagis.icons.IconLoader;
import de.riwagis.util.gui.GUISupport;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.swing.ImageIcon;
import lombok.Generated;
import org.geotools.feature.FeatureIterator;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.filter.Filter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ValidateSelectedLayersPlugIn
extends AbstractPlugIn
implements ThreadedPlugIn {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ValidateSelectedLayersPlugIn.class);
    public static final int MAX_ALLOWED_FEATURE_COUNT = 50000;
    private ViolationLayerCreator violationLayerCreator;
    private final Function<Map<String, Collection<SimpleFeature>>, ViolationLayerCreator> validatorSupplier;
    private final Supplier<EnableCheckFactory> checkFactorySupplier;
    private final Consumer<PlugInContext> featureLimitPopup;

    public ValidateSelectedLayersPlugIn() {
        this(featuresPerLayer -> new ViolationLayerCreator((Map<String, Collection<SimpleFeature>>)featuresPerLayer, AddRedlineLayerPlugIn::addLayer), EnableCheckFactory::getInstance, ValidateSelectedLayersPlugIn::popupMaximumFeaturesExceeded);
    }

    ValidateSelectedLayersPlugIn(Function<Map<String, Collection<SimpleFeature>>, ViolationLayerCreator> validatorSupplier, Supplier<EnableCheckFactory> checkFactorySupplier, Consumer<PlugInContext> featureLimitPopup) {
        this.validatorSupplier = validatorSupplier;
        this.checkFactorySupplier = checkFactorySupplier;
        this.featureLimitPopup = featureLimitPopup;
    }

    @Override
    public ImageIcon getIcon() {
        return IconLoader.svgIcon((String)"geometry_validate.svg");
    }

    @Override
    public String getName() {
        return I18N.get("ui.plugin.spatial.validation.ValidateSelectedLayersPlugIn.name");
    }

    @Override
    public boolean execute(PlugInContext context) throws Exception {
        Collection<Layer> selectedLayers = context.getLayerNamePanel().selectedNodes(Layer.class);
        int featureCount = this.querySummedFeatureCount(selectedLayers);
        if (featureCount > 50000) {
            this.featureLimitPopup.accept(context);
            return false;
        }
        Map<String, Collection<SimpleFeature>> featuresPerLayer = this.queryFeaturesForLayers(selectedLayers);
        this.violationLayerCreator = this.validatorSupplier.apply(featuresPerLayer);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run(TaskMonitor monitor, PlugInContext context) throws Exception {
        try {
            if (this.violationLayerCreator == null) {
                return;
            }
            DefaultValidationResultHandler resultHandler = new DefaultValidationResultHandler(context.getWorkbenchFrame());
            this.violationLayerCreator.check(monitor, resultHandler, context.getLayerManager());
        }
        finally {
            this.violationLayerCreator = null;
        }
    }

    @Override
    public EnableCheck createEnableCheck() {
        EnableCheckFactory checkFactory = this.checkFactorySupplier.get();
        return new MultiEnableCheck().add(checkFactory.createWindowWithLayerNamePanelMustBeActiveCheck()).add(checkFactory.createAtLeastNLayersMustBeSelectedCheck(1));
    }

    private static void popupMaximumFeaturesExceeded(PlugInContext context) {
        GUISupport.msgbox((Component)context.getWorkbenchFrame(), (String)I18N.getMessage("ui.plugin.spatial.validation.ValidateSelectedLayersPlugIn.too-many-features", 50000), (String)I18N.get("ui.plugin.spatial.validation.ViolationLayerCreator.name"));
    }

    private int querySummedFeatureCount(Collection<Layer> selectedLayers) throws Exception {
        int featureCount = 0;
        for (Layer layer : selectedLayers) {
            featureCount += layer.getFeatureCount(false);
        }
        return featureCount;
    }

    private Map<String, Collection<SimpleFeature>> queryFeaturesForLayers(Collection<Layer> selectedLayers) throws Exception {
        HashMap<String, Collection<SimpleFeature>> featuresPerLayer = new HashMap<String, Collection<SimpleFeature>>();
        for (Layer layer : selectedLayers) {
            ArrayList<SimpleFeature> features = new ArrayList<SimpleFeature>();
            try (FeatureIterator<SimpleFeature> it = layer.getFeatureIterator((Filter)Filter.INCLUDE);){
                while (it.hasNext()) {
                    features.add((SimpleFeature)it.next());
                }
            }
            featuresPerLayer.put(layer.toString(), features);
        }
        return featuresPerLayer;
    }
}

