/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.plugin.spatial;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.model.RedlineLayer;
import com.vividsolutions.jump.workbench.model.Task;
import com.vividsolutions.jump.workbench.ui.LayerViewPanel;
import de.riwagis.geotools.feature.util.FilterUtil;
import de.riwagis.riwajump.data.model.DMDCollection;
import de.riwagis.riwajump.feature.util.SourceTargetResult;
import de.riwagis.riwajump.feature.util.SpatialUtil;
import de.riwagis.util.exception.SystemException;
import de.riwagis.util.thread.Cancelable;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.geotools.data.FeatureReader;
import org.locationtech.jts.geom.Envelope;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.Filter;

@XStreamAlias(value="spatialOp")
public class SpatialOperation
implements Cloneable {
    public static final Comparator<SpatialOperation> COMPARE_BY_NAME = (o1, o2) -> {
        if (o1 == null && o2 == null) {
            return 0;
        }
        if (o1 == null) {
            return -1;
        }
        if (o2 == null) {
            return 1;
        }
        return Collator.getInstance().compare(o1.getName(), o2.getName());
    };
    public static final int INTERSECT = 0;
    public static final int CONTAINS = 1;
    public static final int EQUALS = 2;
    public static final int DISJOINT = 3;
    private String strName;
    private String strSourceLayerID = null;
    private String strSourceLayerName = null;
    private String strSourceFilter = null;
    private int intMethod = 0;
    private double dblMinArea = 0.0;
    private boolean bolTouch = true;
    private boolean bolFeatureByFeature = false;
    private double dblMaxTargetEnvSize = 10000.0;
    private String strTargetLayerID = null;
    private String strTargetLayerName = null;
    private String strTargetFilter = null;
    private static String strSelection = I18N.get("ui.plugin.spatial.SpatialOperation.selection");
    private static String strLayer = I18N.get("common.layer");

    public SpatialOperation() {
        this("SpOp");
    }

    public SpatialOperation(String _strName) {
        this.strName = _strName;
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public String getName() {
        return this.strName;
    }

    public void setName(String _strName) {
        this.strName = _strName;
    }

    public boolean equals(Object obj) {
        if (obj instanceof SpatialOperation) {
            return ((SpatialOperation)obj).getName().equals(this.strName);
        }
        return false;
    }

    public int hashCode() {
        int hash = 23;
        hash = 71 * hash + (this.strName != null ? this.strName.hashCode() : 0);
        return hash;
    }

    public String toString() {
        String strReturn = this.strName + " (";
        strReturn = this.getSourceLayerID() == null || this.getSourceLayerID().length() == 0 ? strReturn + strSelection : strReturn + strLayer.concat(": ").concat(this.getSourceLayerName());
        strReturn = strReturn + " -> " + strLayer.concat(": ").concat(this.getTargetLayerName()) + ")";
        return strReturn;
    }

    public String getSourceLayerID() {
        return this.strSourceLayerID;
    }

    public void setSourceLayerID(String _strSourceLayerID) {
        this.strSourceLayerID = _strSourceLayerID;
    }

    public String getSourceLayerName() {
        if (this.strSourceLayerName == null) {
            return "";
        }
        return this.strSourceLayerName;
    }

    public void setSourceLayerName(String _strSourceLayerName) {
        this.strSourceLayerName = _strSourceLayerName;
    }

    public String getSourceFilter() {
        return this.strSourceFilter;
    }

    public void setSourceFilter(String _strSourceFilter) {
        this.strSourceFilter = _strSourceFilter;
    }

    public String getTargetLayerID() {
        return this.strTargetLayerID;
    }

    public void setTargetLayerID(String _strTargetLayerID) {
        this.strTargetLayerID = _strTargetLayerID;
    }

    public String getTargetLayerName() {
        if (this.strTargetLayerName == null) {
            return "";
        }
        return this.strTargetLayerName;
    }

    public void setTargetLayerName(String _strTargetLayerName) {
        this.strTargetLayerName = _strTargetLayerName;
    }

    public String getTargetFilter() {
        return this.strTargetFilter;
    }

    public void setTargetFilter(String _strTargetFilter) {
        this.strTargetFilter = _strTargetFilter;
    }

    public int getMethod() {
        return this.intMethod;
    }

    public void setMethod(int _intMethod) {
        this.intMethod = _intMethod;
    }

    public double getMinArea() {
        return this.dblMinArea;
    }

    public void setMinArea(double _dblMinArea) {
        this.dblMinArea = _dblMinArea;
    }

    public boolean getUseTouch() {
        return this.bolTouch;
    }

    public void setUseTouch(boolean _bolTouch) {
        this.bolTouch = _bolTouch;
    }

    public boolean getFeatureByFeature() {
        return this.bolFeatureByFeature;
    }

    public void setFeatureByFeature(boolean bolFeatureByFeature) {
        this.bolFeatureByFeature = bolFeatureByFeature;
    }

    public double getMaxTargetEnvSize() {
        return this.dblMaxTargetEnvSize;
    }

    public void setMaxTargetEnvSize(double _dblMaxTargetEnvSize) {
        this.dblMaxTargetEnvSize = _dblMaxTargetEnvSize;
    }

    public static Envelope[] tileEnvelope(Envelope env, double dblMaxSize) {
        double minY;
        double minX;
        int intFullWidth = (int)(env.getWidth() / dblMaxSize);
        int intFullHeight = (int)(env.getHeight() / dblMaxSize);
        double dblRestWidth = env.getWidth() % dblMaxSize;
        double dblRestHeight = env.getHeight() % dblMaxSize;
        Envelope[] arrEnv = new Envelope[(intFullWidth + 1) * (intFullHeight + 1)];
        int counter = 0;
        for (int i = 0; i < intFullWidth; ++i) {
            for (int j = 0; j < intFullHeight; ++j) {
                double minX2 = env.getMinX() + (double)i * dblMaxSize;
                double minY2 = env.getMinY() + (double)j * dblMaxSize;
                arrEnv[counter] = new Envelope(minX2, minX2 + dblMaxSize, minY2, minY2 + dblMaxSize);
                ++counter;
            }
            minX = env.getMinX() + (double)i * dblMaxSize;
            minY = env.getMinY() + (double)intFullHeight * dblMaxSize;
            arrEnv[counter] = new Envelope(minX, minX + dblMaxSize, minY, minY + dblRestHeight);
            ++counter;
        }
        for (int j = 0; j < intFullHeight; ++j) {
            minX = env.getMinX() + (double)intFullWidth * dblMaxSize;
            minY = env.getMinY() + (double)j * dblMaxSize;
            arrEnv[counter] = new Envelope(minX, minX + dblRestWidth, minY, minY + dblMaxSize);
            ++counter;
        }
        double minX3 = env.getMinX() + (double)intFullWidth * dblMaxSize;
        double minY3 = env.getMinY() + (double)intFullHeight * dblMaxSize;
        arrEnv[counter] = new Envelope(minX3, minX3 + dblRestWidth, minY3, minY3 + dblRestHeight);
        return arrEnv;
    }

    public static List<SourceTargetResult> executeOperation(Task task, SpatialOperation spOp, Cancelable canceledIndicator) throws Exception {
        DMDCollection dmdCol;
        Layer lyTarget;
        ArrayList<SimpleFeature> lstFeat = new ArrayList<SimpleFeature>();
        if (spOp.getSourceLayerID() == null) {
            LayerViewPanel lvPanel = WorkbenchContext.getFrame().getTaskFrameByTask(task).getLayerViewPanel();
            Iterator<SimpleFeature> iFeat = lvPanel.getSelectionManager().getFeatureSelection().getFeaturesWithSelectedItems().iterator();
            while (iFeat.hasNext()) {
                lstFeat.add(iFeat.next());
            }
        } else {
            FeatureReader<SimpleFeatureType, SimpleFeature> fr;
            Object filtSrc = spOp.getSourceFilter() != null && spOp.getSourceFilter().length() > 0 ? FilterUtil.getCQLFilter((String)spOp.getSourceFilter()) : Filter.INCLUDE;
            Layer lySrc = task.getLayerManager().getLayerByKey(spOp.getSourceLayerID());
            if (lySrc == null) {
                throw new SystemException(I18N.getMessage("ui.plugin.spatial.SpatialOperation.error-layer-not-found", spOp.getSourceLayerID(), spOp.getName()));
            }
            if (lySrc instanceof RedlineLayer) {
                RedlineLayer lyRedlineSrc = (RedlineLayer)lySrc;
                fr = lyRedlineSrc.getFMD().getFeatureReader(lyRedlineSrc.getDMDCol(), (Filter)filtSrc);
            } else {
                fr = lySrc.getFMD().getFeatureReader(task.getDataStores(), (Filter)filtSrc);
            }
            try (FeatureReader<SimpleFeatureType, SimpleFeature> featureReader = fr;){
                while (fr.hasNext()) {
                    lstFeat.add((SimpleFeature)fr.next());
                }
            }
        }
        if ((lyTarget = task.getLayerManager().getLayerByKey(spOp.getTargetLayerID())) == null) {
            throw new SystemException(I18N.getMessage("ui.plugin.spatial.SpatialOperation.error-layer-not-found", spOp.getTargetLayerID(), spOp.getName()));
        }
        if (lyTarget instanceof RedlineLayer) {
            RedlineLayer lyRedlineTarget = (RedlineLayer)lyTarget;
            dmdCol = lyRedlineTarget.getDMDCol();
        } else {
            dmdCol = task.getDataStores();
        }
        Object filtTarget = spOp.getTargetFilter() != null && spOp.getTargetFilter().length() > 0 ? FilterUtil.getCQLFilter((String)spOp.getTargetFilter()) : Filter.INCLUDE;
        return SpatialUtil.executeSpatialOperation(lstFeat, dmdCol, lyTarget.getFMD(), (Filter)filtTarget, spOp.getMaxTargetEnvSize(), spOp.getMethod(), spOp.getMinArea(), spOp.getUseTouch(), canceledIndicator);
    }

    public static List<SourceTargetResult> executeOperationFeatureByFeature(Task task, SpatialOperation spOp, Cancelable canceledIndicator) throws Exception {
        DMDCollection dmdCol;
        Layer lyTarget;
        ArrayList<SimpleFeature> lstFeatures = new ArrayList<SimpleFeature>();
        if (spOp.getSourceLayerID() == null) {
            LayerViewPanel lvPanel = WorkbenchContext.getFrame().getTaskFrameByTask(task).getLayerViewPanel();
            Iterator<SimpleFeature> iFeat = lvPanel.getSelectionManager().getFeatureSelection().getFeaturesWithSelectedItems().iterator();
            while (iFeat.hasNext()) {
                lstFeatures.add(iFeat.next());
            }
        } else {
            FeatureReader<SimpleFeatureType, SimpleFeature> fr;
            Object filtSrc = spOp.getSourceFilter() != null && spOp.getSourceFilter().length() > 0 ? FilterUtil.getCQLFilter((String)spOp.getSourceFilter()) : Filter.INCLUDE;
            Layer lySrc = task.getLayerManager().getLayerByKey(spOp.getSourceLayerID());
            if (lySrc == null) {
                throw new SystemException(I18N.getMessage("ui.plugin.spatial.SpatialOperation.error-layer-not-found", spOp.getSourceLayerID(), spOp.getName()));
            }
            if (lySrc instanceof RedlineLayer) {
                RedlineLayer lyRedlineSrc = (RedlineLayer)lySrc;
                fr = lyRedlineSrc.getFMD().getFeatureReader(lyRedlineSrc.getDMDCol(), (Filter)filtSrc);
            } else {
                fr = lySrc.getFMD().getFeatureReader(task.getDataStores(), (Filter)filtSrc);
            }
            while (fr.hasNext()) {
                lstFeatures.add((SimpleFeature)fr.next());
            }
        }
        if ((lyTarget = task.getLayerManager().getLayerByKey(spOp.getTargetLayerID())) == null) {
            throw new SystemException(I18N.getMessage("ui.plugin.spatial.SpatialOperation.error-layer-not-found", spOp.getTargetLayerID(), spOp.getName()));
        }
        if (lyTarget instanceof RedlineLayer) {
            RedlineLayer lyRedlineTarget = (RedlineLayer)lyTarget;
            dmdCol = lyRedlineTarget.getDMDCol();
        } else {
            dmdCol = task.getDataStores();
        }
        Object filtTarget = spOp.getTargetFilter() != null && spOp.getTargetFilter().length() > 0 ? FilterUtil.getCQLFilter((String)spOp.getTargetFilter()) : Filter.INCLUDE;
        ArrayList<SourceTargetResult> lstResult = new ArrayList<SourceTargetResult>();
        for (SimpleFeature feat : lstFeatures) {
            ArrayList<SimpleFeature> lstFeat = new ArrayList<SimpleFeature>();
            lstFeat.add(feat);
            List<SourceTargetResult> lstFeatureResult = SpatialUtil.executeSpatialOperation(lstFeat, dmdCol, lyTarget.getFMD(), (Filter)filtTarget, spOp.getMaxTargetEnvSize(), spOp.getMethod(), spOp.getMinArea(), spOp.getUseTouch(), canceledIndicator);
            lstResult.addAll(lstFeatureResult);
        }
        return lstResult;
    }
}

