/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.plugin.spatial;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.plugin.AbstractPlugIn;
import com.vividsolutions.jump.workbench.plugin.EnableCheck;
import com.vividsolutions.jump.workbench.plugin.EnableCheckFactory;
import com.vividsolutions.jump.workbench.plugin.MultiEnableCheck;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.ui.plugin.spatial.IntersectSelectionDialog;
import com.vividsolutions.jump.workbench.ui.plugin.spatial.SpatialOperation;
import de.riwagis.riwajump.feature.util.SourceTargetResult;
import de.riwagis.riwajump.feature.util.SpatialUtil;
import de.riwagis.util.gui.ExceptionDialog;
import de.riwagis.util.gui.GUISupport;
import de.riwagis.util.gui.components.WaitDialog;
import de.riwagis.util.thread.Cancelable;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Window;
import java.util.ArrayList;
import java.util.List;
import org.geotools.feature.FeatureIterator;
import org.opengis.feature.simple.SimpleFeature;

public class IntersectSelectionPlugIn
extends AbstractPlugIn {
    @Override
    public boolean execute(final PlugInContext context) throws Exception {
        Layer ly2select = context.getSelectedLayers()[0];
        if (ly2select == null) {
            return true;
        }
        IntersectSelectionDialog dlgParam = new IntersectSelectionDialog((Frame)context.getWorkbenchFrame(), ly2select.getName());
        GUISupport.centreComponent((Component)dlgParam, (Component)context.getWorkbenchFrame());
        dlgParam.setVisible(true);
        if (dlgParam.wasOkPressed()) {
            final SpatialOperation spOp = new SpatialOperation("_dummy");
            spOp.setMinArea(dlgParam.getMinArea());
            spOp.setUseTouch(dlgParam.useTouch());
            spOp.setTargetLayerID(ly2select.getKey());
            spOp.setMethod(0);
            spOp.setSourceLayerID(null);
            final WaitDialog dlgWait = WaitDialog.createWaitDialog((Window)context.getWorkbenchFrame(), (String)I18N.get("ui.plugin.spatial.SpatialOpPlugIn.please-wait"));
            Runnable runner = new Runnable(){

                @Override
                public void run() {
                    try {
                        List<SourceTargetResult> lstSTResult = SpatialOperation.executeOperation(context.getTask(), spOp, (Cancelable)dlgWait);
                        FeatureIterator<SimpleFeature> fi = SpatialUtil.getUniqueTargetFeatureIterator(lstSTResult);
                        context.getLayerViewPanel().getSelectionManager().clear();
                        ArrayList<SimpleFeature> lstResult = new ArrayList<SimpleFeature>();
                        while (fi.hasNext()) {
                            lstResult.add((SimpleFeature)fi.next());
                        }
                        context.getLayerViewPanel().getSelectionManager().getFeatureSelection().selectItems(context.getTask().getLayerManager().getLayerByKey(spOp.getTargetLayerID()), lstResult);
                    }
                    catch (Exception e) {
                        ExceptionDialog.handleGuiException((Component)context.getWorkbenchFrame(), (Throwable)e, (String)"riwagis");
                        dlgWait.setError(e);
                    }
                }
            };
            dlgWait.addWorkToDo(runner);
            dlgWait.setVisible(true);
        }
        return true;
    }

    @Override
    public EnableCheck createEnableCheck() {
        EnableCheckFactory checkFactory = EnableCheckFactory.getInstance();
        MultiEnableCheck chk = new MultiEnableCheck();
        chk.add(checkFactory.createWindowWithLayerViewPanelMustBeActiveCheck()).add(checkFactory.createExactlyNSelectableLayersMustBeSelectedCheck(1)).add(checkFactory.createAtLeastNFeaturesMustBeSelectedCheck(1));
        return chk;
    }

    @Override
    public String getName() {
        return I18N.get("ui.plugin.spatial.IntersectSelectionPlugIn.name");
    }
}

