/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.plugin.spatial;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.util.Blackboard;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.ui.GUIUtil;
import com.vividsolutions.jump.workbench.ui.plugin.PersistentBlackboardPlugIn;
import de.riwagis.util.gui.GUISupport;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.text.NumberFormat;
import java.text.ParseException;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.SwingUtilities;
import javax.swing.text.JTextComponent;

public class IntersectSelectionDialog
extends JDialog {
    private static final String PBB_USE_TOUCH = String.valueOf(IntersectSelectionDialog.class) + "_USE TOUCH";
    private static final String PBB_MIN_AREA = String.valueOf(IntersectSelectionDialog.class) + "_MIN_AREA";
    private boolean okPressed = false;
    private final NumberFormat nf = NumberFormat.getIntegerInstance();
    private final String layerName;
    private JButton butCancel;
    private JButton butOK;
    private JCheckBox cboUseTouch;
    private Box.Filler filler1;
    private JSeparator jSeparator1;
    private JLabel lblHeader;
    private JLabel lblMinArea;
    private JLabel lblUnit;
    private JPanel pnlOKCancel;
    private JFormattedTextField txtMinArea;

    public IntersectSelectionDialog(Frame parent, String layerName) {
        super(parent, true);
        this.initComponents();
        this.txtMinArea.setFormatterFactory(GUIUtil.getNumberFormat(this.nf));
        this.layerName = layerName;
        this.i18n();
        final Blackboard bb = PersistentBlackboardPlugIn.get();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                IntersectSelectionDialog.this.cboUseTouch.setSelected(bb.contains(PBB_USE_TOUCH) ? bb.getBoolean(PBB_USE_TOUCH) : false);
                if (bb.contains(PBB_MIN_AREA)) {
                    IntersectSelectionDialog.this.txtMinArea.setText(IntersectSelectionDialog.this.nf.format(new Double(bb.getDouble(PBB_MIN_AREA))));
                }
                GUISupport.centreOnScreen((Component)IntersectSelectionDialog.this);
                IntersectSelectionDialog.this.updateComponents();
            }
        });
        GUISupport.addKeyListenersRecursively((Component)this, (KeyListener)new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    IntersectSelectionDialog.this.butOKActionPerformed(null);
                }
            }
        });
        GUISupport.addCopyInsertPopup((JTextComponent)this.txtMinArea);
        this.setSize(400, 180);
    }

    private void i18n() {
        this.setTitle(I18N.get("ui.plugin.spatial.IntersectSpatialDialog.title"));
        this.lblHeader.setText(I18N.getMessage("ui.plugin.spatial.IntersectSpatialDialog.header", this.layerName));
        this.lblMinArea.setText(I18N.get("ui.plugin.spatial.IntersectSpatialDialog.min-area"));
        this.cboUseTouch.setText(I18N.get("ui.plugin.spatial.IntersectSpatialDialog.use-touch"));
        this.lblUnit.setText(WorkbenchContext.getTask().getDrawingUnit().getUnitAbbreviation() + "\u00b2");
    }

    public boolean wasOkPressed() {
        return this.okPressed;
    }

    public double getMinArea() {
        Number val;
        try {
            val = this.nf.parse(this.txtMinArea.getText());
        }
        catch (ParseException ex) {
            val = null;
        }
        if (val == null) {
            return 0.0;
        }
        return val.doubleValue();
    }

    public boolean useTouch() {
        if (this.getMinArea() > 0.0) {
            return false;
        }
        return this.cboUseTouch.isSelected();
    }

    @Override
    public void setVisible(boolean visi) {
        if (visi) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    IntersectSelectionDialog.this.txtMinArea.requestFocus();
                    IntersectSelectionDialog.this.txtMinArea.selectAll();
                }
            });
        }
        super.setVisible(visi);
        if (!visi && this.okPressed) {
            Blackboard bb = PersistentBlackboardPlugIn.get();
            bb.put(PBB_MIN_AREA, this.getMinArea());
            bb.put(PBB_USE_TOUCH, this.useTouch());
        }
    }

    private void updateComponents() {
        if (this.getMinArea() > 0.0) {
            this.cboUseTouch.setEnabled(false);
        } else {
            this.cboUseTouch.setEnabled(true);
        }
    }

    private void initComponents() {
        this.lblHeader = new JLabel();
        this.jSeparator1 = new JSeparator();
        this.lblMinArea = new JLabel();
        this.txtMinArea = new JFormattedTextField();
        this.lblUnit = new JLabel();
        this.filler1 = new Box.Filler(new Dimension(0, 0), new Dimension(0, 0), new Dimension(0, Short.MAX_VALUE));
        this.cboUseTouch = new JCheckBox();
        this.pnlOKCancel = new JPanel();
        this.butOK = new JButton();
        this.butCancel = new JButton();
        this.setDefaultCloseOperation(2);
        this.setMinimumSize(new Dimension(400, 200));
        this.setPreferredSize(new Dimension(400, 200));
        this.getContentPane().setLayout(new GridBagLayout());
        this.lblHeader.setFont(this.lblHeader.getFont().deriveFont(this.lblHeader.getFont().getStyle() | 1, this.lblHeader.getFont().getSize() + 1));
        this.lblHeader.setText("<html>Verschneidung wird ausgef\u00fchrt mit Ebene:<br><b style='color:red'>Ebene1</b></html>");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 23;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(9, 9, 9, 9);
        this.getContentPane().add((Component)this.lblHeader, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(4, 7, 4, 7);
        this.getContentPane().add((Component)this.jSeparator1, gridBagConstraints);
        this.lblMinArea.setText("min. gemeinsame Fl\u00e4che:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 22;
        gridBagConstraints.insets = new Insets(3, 9, 3, 3);
        this.getContentPane().add((Component)this.lblMinArea, gridBagConstraints);
        this.txtMinArea.setColumns(7);
        this.txtMinArea.setMinimumSize(new Dimension(100, 20));
        this.txtMinArea.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                IntersectSelectionDialog.this.txtMinAreaKeyReleased(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 9);
        this.getContentPane().add((Component)this.txtMinArea, gridBagConstraints);
        this.lblUnit.setText("units");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(3, 3, 3, 9);
        this.getContentPane().add((Component)this.lblUnit, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        this.getContentPane().add((Component)this.filler1, gridBagConstraints);
        this.cboUseTouch.setText("Ber\u00fchrungen ber\u00fccksichtigen");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 23;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 9);
        this.getContentPane().add((Component)this.cboUseTouch, gridBagConstraints);
        this.butOK.setText("OK");
        this.butOK.setMaximumSize(new Dimension(110, 23));
        this.butOK.setMinimumSize(new Dimension(110, 23));
        this.butOK.setPreferredSize(new Dimension(110, 23));
        this.butOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                IntersectSelectionDialog.this.butOKActionPerformed(evt);
            }
        });
        this.pnlOKCancel.add(this.butOK);
        this.butCancel.setText("abbrechen");
        this.butCancel.setMaximumSize(new Dimension(110, 23));
        this.butCancel.setMinimumSize(new Dimension(110, 23));
        this.butCancel.setPreferredSize(new Dimension(110, 23));
        this.butCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                IntersectSelectionDialog.this.butCancelActionPerformed(evt);
            }
        });
        this.pnlOKCancel.add(this.butCancel);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 20;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(3, 9, 9, 9);
        this.getContentPane().add((Component)this.pnlOKCancel, gridBagConstraints);
        this.pack();
    }

    private void butOKActionPerformed(ActionEvent evt) {
        this.okPressed = true;
        this.setVisible(false);
        this.dispose();
    }

    private void butCancelActionPerformed(ActionEvent evt) {
        this.okPressed = false;
        this.setVisible(false);
        this.dispose();
    }

    private void txtMinAreaKeyReleased(KeyEvent evt) {
        this.updateComponents();
    }
}

