/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.plugin.shapefile;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.workbench.model.Category;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.model.LayerManager;
import com.vividsolutions.jump.workbench.model.StandardCategoryNames;
import com.vividsolutions.jump.workbench.model.Task;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import de.riwagis.geotools.data.dir.DirShpDataStoreFactory;
import de.riwagis.geotools.data.shapefile.ShapefileDataStoreFactory;
import de.riwagis.riwajump.data.model.DMDCollection;
import de.riwagis.riwajump.data.model.DatastoreMetadata;
import de.riwagis.riwajump.data.model.FeaturestoreMetadata;
import de.riwagis.riwajump.workbench.ui.plugin.ImportMessages;
import de.riwagis.riwajump.workbench.ui.plugin.ImportStyleDefaults;
import de.riwagis.util.gui.GUISupport;
import java.awt.Color;
import java.io.File;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import javax.swing.filechooser.FileFilter;
import lombok.Generated;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.geotools.util.URLs;
import org.opengis.feature.simple.SimpleFeatureType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShapefileUtils {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ShapefileUtils.class);
    public static final FileFilter SHP_FILE_FILTER = GUISupport.createFileFilter((String)"ESRI Shapefile", (String[])new String[]{"shp"});
    public static final String FIELD_GEOMETRY = "the_geom";
    public static final String SHP_ENDING = ".shp";
    public static final String SHAPE_DIRECTORY = "Shape Directory";

    public static ImportMessages addShapeFiles(PlugInContext context, List<File> arrFiles, String strEncoding) throws Exception {
        return ShapefileUtils.addShapeFiles(context, arrFiles, strEncoding, null);
    }

    public static ImportMessages addShapeFiles(PlugInContext context, List<File> files, String encoding, Category category) throws Exception {
        return ShapefileUtils.addShapeFiles(context, files, encoding, category, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ImportMessages addShapeFiles(PlugInContext context, List<File> files, String encoding, Category category, Consumer<Layer> layerConfigurator) throws Exception {
        if (category == null) {
            category = context.getLayerNamePanel().getSelectedCategoryOrDefault(StandardCategoryNames.SHAPES);
        }
        ImportMessages messages = new ImportMessages((type, params) -> {
            switch (type) {
                case CRS_DOES_NOT_MATCH: {
                    return I18N.getMessage("ui.plugin.shapefile.LoadShapefilePlugIn.crs-does-not-match", params);
                }
                case OUTSIDE_BOUNDS: {
                    return I18N.getMessage("ui.plugin.shapefile.LoadShapefilePlugIn.outside-bounds", params);
                }
            }
            return null;
        });
        File directory = new File(files.get(0).getParent());
        DMDCollection dmds = context.getTask().getLocalDataStores();
        DatastoreMetadata dmd = ShapefileUtils.createShapeFileDirectoryDataStore(context.getTask(), dmds, directory, encoding);
        LayerManager lyMngr = context.getLayerManager();
        for (File file : files) {
            Layer layer;
            String typeName = FilenameUtils.getBaseName((String)file.getAbsolutePath());
            FeaturestoreMetadata fmd = FeaturestoreMetadata.createFromType(dmd, typeName);
            SimpleFeatureType schema = fmd.getSchema(dmds);
            boolean bolFireEvents = lyMngr.isFiringEvents();
            try {
                lyMngr.setFiringEvents(false);
                Color color = lyMngr.generateLayerFillColor();
                layer = new Layer(typeName, color, fmd, lyMngr);
                ImportStyleDefaults.setLayerStyleDefaults(layer, schema);
                ImportStyleDefaults.setLayerStylePerGeometryType(layer, schema, color);
                ImportStyleDefaults.setLayerCaching(layer);
                layer.setEditable(true);
                if (layerConfigurator != null) {
                    layerConfigurator.accept(layer);
                }
                messages.createWarnings(schema, context, layer, lyMngr);
            }
            finally {
                lyMngr.setFiringEvents(bolFireEvents);
            }
            category.add(0, layer);
        }
        return messages;
    }

    public static DatastoreMetadata dmd4Path(DMDCollection dmdCol, File dir, String strEncoding) {
        if (!dir.isDirectory()) {
            return null;
        }
        for (DatastoreMetadata dmd : dmdCol) {
            if (!dmd.getDataName().equals(SHAPE_DIRECTORY)) continue;
            Object dmdDir = dmd.getParameters().get(DirShpDataStoreFactory.DIRECTORY.key);
            Object objCharset = dmd.getParameters().get(DirShpDataStoreFactory.DBFCHARSET.key);
            if (!Objects.nonNull(dmdDir) || !Objects.equals(dir, dmdDir.toString()) || !Objects.equals(strEncoding, objCharset)) continue;
            return dmd;
        }
        return null;
    }

    public static DatastoreMetadata createShapeFileDirectoryDataStore(Task task, DMDCollection dmdCol, File shpDir, String strEncoding) {
        DatastoreMetadata dmd4Shape = ShapefileUtils.dmd4Path(dmdCol, shpDir, strEncoding);
        if (dmd4Shape == null) {
            dmd4Shape = ShapefileUtils.forceCreateShapeFileDirectoryDataStore(task, shpDir, strEncoding);
        } else {
            dmd4Shape.reset();
        }
        return dmd4Shape;
    }

    public static DatastoreMetadata forceCreateShapeFileDirectoryDataStore(Task task, File shpDir, String strEncoding) {
        String strDMDName = null;
        try {
            strDMDName = FilenameUtils.getName((String)shpDir.toString());
        }
        catch (Exception e) {
            log.warn("Could not get DMD name", (Throwable)e);
        }
        if (strDMDName == null || strDMDName.length() == 0) {
            strDMDName = "root";
        }
        strDMDName = task.getDataStores().findUniqueStoreName(strDMDName);
        HashMap<String, Object> mapParams = new HashMap<String, Object>();
        mapParams.put(DirShpDataStoreFactory.DIRECTORY.key, shpDir.toString());
        if (StringUtils.isNotEmpty((CharSequence)strEncoding)) {
            mapParams.put(DirShpDataStoreFactory.DBFCHARSET.key, strEncoding);
        }
        DatastoreMetadata dmd4Shape = new DatastoreMetadata(strDMDName, SHAPE_DIRECTORY, mapParams);
        task.getLocalDataStores().addDatastore(dmd4Shape);
        task.reinitCachedObjects();
        return dmd4Shape;
    }

    public static String getEncoding4ShapeFileDataStore(DatastoreMetadata dmd) {
        if (dmd == null) {
            return null;
        }
        if (dmd.getDataName().equals(SHAPE_DIRECTORY)) {
            return Objects.toString(dmd.getParameters().get(DirShpDataStoreFactory.DBFCHARSET.key), null);
        }
        if (dmd.getDataName().equals("Shapefile")) {
            return Objects.toString(dmd.getParameters().get(ShapefileDataStoreFactory.DBFCHARSET.key), null);
        }
        return null;
    }

    public static String getPath4ShapeFileDataStore(DatastoreMetadata dmd) {
        if (dmd == null) {
            return null;
        }
        if (dmd.getDataName().equals(SHAPE_DIRECTORY)) {
            return Objects.toString(dmd.getParameters().get(DirShpDataStoreFactory.DIRECTORY.key), "");
        }
        if (dmd.getDataName().equals("Shapefile")) {
            Object obj = dmd.getParameters().get(ShapefileDataStoreFactory.URLP.key);
            if (obj instanceof String) {
                return new File(Objects.toString(obj, "")).getParent();
            }
            if (obj instanceof URL) {
                return URLs.urlToFile((URL)((URL)obj)).getParent();
            }
        }
        return null;
    }

    public static String addSuffix(String str, String strSuffix) {
        if (str.toLowerCase().endsWith(strSuffix.toLowerCase())) {
            return str;
        }
        return str + strSuffix;
    }

    private ShapefileUtils() {
    }
}

