/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.plugin.scalebar;

import com.vividsolutions.jump.task.LayerView;
import com.vividsolutions.jump.util.Blackboard;
import com.vividsolutions.jump.util.MathUtil;
import com.vividsolutions.jump.workbench.ui.plugin.scalebar.IncrementChooser;
import com.vividsolutions.jump.workbench.ui.plugin.scalebar.RoundQuantity;
import com.vividsolutions.jump.workbench.ui.renderer.SimpleRenderer;
import de.riwagis.unit.DrawingUnit;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Stroke;
import java.awt.font.TextLayout;
import java.awt.geom.Rectangle2D;
import javax.swing.UIManager;

public class ScaleBarRenderer
extends SimpleRenderer {
    public static final String CONTENT_ID = "SCALE_BAR";
    private static final int BAR_HEIGHT = 10;
    private static final Color FILL2 = Color.gray;
    private static final Color FILL1 = Color.white;
    private static final Color TEXT2 = Color.black;
    private static final Color TEXT1 = Color.white;
    private static final int IDEAL_INCREMENT = 75;
    private static final Color LINE_COLOR = Color.black;
    private static final int TEXT_BOTTOM_MARGIN = 1;
    private static final int UNIT_TEXT_BOTTOM_MARGIN = 1;
    private static final Color UNIT_TEXT_COLOR = Color.black;
    private static final String ENABLED_KEY = String.valueOf(ScaleBarRenderer.class) + " - ENABLED";
    private static final int INCREMENT_COUNT = 5;
    private final Font FONT = UIManager.getFont("Label.font").deriveFont(10.0f);
    private final Font UNIT_FONT = UIManager.getFont("Label.font").deriveFont(1, 11.0f);
    private final Stroke stroke = new BasicStroke();
    private DrawingUnit unit = null;
    private int intHorizontalMargin = 3;
    private int intVerticalMargin = 3;
    private final LayerView panel;

    public ScaleBarRenderer(LayerView panel) {
        super(CONTENT_ID, panel.getContext());
        this.panel = panel;
    }

    public void setHorizontalMargin(int _intHorizontalMargin) {
        this.intHorizontalMargin = _intHorizontalMargin;
    }

    public void setVerticalMargin(int _intVerticalMargin) {
        this.intVerticalMargin = _intVerticalMargin;
    }

    public static boolean isEnabled(Blackboard blackboard) {
        return blackboard.get(ENABLED_KEY, false);
    }

    public static void setEnabled(boolean enabled, Blackboard blackboard) {
        blackboard.put(ENABLED_KEY, enabled);
    }

    @Override
    protected void paint(Graphics2D g) {
        this.paint(g, this.panel.getViewport().getScale());
    }

    public void paint(Graphics2D g, double scale) {
        if (ScaleBarRenderer.isEnabled(this.panel.getBlackboard())) {
            g.setStroke(this.stroke);
            this.unit = this.panel.getLayerManager().getTask().getDrawingUnit();
            RoundQuantity increment = new IncrementChooser(this.unit).chooseGoodIncrement(75.0 / scale);
            this.paintIncrements(increment, 5, g, scale);
        }
    }

    private int barBottom() {
        return this.intVerticalMargin + 10;
    }

    private int barTop() {
        return this.intVerticalMargin;
    }

    private TextLayout createTextLayout(String text, Font font, Graphics2D g) {
        return new TextLayout(text, font, g.getFontRenderContext());
    }

    private void paintIncrement(int i, RoundQuantity increment, int incrementCount, Graphics2D g, double scale) {
        Rectangle2D.Double shape = new Rectangle2D.Double(this.x(i, increment, incrementCount, scale), this.barTop(), this.x(i + 1, increment, incrementCount, scale) - this.x(i, increment, incrementCount, scale), this.barBottom() - this.barTop());
        g.setColor(i % 2 == 0 ? FILL1 : FILL2);
        g.fill(shape);
        g.setColor(LINE_COLOR);
        g.draw(shape);
    }

    private void paintIncrements(RoundQuantity increment, int incrementCount, Graphics2D g, double scale) {
        for (int i = 0; i < incrementCount; ++i) {
            this.paintIncrement(i, increment, incrementCount, g, scale);
            this.paintLabel(i, increment, incrementCount, g, scale);
        }
    }

    private void paintLabel(int i, RoundQuantity increment, int incrementCount, Graphics2D g, double scale) {
        String text = new RoundQuantity(increment.getMantissa() * (i + 1), increment.getExponent(), increment.getUnit()).getAmountString();
        Font font = this.FONT;
        g.setColor(i % 2 == 0 ? TEXT2 : TEXT1);
        int textBottomMargin = 1;
        if (i == incrementCount - 1) {
            text = increment.getUnit().getUnitAbbreviation();
            font = this.UNIT_FONT;
            g.setColor(UNIT_TEXT_COLOR);
            textBottomMargin = 1;
        }
        TextLayout layout = this.createTextLayout(text, font, g);
        double center = MathUtil.avg(this.x(i, increment, incrementCount, scale), this.x(i + 1, increment, incrementCount, scale));
        layout.draw(g, (float)(center - (double)(layout.getAdvance() / 2.0f)), this.barBottom() - textBottomMargin);
    }

    private double x(int i, RoundQuantity increment, int incrementCount, double scale) {
        return (double)this.intHorizontalMargin + (double)i * increment.getModelValue(this.unit) * scale;
    }
}

