/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.plugin.scalebar;

import de.riwagis.unit.DrawingUnit;
import java.text.DecimalFormat;

public class RoundQuantity {
    private final DrawingUnit unit;
    private final int mantissa;
    private final int exponent;

    public RoundQuantity(int mantissa, int exponent, DrawingUnit unit) {
        this.mantissa = mantissa;
        this.exponent = exponent;
        this.unit = unit;
    }

    public DrawingUnit getUnit() {
        return this.unit;
    }

    public int getMantissa() {
        return this.mantissa;
    }

    public String toString() {
        return this.getAmountString() + " " + this.getUnit().getUnitAbbreviation();
    }

    public String getAmountString() {
        if (this.getMantissa() == 0) {
            return "0";
        }
        if (0 <= this.getExponent() && this.getExponent() <= 3) {
            return new DecimalFormat("#").format(this.getAmount());
        }
        if (-4 <= this.getExponent() && this.getExponent() < 0) {
            return new DecimalFormat("#.####").format(this.getAmount());
        }
        return this.getMantissa() + "E" + this.getExponent();
    }

    public int getExponent() {
        return this.exponent;
    }

    public double getAmount() {
        return (double)this.mantissa * Math.pow(10.0, this.exponent);
    }

    public double getModelValue(DrawingUnit drawingUnit) {
        return this.getAmount() * this.unit.getUnitInMeter() / drawingUnit.getUnitInMeter();
    }
}

