/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.plugin.scalebar;

import com.vividsolutions.jump.util.MathUtil;
import com.vividsolutions.jump.workbench.ui.plugin.scalebar.RoundQuantity;
import de.riwagis.unit.DrawingUnit;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.locationtech.jts.util.Assert;

public class IncrementChooser {
    private final Collection<DrawingUnit> system = new ArrayList<DrawingUnit>();
    private DrawingUnit drawingUnit = null;

    public IncrementChooser(DrawingUnit _drawingUnit) {
        this.setDrawingUnit(_drawingUnit);
    }

    public final void setDrawingUnit(DrawingUnit _drawingUnit) {
        this.drawingUnit = _drawingUnit;
        this.system.clear();
        this.system.addAll(this.drawingUnit.getSystem());
    }

    public RoundQuantity chooseGoodIncrement(double idealIncrement) {
        return this.goodIncrement(this.goodUnit(idealIncrement), idealIncrement);
    }

    private DrawingUnit goodUnit(double idealIncrement) {
        DrawingUnit goodUnit = Collections.min(this.system);
        for (DrawingUnit candidateUnit : this.system) {
            if (this.getModelValue(candidateUnit) > idealIncrement || !(this.distance(this.getModelValue(candidateUnit), idealIncrement) < this.distance(this.getModelValue(goodUnit), idealIncrement))) continue;
            goodUnit = candidateUnit;
        }
        return goodUnit;
    }

    private double getModelValue(DrawingUnit unit) {
        return unit.getUnitInMeter() / this.drawingUnit.getUnitInMeter();
    }

    private double distance(double a, double b) {
        return Math.abs(MathUtil.orderOfMagnitude(a) - MathUtil.orderOfMagnitude(b));
    }

    private RoundQuantity goodIncrement(DrawingUnit unit, double idealIncrement) {
        RoundQuantity mantissa1Candidate = new RoundQuantity(1, (int)Math.floor(MathUtil.orderOfMagnitude(idealIncrement) - MathUtil.orderOfMagnitude(this.getModelValue(unit))), unit);
        Assert.isTrue((mantissa1Candidate.getModelValue(this.drawingUnit) <= idealIncrement ? 1 : 0) != 0, (String)String.format("unit=%s, ideal increment=%s", this.getModelValue(unit), idealIncrement));
        RoundQuantity mantissa2Candidate = new RoundQuantity(2, mantissa1Candidate.getExponent(), unit);
        RoundQuantity mantissa5Candidate = new RoundQuantity(5, mantissa1Candidate.getExponent(), unit);
        if (mantissa5Candidate.getModelValue(this.drawingUnit) <= idealIncrement) {
            return mantissa5Candidate;
        }
        if (mantissa2Candidate.getModelValue(this.drawingUnit) <= idealIncrement) {
            return mantissa2Candidate;
        }
        return mantissa1Candidate;
    }
}

