/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.plugin.raster.imp;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.workbench.model.Layerable;
import com.vividsolutions.jump.workbench.model.RasterImageLayer;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.ui.InputChangedListener;
import com.vividsolutions.jump.workbench.ui.plugin.raster.imp.GeoRefPanel;
import com.vividsolutions.jump.workbench.ui.plugin.raster.imp.ImportRasterPlugIn;
import com.vividsolutions.jump.workbench.ui.wizard.WizardPanel;
import de.riwagis.util.gui.ExceptionDialog;
import de.riwagis.util.gui.components.WaitDialog;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class WizGeoRefPanel
extends JPanel
implements WizardPanel {
    public static final String PARAM_LAYER = "layer";
    private PlugInContext context = null;
    private Map<String, Object> dataMap = null;
    private final List<InputChangedListener> lstListeners = new ArrayList<InputChangedListener>();
    private RasterImageLayer rly = null;
    private GeoRefPanel geoRefPanel;

    public WizGeoRefPanel(PlugInContext _context) {
        this.context = _context;
        this.initComponents();
        this.i18n();
    }

    private void i18n() {
    }

    @Override
    public void enteredFromLeft(Map<String, Object> dataMap) {
        try {
            this.dataMap = dataMap;
            File rasterFile = (File)dataMap.get("file");
            this.rly = ImportRasterPlugIn.createWorldFileRasterImageLayer(rasterFile, this.context);
            dataMap.put(PARAM_LAYER, this.rly);
            this.geoRefPanel.setImageFile(rasterFile);
        }
        catch (Exception e) {
            ExceptionDialog.handleGuiException((Component)this, (Exception)e, WizGeoRefPanel.class);
        }
    }

    @Override
    public void enteredFromRight(Map<String, Object> dataMap) {
    }

    @Override
    public void exitingToRight() throws Exception {
        File bakFile;
        final WaitDialog dlgWait = new WaitDialog(SwingUtilities.windowForComponent(this), I18N.get("ui.plugin.raster.imp.WizGeoRefPanel.wait-for-georef"));
        Runnable run = new Runnable(){

            @Override
            public void run() {
                try {
                    WizGeoRefPanel.this.geoRefPanel.writeNewWorldFile();
                    WizGeoRefPanel.this.rly.reload();
                    WizGeoRefPanel.this.geoRefPanel.removeControlPointPreview();
                }
                catch (Exception e) {
                    dlgWait.setError(e);
                }
            }
        };
        dlgWait.addWorkToDo(run);
        dlgWait.setVisible(true);
        if (dlgWait.getError() != null) {
            ExceptionDialog.handleGuiException((Component)this, (Exception)dlgWait.getError(), WizGeoRefPanel.class);
        }
        if (this.dataMap.get("grefBakFile") != null && (bakFile = (File)this.dataMap.get("grefBakFile")).exists()) {
            bakFile.delete();
        }
    }

    @Override
    public void exitingToLeft() {
        Layerable ly = (Layerable)this.dataMap.get(PARAM_LAYER);
        if (ly != null) {
            this.context.getLayerManager().remove(ly);
        }
        this.rly = null;
        this.geoRefPanel.removeControlPointPreview();
    }

    @Override
    public void cleanupAtCancel(Map<String, Object> dataMap) {
        this.exitingToLeft();
    }

    @Override
    public void add(InputChangedListener listener) {
        this.lstListeners.add(listener);
        this.geoRefPanel.add(listener);
    }

    @Override
    public void remove(InputChangedListener listener) {
        if (this.lstListeners.contains(listener)) {
            this.lstListeners.remove(listener);
            this.geoRefPanel.remove(listener);
        }
    }

    private void fireInputChange() {
        for (InputChangedListener listener : this.lstListeners) {
            listener.inputChanged();
        }
    }

    @Override
    public String getTitle() {
        return I18N.get("ui.plugin.raster.imp.WizGeoRefPanel.title");
    }

    @Override
    public String getID() {
        return "3";
    }

    @Override
    public String getInstructions() {
        return "";
    }

    @Override
    public boolean isInputValid() {
        File rasterFile = (File)this.dataMap.get("file");
        if (rasterFile == null || !rasterFile.exists()) {
            return false;
        }
        return this.geoRefPanel.getControlPoints().size() >= 2;
    }

    @Override
    public String getNextID() {
        return null;
    }

    private void initComponents() {
        this.geoRefPanel = new GeoRefPanel();
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 23;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.geoRefPanel, gridBagConstraints);
    }
}

