/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.plugin.raster.imp;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.ui.InputChangedListener;
import com.vividsolutions.jump.workbench.ui.cursortool.ChooseEnvelopeTool;
import com.vividsolutions.jump.workbench.ui.cursortool.CursorTool;
import com.vividsolutions.jump.workbench.ui.cursortool.QuasimodeTool;
import com.vividsolutions.jump.workbench.ui.plugin.raster.imp.ImportRasterPlugIn;
import com.vividsolutions.jump.workbench.ui.plugin.raster.imp.RasterImageFormats;
import com.vividsolutions.jump.workbench.ui.wizard.WizardPanel;
import de.riwagis.icons.IconLoader;
import de.riwagis.riwajump.workbench.renderer.GenericOverlayFeature;
import de.riwagis.riwajump.workbench.renderer.GenericOverlayPlugin;
import de.riwagis.util.file.FileSupport;
import de.riwagis.util.gui.components.WaitDialog;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Stroke;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateList;
import org.locationtech.jts.geom.CoordinateSequence;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.util.Assert;

public class WizChooseRectanglePanel
extends JPanel
implements WizardPanel,
ChooseEnvelopeTool.EnvelopeConsumer {
    public static final String PARAM_FILE = "file";
    public static final String PARAM_IMAGE_DIM = "imageDim";
    public static final String PARAM_ENV = "env";
    public static final String PARAM_GREF_BAK_FILE = "grefBakFile";
    private static final String RECT_PREVIEW = "GEOREF_RECT_PREVIEW";
    private PlugInContext context = null;
    private Map<String, Object> dataMap = null;
    private Envelope env = null;
    private final List<InputChangedListener> lstListeners = new ArrayList<InputChangedListener>();
    private boolean bolGeorefCreated = false;
    private final ChooseEnvelopeTool chooseEnvTool = new ChooseEnvelopeTool(this);
    private CursorTool oldCursorTool = null;
    private final DecimalFormat df = new DecimalFormat("0.0####");
    private File georefBakFile = null;
    private final GeometryFactory gfac = new GeometryFactory();
    private JButton butChoose;
    private JPanel jPanel1;
    private JLabel lblBottom;
    private JLabel lblLeft;
    private JLabel lblNotWriteable;
    private JLabel lblRight;
    private JLabel lblTifConvert;
    private JLabel lblTop;

    public WizChooseRectanglePanel(PlugInContext _context) {
        this.context = _context;
        this.initComponents();
        this.lblNotWriteable.setVisible(false);
        this.i18n();
        this.lblTop.setText("");
        this.lblLeft.setText("");
        this.lblRight.setText("");
        this.lblBottom.setText("");
        this.df.setGroupingUsed(false);
    }

    private void i18n() {
        this.lblNotWriteable.setText(I18N.get("ui.plugin.raster.imp.WizChooseOverwriteGeoRef.not-writeable"));
        this.lblTifConvert.setText(I18N.get("ui.plugin.raster.imp.WizChooseRectanglePanel.tif-convert-hint"));
    }

    @Override
    public void enteredFromLeft(Map<String, Object> dataMap) {
        File imgFile;
        RasterImageFormats fmt;
        this.dataMap = dataMap;
        this.env = null;
        if (dataMap.containsKey(PARAM_ENV)) {
            try {
                this.setEnvelope((Envelope)dataMap.get(PARAM_ENV));
            }
            catch (Exception ex) {
                Assert.shouldNeverReachHere((String)"Error setting envelope in WizChooseRectanglePanel.");
            }
        }
        if ((fmt = RasterImageFormats.getFormat(imgFile = (File)dataMap.get("orifile"))) != null && fmt == RasterImageFormats.TIF) {
            this.lblTifConvert.setVisible(false);
        } else {
            this.lblTifConvert.setVisible(true);
        }
    }

    @Override
    public void enteredFromRight(Map<String, Object> dataMap) {
        this.activateGeorefBakFile(dataMap);
        this.enteredFromLeft(dataMap);
    }

    private void enableOldCursorTool() {
        if (this.oldCursorTool != null) {
            this.context.getLayerViewPanel().setCurrentCursorTool(this.oldCursorTool);
            this.oldCursorTool = null;
        }
    }

    @Override
    public void exitingToRight() throws Exception {
        this.removePreview();
        this.enableOldCursorTool();
        final WaitDialog dlgWait = new WaitDialog(SwingUtilities.windowForComponent(this), I18N.get("common.wait"));
        dlgWait.setCancelable(false);
        Runnable workToDo = new Runnable(){

            @Override
            public void run() {
                try {
                    File imgFile = (File)WizChooseRectanglePanel.this.dataMap.get("orifile");
                    imgFile = ImportRasterPlugIn.saveImageAsTiff(imgFile);
                    WizChooseRectanglePanel.this.dataMap.put(WizChooseRectanglePanel.PARAM_FILE, imgFile);
                    Dimension imageDim = ImportRasterPlugIn.getImageDimension(imgFile);
                    WizChooseRectanglePanel.this.dataMap.put(WizChooseRectanglePanel.PARAM_IMAGE_DIM, imageDim);
                    WizChooseRectanglePanel.this.dataMap.put(WizChooseRectanglePanel.PARAM_ENV, WizChooseRectanglePanel.this.env);
                    double[] arrParam = ImportRasterPlugIn.getGeoRefParameters4Envelope(imageDim, WizChooseRectanglePanel.this.env);
                    File georefFile = RasterImageFormats.getGeoRefFile(imgFile);
                    WizChooseRectanglePanel.this.georefBakFile = ImportRasterPlugIn.writeGeoRefParameters2File(georefFile, arrParam, true);
                    if (WizChooseRectanglePanel.this.georefBakFile != null && WizChooseRectanglePanel.this.georefBakFile.exists()) {
                        WizChooseRectanglePanel.this.dataMap.put(WizChooseRectanglePanel.PARAM_GREF_BAK_FILE, WizChooseRectanglePanel.this.georefBakFile);
                    } else {
                        WizChooseRectanglePanel.this.dataMap.remove(WizChooseRectanglePanel.PARAM_GREF_BAK_FILE);
                    }
                    WizChooseRectanglePanel.this.bolGeorefCreated = true;
                    WizChooseRectanglePanel.this.env = null;
                }
                catch (Exception e) {
                    dlgWait.setError(e);
                }
            }
        };
        dlgWait.addWorkToDo(workToDo);
        dlgWait.setVisible(2000L);
        if (dlgWait.getError() != null) {
            if (ExceptionUtils.getRootCause((Throwable)dlgWait.getError()) instanceof OutOfMemoryError) {
                throw new Exception(I18N.getMessage("common.out-of-memory", ExceptionUtils.getRootCause((Throwable)dlgWait.getError()).getMessage()));
            }
            throw dlgWait.getError();
        }
    }

    @Override
    public void exitingToLeft() {
        this.removeEnv();
        this.removePreview();
        if (this.oldCursorTool != null) {
            this.context.getLayerViewPanel().setCurrentCursorTool(this.oldCursorTool);
            this.oldCursorTool = null;
        }
        this.activateGeorefBakFile(this.dataMap);
        this.deleteCreatedTifFile(this.dataMap);
    }

    @Override
    public void cleanupAtCancel(Map<String, Object> dataMap) {
        this.removePreview();
        this.enableOldCursorTool();
        this.activateGeorefBakFile(dataMap);
        this.deleteCreatedTifFile(dataMap);
    }

    private void activateGeorefBakFile(Map<String, Object> dataMap) {
        File imgFile = (File)dataMap.get(PARAM_FILE);
        if (imgFile != null) {
            File georefFile = RasterImageFormats.getGeoRefFile(imgFile);
            if (georefFile.exists() && this.bolGeorefCreated) {
                georefFile.delete();
                this.bolGeorefCreated = false;
            }
            if (this.georefBakFile != null && this.georefBakFile.exists()) {
                this.georefBakFile.renameTo(georefFile);
                this.georefBakFile = null;
            }
        }
    }

    private void deleteCreatedTifFile(Map<String, Object> dataMap) {
        File imgFileNew = (File)dataMap.get(PARAM_FILE);
        File imgFileOri = (File)dataMap.get("orifile");
        if (!imgFileOri.equals(imgFileNew) && imgFileNew != null && imgFileNew.exists()) {
            File gRefFile = RasterImageFormats.getGeoRefFile(imgFileNew);
            dataMap.remove(PARAM_FILE);
            imgFileNew.delete();
            if (gRefFile.exists()) {
                gRefFile.delete();
            }
        }
    }

    private void removePreview() {
        GenericOverlayPlugin.removeFeature(RECT_PREVIEW);
        this.context.getLayerViewPanel().copyTo();
    }

    private void removeEnv() {
        this.env = null;
        this.dataMap.remove(PARAM_ENV);
        this.lblTop.setText("");
        this.lblBottom.setText("");
        this.lblLeft.setText("");
        this.lblRight.setText("");
    }

    @Override
    public void add(InputChangedListener listener) {
        this.lstListeners.add(listener);
    }

    @Override
    public void remove(InputChangedListener listener) {
        if (this.lstListeners.contains(listener)) {
            this.lstListeners.remove(listener);
        }
    }

    private void fireInputChange() {
        for (InputChangedListener listener : this.lstListeners) {
            listener.inputChanged();
        }
    }

    @Override
    public String getTitle() {
        return I18N.get("ui.plugin.raster.imp.WizChooseRectanglePanel.title");
    }

    @Override
    public String getID() {
        return "2";
    }

    @Override
    public String getInstructions() {
        return I18N.get("ui.plugin.raster.imp.WizChooseRectanglePanel.instruction");
    }

    @Override
    public boolean isInputValid() {
        if (this.env == null) {
            return false;
        }
        File imgFile = (File)this.dataMap.get("orifile");
        if (FileSupport.canWrite((File)imgFile.getParentFile())) {
            return true;
        }
        this.lblNotWriteable.setVisible(true);
        return false;
    }

    @Override
    public String getNextID() {
        return "3";
    }

    @Override
    public void deactivate() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                SwingUtilities.windowForComponent(WizChooseRectanglePanel.this).setVisible(true);
            }
        });
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.butChoose = new JButton();
        this.lblTop = new JLabel();
        this.lblLeft = new JLabel();
        this.lblRight = new JLabel();
        this.lblBottom = new JLabel();
        this.lblNotWriteable = new JLabel();
        this.lblTifConvert = new JLabel();
        this.setForeground(new Color(255, 0, 0));
        this.setLayout(new GridBagLayout());
        this.jPanel1.setBorder(BorderFactory.createTitledBorder("XY"));
        this.jPanel1.setPreferredSize(new Dimension(150, 150));
        this.jPanel1.setLayout(new GridBagLayout());
        this.butChoose.setIcon(IconLoader.svgIcon((String)"geometry_add_rectangle.svg"));
        this.butChoose.setMargin(new Insets(2, 2, 2, 2));
        this.butChoose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                WizChooseRectanglePanel.this.butChooseActionPerformed(evt);
            }
        });
        this.jPanel1.add((Component)this.butChoose, new GridBagConstraints());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.jPanel1, gridBagConstraints);
        this.lblTop.setText("top");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 20;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.add((Component)this.lblTop, gridBagConstraints);
        this.lblLeft.setText("left");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 22;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.add((Component)this.lblLeft, gridBagConstraints);
        this.lblRight.setText("right");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.add((Component)this.lblRight, gridBagConstraints);
        this.lblBottom.setText("bottom");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 19;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.add((Component)this.lblBottom, gridBagConstraints);
        this.lblNotWriteable.setFont(this.lblNotWriteable.getFont().deriveFont(this.lblNotWriteable.getFont().getStyle() | 1));
        this.lblNotWriteable.setForeground(new Color(255, 0, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 23;
        gridBagConstraints.insets = new Insets(9, 9, 9, 9);
        this.add((Component)this.lblNotWriteable, gridBagConstraints);
        this.lblTifConvert.setText("<html>Hinweis: Aus Performancegr\u00fcnden wird die Bilddatei in das TIF Format umgewandelt.</html>");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 25;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(9, 9, 9, 9);
        this.add((Component)this.lblTifConvert, gridBagConstraints);
    }

    private void butChooseActionPerformed(ActionEvent evt) {
        CursorTool tempCursor = this.context.getLayerViewPanel().getCurrentCursorTool();
        if (this.oldCursorTool == null) {
            this.oldCursorTool = tempCursor;
        }
        QuasimodeTool quasimodeTool = QuasimodeTool.addStandardQuasimodes(this.chooseEnvTool);
        this.context.getLayerViewPanel().setCurrentCursorTool(quasimodeTool);
        SwingUtilities.getWindowAncestor(this).setVisible(false);
        WorkbenchContext.getFrame().requestFocus();
    }

    @Override
    public void setEnvelope(Envelope modelEnv) throws Exception {
        this.env = modelEnv;
        this.lblTop.setText(this.df.format(modelEnv.getMaxY()));
        this.lblBottom.setText(this.df.format(modelEnv.getMinY()));
        this.lblLeft.setText(this.df.format(modelEnv.getMinX()));
        this.lblRight.setText(this.df.format(modelEnv.getMaxX()));
        CoordinateList lstCoord = new CoordinateList();
        Coordinate coord1 = new Coordinate(this.env.getMinX(), this.env.getMinY());
        lstCoord.add(coord1, false);
        Coordinate coord2 = new Coordinate(this.env.getMinX(), this.env.getMaxY());
        lstCoord.add(coord2, false);
        Coordinate coord3 = new Coordinate(this.env.getMaxX(), this.env.getMaxY());
        lstCoord.add(coord3, false);
        Coordinate coord4 = new Coordinate(this.env.getMaxX(), this.env.getMinY());
        lstCoord.add(coord4, false);
        Coordinate coord5 = new Coordinate(this.env.getMinX(), this.env.getMinY());
        lstCoord.add(coord5, false);
        CoordinateSequence seqCoord = this.gfac.getCoordinateSequenceFactory().create(lstCoord.toCoordinateArray());
        LineString gBorder = new LineString(seqCoord, this.gfac);
        GenericOverlayFeature fPreview = new GenericOverlayFeature((Geometry)gBorder, (Stroke)new BasicStroke(2.0f), Color.RED, (Stroke)new BasicStroke(), new Color(0, 0, 0, 0));
        GenericOverlayPlugin.addFeature(RECT_PREVIEW, fPreview);
        this.context.getLayerViewPanel().copyTo();
        this.fireInputChange();
        WorkbenchContext.getFrame().activateDefaultCT();
    }
}

