/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.plugin.raster.imp;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.workbench.model.RasterImageLayer;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.ui.InputChangedListener;
import com.vividsolutions.jump.workbench.ui.plugin.raster.imp.ImportRasterPlugIn;
import com.vividsolutions.jump.workbench.ui.plugin.raster.imp.RasterImageFormats;
import com.vividsolutions.jump.workbench.ui.wizard.WizardPanel;
import de.riwagis.util.file.FileSupport;
import de.riwagis.util.gui.components.WaitDialog;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.SwingUtilities;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;

public class WizChooseOverwriteGeoRef
extends JPanel
implements WizardPanel {
    private PlugInContext context = null;
    private Map<String, Object> dataMap = null;
    private final List<InputChangedListener> lstListeners = new ArrayList<InputChangedListener>();
    private ButtonGroup buttonGroup1;
    private JCheckBox chkConvertToTiff;
    private JLabel lblNotWriteable;
    private JRadioButton rdoOverwriteGeoref;
    private JRadioButton rdoUseGeoref;

    public WizChooseOverwriteGeoRef(PlugInContext _context) {
        this.context = _context;
        this.initComponents();
        this.lblNotWriteable.setVisible(false);
        this.i18n();
    }

    private void i18n() {
        this.rdoUseGeoref.setText(I18N.get("ui.plugin.raster.imp.WizChooseOverwriteGeoRef.keep"));
        this.rdoOverwriteGeoref.setText(I18N.get("ui.plugin.raster.imp.WizChooseOverwriteGeoRef.overwrite"));
        this.lblNotWriteable.setText(I18N.get("ui.plugin.raster.imp.WizChooseOverwriteGeoRef.not-writeable"));
        this.chkConvertToTiff.setText(I18N.get("ui.plugin.raster.imp.WizChooseOverwriteGeoRef.convert-to-tif"));
    }

    @Override
    public void enteredFromLeft(Map<String, Object> dataMap) {
        this.dataMap = dataMap;
        this.rdoUseGeoref.setSelected(true);
        this.updateControls();
    }

    @Override
    public void enteredFromRight(Map<String, Object> dataMap) {
    }

    @Override
    public void exitingToRight() throws Exception {
        final WaitDialog dlgWait = new WaitDialog(SwingUtilities.windowForComponent(this), I18N.get("common.wait"));
        dlgWait.setCancelable(false);
        Runnable workToDo = new Runnable(){

            @Override
            public void run() {
                try {
                    if (WizChooseOverwriteGeoRef.this.rdoUseGeoref.isSelected()) {
                        File rasterFile = (File)WizChooseOverwriteGeoRef.this.dataMap.get("orifile");
                        if (WizChooseOverwriteGeoRef.this.chkConvertToTiff.isSelected()) {
                            File tifFile = ImportRasterPlugIn.saveImageAsTiff(rasterFile);
                            File grefFileNew = RasterImageFormats.getGeoRefFile(tifFile);
                            File grefFileOri = RasterImageFormats.getGeoRefFile(rasterFile);
                            FileUtils.copyFile((File)grefFileOri, (File)grefFileNew);
                            rasterFile = tifFile;
                        }
                        RasterImageLayer rly = ImportRasterPlugIn.createWorldFileRasterImageLayer(rasterFile, WizChooseOverwriteGeoRef.this.context);
                        WizChooseOverwriteGeoRef.this.context.getLayerViewPanel().getViewport().zoom(rly.getEnvelope());
                    }
                }
                catch (Exception e) {
                    dlgWait.setError(e);
                }
            }
        };
        dlgWait.addWorkToDo(workToDo);
        dlgWait.setVisible(2000L);
        if (dlgWait.getError() != null) {
            if (ExceptionUtils.getRootCause((Throwable)dlgWait.getError()) instanceof OutOfMemoryError) {
                throw new Exception(I18N.getMessage("common.out-of-memory", ExceptionUtils.getRootCause((Throwable)dlgWait.getError()).getMessage()));
            }
            throw dlgWait.getError();
        }
    }

    @Override
    public void exitingToLeft() {
    }

    @Override
    public void cleanupAtCancel(Map<String, Object> dataMap) {
    }

    @Override
    public void add(InputChangedListener listener) {
        this.lstListeners.add(listener);
    }

    @Override
    public void remove(InputChangedListener listener) {
        if (this.lstListeners.contains(listener)) {
            this.lstListeners.remove(listener);
        }
    }

    private void fireInputChange() {
        for (InputChangedListener listener : this.lstListeners) {
            listener.inputChanged();
        }
    }

    @Override
    public String getTitle() {
        return I18N.get("ui.plugin.raster.imp.WizChooseOverwriteGeoRef.title");
    }

    @Override
    public String getID() {
        return "1";
    }

    @Override
    public String getInstructions() {
        return I18N.get("ui.plugin.raster.imp.WizChooseOverwriteGeoRef.instruction");
    }

    @Override
    public boolean isInputValid() {
        this.lblNotWriteable.setVisible(false);
        if (this.rdoUseGeoref.isSelected()) {
            return true;
        }
        File imgFile = (File)this.dataMap.get("orifile");
        if (FileSupport.canWrite((File)imgFile.getParentFile())) {
            return true;
        }
        this.lblNotWriteable.setVisible(true);
        return false;
    }

    @Override
    public String getNextID() {
        if (this.rdoUseGeoref.isSelected()) {
            return null;
        }
        return "2";
    }

    private void updateControls() {
        File rFile = (File)this.dataMap.get("orifile");
        RasterImageFormats fmt = RasterImageFormats.getFormat(rFile);
        if (fmt != null) {
            this.chkConvertToTiff.setVisible(fmt != RasterImageFormats.TIF);
            this.chkConvertToTiff.setEnabled(this.rdoUseGeoref.isSelected());
            if (fmt == RasterImageFormats.TIF) {
                this.chkConvertToTiff.setSelected(false);
            }
        } else {
            this.chkConvertToTiff.setVisible(false);
            this.chkConvertToTiff.setSelected(false);
        }
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.rdoUseGeoref = new JRadioButton();
        this.rdoOverwriteGeoref = new JRadioButton();
        this.lblNotWriteable = new JLabel();
        this.chkConvertToTiff = new JCheckBox();
        this.setLayout(new GridBagLayout());
        this.buttonGroup1.add(this.rdoUseGeoref);
        this.rdoUseGeoref.setText("<html>Bereits vorhandene Georeferenzierung \u00fcbernehmen. (empfohlen)</html>");
        this.rdoUseGeoref.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                WizChooseOverwriteGeoRef.this.rdoUseGeorefActionPerformed(evt);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 23;
        gridBagConstraints.insets = new Insets(9, 9, 3, 9);
        this.add((Component)this.rdoUseGeoref, gridBagConstraints);
        this.buttonGroup1.add(this.rdoOverwriteGeoref);
        this.rdoOverwriteGeoref.setText("<html>Georeferenzierung neu durchf\u00fchren.</html>");
        this.rdoOverwriteGeoref.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                WizChooseOverwriteGeoRef.this.rdoOverwriteGeorefActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 23;
        gridBagConstraints.insets = new Insets(9, 9, 9, 9);
        this.add((Component)this.rdoOverwriteGeoref, gridBagConstraints);
        this.lblNotWriteable.setFont(this.lblNotWriteable.getFont().deriveFont(this.lblNotWriteable.getFont().getStyle() | 1));
        this.lblNotWriteable.setForeground(new Color(255, 0, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 23;
        gridBagConstraints.insets = new Insets(10, 10, 10, 10);
        this.add((Component)this.lblNotWriteable, gridBagConstraints);
        this.chkConvertToTiff.setSelected(true);
        this.chkConvertToTiff.setText("In TIF Format konvertieren (empfohlen)");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 23;
        gridBagConstraints.insets = new Insets(0, 27, 6, 0);
        this.add((Component)this.chkConvertToTiff, gridBagConstraints);
    }

    private void rdoUseGeorefActionPerformed(ActionEvent evt) {
        this.updateControls();
        this.fireInputChange();
    }

    private void rdoOverwriteGeorefActionPerformed(ActionEvent evt) {
        this.updateControls();
        this.fireInputChange();
    }
}

