/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.plugin.raster.imp;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.ui.InputChangedListener;
import com.vividsolutions.jump.workbench.ui.plugin.PersistentBlackboardPlugIn;
import com.vividsolutions.jump.workbench.ui.plugin.raster.imp.ImportRasterPlugIn;
import com.vividsolutions.jump.workbench.ui.plugin.raster.imp.RasterImageFormats;
import com.vividsolutions.jump.workbench.ui.wizard.WizardContext;
import com.vividsolutions.jump.workbench.ui.wizard.WizardPanel;
import de.riwagis.util.gui.GUISupport;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.filechooser.FileFilter;
import org.apache.commons.io.FilenameUtils;
import org.geotools.gce.image.WorldImageFormat;

public class WizChooseFilePanel
extends JPanel
implements WizardPanel {
    public static final String PARAM_ORIFILE = "orifile";
    private final PlugInContext context;
    private final WizardContext wizContext;
    private Map<String, Object> dataMap = null;
    private File fileSelected = null;
    private final List<InputChangedListener> lstListeners = new ArrayList<InputChangedListener>();
    private JFileChooser fChooser;

    public WizChooseFilePanel(PlugInContext _context, WizardContext _wizContext) {
        this.context = _context;
        this.wizContext = _wizContext;
        this.initComponents();
        this.i18n();
        this.fChooser.setFileSelectionMode(0);
        this.fChooser.setFileFilter(new FileFilter(this){

            @Override
            public boolean accept(File f) {
                if (f.isDirectory()) {
                    return true;
                }
                return RasterImageFormats.isFormatSupported(f);
            }

            @Override
            public String getDescription() {
                return "Images (" + RasterImageFormats.getFormatString() + ")";
            }
        });
        this.fChooser.setAcceptAllFileFilterUsed(false);
        this.fChooser.setControlButtonsAreShown(false);
    }

    private void i18n() {
    }

    @Override
    public void enteredFromLeft(Map<String, Object> dataMap) {
        this.dataMap = dataMap;
        this.fileSelected = new File(PersistentBlackboardPlugIn.get().get(ImportRasterPlugIn.KEY_DIR, ""));
        if (this.fileSelected != null) {
            this.fChooser.setSelectedFile(this.fileSelected);
        }
    }

    @Override
    public void exitingToLeft() {
    }

    @Override
    public void cleanupAtCancel(Map<String, Object> dataMap) {
    }

    @Override
    public void exitingToRight() throws Exception {
        this.dataMap.put(PARAM_ORIFILE, this.fileSelected);
        PersistentBlackboardPlugIn.get().put(ImportRasterPlugIn.KEY_DIR, this.fileSelected.toString());
    }

    @Override
    public void enteredFromRight(Map<String, Object> dataMap) {
    }

    @Override
    public void add(InputChangedListener listener) {
        this.lstListeners.add(listener);
    }

    @Override
    public void remove(InputChangedListener listener) {
        if (this.lstListeners.contains(listener)) {
            this.lstListeners.remove(listener);
        }
    }

    private void fireInputChange() {
        for (InputChangedListener listener : this.lstListeners) {
            listener.inputChanged();
        }
    }

    @Override
    public String getTitle() {
        return I18N.get("ui.plugin.raster.imp.WizChooseFilePanel.title");
    }

    @Override
    public String getID() {
        return "0";
    }

    @Override
    public String getInstructions() {
        return "";
    }

    @Override
    public boolean isInputValid() {
        boolean valid;
        boolean bl = valid = this.fileSelected != null && this.fileSelected.exists();
        if (valid && !RasterImageFormats.isFormatSupported(this.fileSelected)) {
            GUISupport.msgbox((Component)this, (String)I18N.get("ui.plugin.raster.imp.WizChooseFilePanel.unsupported-file-type"), (String)I18N.get("common.message"));
            valid = false;
        }
        return valid;
    }

    @Override
    public String getNextID() {
        if (this.fileSelected == null) {
            return "1";
        }
        if (!"".equals(this.fileSelected.getPath())) {
            String extension = FilenameUtils.getExtension((String)this.fileSelected.getAbsolutePath());
            Set worldExt = WorldImageFormat.getWorldExtension((String)extension);
            for (String ext : worldExt) {
                String worldFilename = FilenameUtils.getBaseName((String)this.fileSelected.getName()) + ext;
                File gfile = new File(FilenameUtils.getFullPath((String)this.fileSelected.getAbsolutePath()), worldFilename);
                if (!gfile.exists()) continue;
                return "1";
            }
        }
        return "2";
    }

    private void initComponents() {
        this.fChooser = new JFileChooser();
        this.setLayout(new BorderLayout());
        this.fChooser.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                WizChooseFilePanel.this.fChooserActionPerformed(evt);
            }
        });
        this.fChooser.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                WizChooseFilePanel.this.fChooserPropertyChange(evt);
            }
        });
        this.add((Component)this.fChooser, "Center");
    }

    private void fChooserPropertyChange(PropertyChangeEvent evt) {
        this.fileSelected = this.fChooser.getSelectedFile();
        this.fireInputChange();
    }

    private void fChooserActionPerformed(ActionEvent evt) {
        this.fileSelected = this.fChooser.getSelectedFile();
        this.fireInputChange();
        this.wizContext.moveNext();
    }
}

