/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.plugin.raster.imp;

import java.io.File;
import java.util.Collections;
import java.util.List;
import org.apache.commons.io.FilenameUtils;

public enum RasterImageFormats {
    JPG("jpg", "jgw"),
    TIF(List.of("tif", "tiff"), "tfw"),
    PNG("png", "pgw"),
    GIF("gif", "gfw");

    private final List<String> suffixes;
    private final String georefSuffix;

    private RasterImageFormats(List<String> suffixes, String georefSuffix) {
        this.suffixes = suffixes;
        this.georefSuffix = georefSuffix;
    }

    private RasterImageFormats(String suffix, String georefSuffix) {
        this(Collections.singletonList(suffix), georefSuffix);
    }

    public List<String> getSuffixes() {
        return this.suffixes;
    }

    public String getGeoRefSuffix() {
        return this.georefSuffix;
    }

    public static boolean isFormatSupported(File file) {
        return RasterImageFormats.getFormat(file) != null;
    }

    public static RasterImageFormats getFormat(File file) {
        if (file != null) {
            for (RasterImageFormats format : RasterImageFormats.values()) {
                for (String suffix : format.getSuffixes()) {
                    if (!file.getName().toLowerCase().endsWith(suffix)) continue;
                    return format;
                }
            }
        }
        return null;
    }

    public static File getGeoRefFile(File file) {
        RasterImageFormats format = RasterImageFormats.getFormat(file);
        if (format == null) {
            throw new IllegalArgumentException(String.valueOf(file) + " is no suppored image format.");
        }
        return new File(file.getParentFile(), FilenameUtils.getBaseName((String)file.getName()) + "." + format.georefSuffix);
    }

    public static boolean hasGeoRefFile(File file) {
        File gfile = RasterImageFormats.getGeoRefFile(file);
        return gfile.exists();
    }

    public static String getFormatString() {
        Object strFormat = "";
        for (RasterImageFormats format : RasterImageFormats.values()) {
            for (String suffix : format.getSuffixes()) {
                if (((String)strFormat).length() > 0) {
                    strFormat = (String)strFormat + ",";
                }
                strFormat = (String)strFormat + "*." + suffix;
            }
        }
        return strFormat;
    }
}

