/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.plugin.raster.imp;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.workbench.model.Layerable;
import com.vividsolutions.jump.workbench.model.RasterImageLayer;
import com.vividsolutions.jump.workbench.plugin.AbstractPlugIn;
import com.vividsolutions.jump.workbench.plugin.EnableCheck;
import com.vividsolutions.jump.workbench.plugin.EnableCheckFactory;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.ui.plugin.raster.imp.RasterImageFormats;
import com.vividsolutions.jump.workbench.ui.plugin.raster.imp.WizChooseFilePanel;
import com.vividsolutions.jump.workbench.ui.plugin.raster.imp.WizChooseOverwriteGeoRef;
import com.vividsolutions.jump.workbench.ui.plugin.raster.imp.WizChooseRectanglePanel;
import com.vividsolutions.jump.workbench.ui.plugin.raster.imp.WizGeoRefPanel;
import com.vividsolutions.jump.workbench.ui.wizard.WizardDialog;
import com.vividsolutions.jump.workbench.ui.wizard.WizardPanel;
import de.riwagis.riwajump.data.model.datalocation.raster.ImageWithWorldFileDataLocation;
import de.riwagis.util.gui.GUISupport;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Iterator;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.stream.ImageInputStream;
import javax.imageio.stream.ImageOutputStream;
import javax.swing.SwingUtilities;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.locationtech.jts.geom.Envelope;

public class ImportRasterPlugIn
extends AbstractPlugIn {
    public static final String KEY_DIR = ImportRasterPlugIn.class.getName() + "_KEY_DIR";

    @Override
    public void initialize(PlugInContext context) {
    }

    @Override
    public boolean execute(PlugInContext context) {
        SwingUtilities.invokeLater(() -> {
            WizardDialog wiz = new WizardDialog((Frame)context.getWorkbenchFrame(), this.getName(), context.getWorkbenchFrame(), false);
            WizChooseFilePanel wizFile = new WizChooseFilePanel(context, wiz);
            WizChooseOverwriteGeoRef wizChooseOverw = new WizChooseOverwriteGeoRef(context);
            WizChooseRectanglePanel wizChooseRect = new WizChooseRectanglePanel(context);
            WizGeoRefPanel wizGeoRef = new WizGeoRefPanel(context);
            wiz.init(new WizardPanel[]{wizFile, wizChooseOverw, wizChooseRect, wizGeoRef});
            wiz.setSize(600, 500);
            GUISupport.centreOnScreen((Component)wiz);
            wiz.addWindowListener(new WizWindowListener(wiz));
            wiz.setVisible(true);
        });
        return true;
    }

    @Override
    public String getName() {
        return I18N.get("ui.plugin.raster.imp.ImportRasterPlugIn.name");
    }

    @Override
    public EnableCheck createEnableCheck() {
        return EnableCheckFactory.getInstance().createTaskWindowMustBeActiveCheck();
    }

    public static Dimension getImageDimension(File imageFile) throws IOException {
        try (ImageInputStream in = ImageIO.createImageInputStream(imageFile);){
            Iterator<ImageReader> readers = ImageIO.getImageReaders(in);
            if (readers.hasNext()) {
                ImageReader reader = readers.next();
                reader.setInput(in);
                Dimension dimension = new Dimension(reader.getWidth(0), reader.getHeight(0));
                reader.dispose();
                Dimension dimension2 = dimension;
                return dimension2;
            }
            throw new IOException("No Image Reader found for " + String.valueOf(imageFile));
        }
    }

    public static File saveImageAsTiff(File imageFile) throws IOException {
        File tifImageFile;
        block14: {
            RasterImageFormats fmt = RasterImageFormats.getFormat(imageFile);
            if (fmt == null) {
                throw new IOException("Invalid image format of file: " + String.valueOf(imageFile));
            }
            if (fmt == RasterImageFormats.TIF) {
                return imageFile;
            }
            tifImageFile = ImportRasterPlugIn.getNewTifFile(imageFile.getParentFile(), FilenameUtils.getBaseName((String)imageFile.getName()), 0);
            try (FileInputStream fi = new FileInputStream(imageFile);){
                BufferedImage bufferedImage = ImageIO.read(fi);
                try (ImageOutputStream ios = ImageIO.createImageOutputStream(tifImageFile);){
                    Iterator<ImageWriter> writers = ImageIO.getImageWriters(ImageTypeSpecifier.createFromBufferedImageType(bufferedImage.getType()), "TIFF");
                    ImageWriter writer = writers.next();
                    if (writer != null) {
                        writer.setOutput(ios);
                        ImageWriteParam params = writer.getDefaultWriteParam();
                        params.setTilingMode(2);
                        params.setTiling(512, 512, 0, 0);
                        params.setCompressionMode(2);
                        params.setCompressionType("Deflate");
                        params.setCompressionQuality(1.0f);
                        writer.write(null, new IIOImage(bufferedImage, null, null), params);
                        writer.dispose();
                        break block14;
                    }
                    throw new IOException("No matching TIFF encoder found.");
                }
            }
        }
        return tifImageFile;
    }

    private static File getNewTifFile(File folder, String oriname, int idx) {
        File newFile;
        Object name = oriname;
        if (idx > 0) {
            name = (String)name + "_" + idx;
        }
        if ((newFile = new File(folder, (String)name + ".tif")).exists()) {
            return ImportRasterPlugIn.getNewTifFile(folder, oriname, ++idx);
        }
        return newFile;
    }

    public static RasterImageLayer createWorldFileRasterImageLayer(File rasterFile, PlugInContext context) {
        String strLyName = FilenameUtils.getBaseName((String)rasterFile.getName());
        ImageWithWorldFileDataLocation dloc = new ImageWithWorldFileDataLocation();
        dloc.setParameter("Image-File", rasterFile.getAbsolutePath());
        RasterImageLayer rly = new RasterImageLayer(strLyName, context.getLayerManager(), dloc);
        context.getLayerManager().addLayerable(I18N.get("ui.plugin.raster.AddRasterLayerPlugIn.layer-group-name"), (Layerable)rly);
        return rly;
    }

    public static double[] getGeoRefParameters4Envelope(Dimension imageDim, Envelope env) {
        double[] arrGeoRef = new double[6];
        double pxWidthModel = env.getWidth() / (double)imageDim.width;
        double pxHeightModel = env.getHeight() / (double)imageDim.height;
        arrGeoRef[0] = pxWidthModel = Math.min(pxWidthModel, pxHeightModel);
        arrGeoRef[1] = 0.0;
        arrGeoRef[2] = 0.0;
        arrGeoRef[3] = -pxWidthModel;
        arrGeoRef[4] = env.getMinX();
        arrGeoRef[5] = env.getMaxY();
        return arrGeoRef;
    }

    public static File writeGeoRefParameters2File(File georefFile, double[] arrParam, boolean createBakFile) throws IOException {
        File bakFile = null;
        if (georefFile.exists() && createBakFile) {
            bakFile = ImportRasterPlugIn.getBackupFile(georefFile, 0);
            georefFile.renameTo(bakFile);
        }
        if (arrParam.length != 6) {
            throw new IllegalArgumentException("Should never reach here. Parameter array has to be of length 6.");
        }
        ArrayList<CallSite> lstLines = new ArrayList<CallSite>();
        for (double param : arrParam) {
            lstLines.add((CallSite)((Object)("" + param)));
        }
        FileUtils.writeLines((File)georefFile, lstLines);
        return bakFile;
    }

    private static File getBackupFile(File file, int number) {
        String strBaseName = FilenameUtils.getBaseName((String)file.getName());
        File dir = file.getParentFile();
        File bakFile = number > 0 ? new File(dir, strBaseName + ".bak" + number) : new File(dir, strBaseName + ".bak");
        if (bakFile.exists()) {
            return ImportRasterPlugIn.getBackupFile(file, ++number);
        }
        return bakFile;
    }

    private static class WizWindowListener
    extends WindowAdapter {
        private final WizardDialog wiz;

        private WizWindowListener(WizardDialog wiz) {
            this.wiz = wiz;
        }

        @Override
        public void windowClosed(WindowEvent e) {
            if (this.wiz.wasFinishPressed()) {
                // empty if block
            }
        }
    }
}

