/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.plugin.raster.imp;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.ui.InputChangedListener;
import com.vividsolutions.jump.workbench.ui.LayerViewPanel;
import com.vividsolutions.jump.workbench.ui.cursortool.CursorTool;
import com.vividsolutions.jump.workbench.ui.cursortool.QuasimodeTool;
import com.vividsolutions.jump.workbench.ui.plugin.raster.imp.ControlPoint;
import com.vividsolutions.jump.workbench.ui.plugin.raster.imp.ControlPointTool;
import com.vividsolutions.jump.workbench.ui.plugin.raster.imp.GeoRefComputer;
import com.vividsolutions.jump.workbench.ui.plugin.raster.imp.ImportRasterPlugIn;
import com.vividsolutions.jump.workbench.ui.plugin.raster.imp.RasterImageFormats;
import de.riwagis.icons.IconLoader;
import de.riwagis.riwajump.workbench.renderer.GenericOverlayFeature;
import de.riwagis.riwajump.workbench.renderer.GenericOverlayPlugin;
import de.riwagis.util.gui.ExceptionDialog;
import de.riwagis.util.gui.GUISupport;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.Stroke;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.DefaultTableModel;
import org.apache.commons.io.FileUtils;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateSequence;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;

public class GeoRefPanel
extends JPanel
implements ControlPointTool.ControlPointConsumer {
    private static final int ACTION_INSERT = 0;
    private static final int ACTION_UPDATE = 1;
    private static final int ACTION_DELETE = 2;
    private static final String CONTROL_POINT_PREVIEW = "CONTROL_POINT_PREVIEW";
    private final List lstListeners = new ArrayList();
    private final GeometryFactory gfac = new GeometryFactory();
    private CursorTool oldCursorTool = null;
    private final ControlPointTool controlPointTool = new ControlPointTool(this);
    private int controlPointToolAction = 0;
    private ControlPoint controlPointToolPoint = null;
    private final DecimalFormat df = new DecimalFormat("0.0####");
    private File imageFile = null;
    private JButton butDelete;
    private JButton butInsert;
    private JButton butUpdate;
    private JCheckBox cboUseRotation;
    private JButton jButton1;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JTable jTable1;
    private JLabel lblAccuracy;
    private Label lblInstructions;
    private JTable tblRefPoints;

    public GeoRefPanel() {
        this.initComponents();
        this.i18n();
        this.lblAccuracy.setVisible(false);
        this.lblAccuracy.setText("");
        this.df.setGroupingUsed(false);
    }

    public void setImageFile(File imageFile) throws IOException {
        this.imageFile = imageFile;
    }

    private void i18n() {
        this.lblInstructions.setText(I18N.get("ui.plugin.raster.imp.GeoRefPanel.instruction"));
        this.butInsert.setToolTipText(I18N.get("ui.plugin.raster.imp.GeoRefPanel.tooltip-insert"));
        this.butUpdate.setToolTipText(I18N.get("ui.plugin.raster.imp.GeoRefPanel.tooltip-update"));
        this.butDelete.setToolTipText(I18N.get("ui.plugin.raster.imp.GeoRefPanel.tooltip-delete"));
        this.cboUseRotation.setText(I18N.get("ui.plugin.raster.imp.GeoRefPanel.rotate"));
    }

    public void enableOldCursorTool() {
        if (this.oldCursorTool != null) {
            this.getLayerViewPanel().setCurrentCursorTool(this.oldCursorTool);
            this.oldCursorTool = null;
        }
    }

    private LayerViewPanel getLayerViewPanel() {
        return WorkbenchContext.getInstance().getLayerViewPanel();
    }

    @Override
    public void consumeControlPoint(ControlPoint cp) {
        List<ControlPoint> lstCP;
        if (this.controlPointToolAction == 0) {
            ((DefaultTableModel)this.tblRefPoints.getModel()).addRow(new Object[]{new Integer(this.tblRefPoints.getRowCount() + 1), cp});
        }
        if (this.controlPointToolAction == 1 && this.controlPointToolPoint != null) {
            lstCP = this.getControlPoints();
            for (int i = 0; i < lstCP.size(); ++i) {
                if (lstCP.get(i) != this.controlPointToolPoint) continue;
                this.tblRefPoints.getModel().setValueAt(cp, i, 1);
            }
        }
        if (this.controlPointToolAction == 2) {
            lstCP = this.getControlPoints();
            int count = 1;
            int delIdx = -1;
            for (int i = 0; i < lstCP.size(); ++i) {
                if (lstCP.get(i) == cp) {
                    delIdx = i;
                    continue;
                }
                this.tblRefPoints.getModel().setValueAt(new Integer(count), i, 0);
                ++count;
            }
            ((DefaultTableModel)this.tblRefPoints.getModel()).removeRow(delIdx);
        }
        this.drawControlPointPreview();
        this.fireInputChange();
        WorkbenchContext.getFrame().activateDefaultCT();
    }

    public void activateControlPointTool(int action) {
        this.controlPointToolAction = action;
        CursorTool tempCursor = WorkbenchContext.getInstance().getLayerViewPanel().getCurrentCursorTool();
        if (this.oldCursorTool == null) {
            this.oldCursorTool = tempCursor;
        }
        QuasimodeTool quasimodeTool = QuasimodeTool.addStandardQuasimodes(this.controlPointTool);
        WorkbenchContext.getInstance().getLayerViewPanel().setCurrentCursorTool(quasimodeTool);
        WorkbenchContext.getFrame().requestFocus();
        SwingUtilities.windowForComponent(this).setVisible(false);
    }

    public List<ControlPoint> getControlPoints() {
        ArrayList<ControlPoint> lstCP = new ArrayList<ControlPoint>();
        for (int i = 0; i < this.tblRefPoints.getRowCount(); ++i) {
            ControlPoint cp = (ControlPoint)this.tblRefPoints.getModel().getValueAt(i, 1);
            lstCP.add(cp);
        }
        return lstCP;
    }

    private void drawControlPointPreview() {
        try {
            ArrayList<Geometry> lstGeom = new ArrayList<Geometry>();
            List<ControlPoint> lstCP = this.getControlPoints();
            for (ControlPoint cp : lstCP) {
                CoordinateSequence seqCoord = this.gfac.getCoordinateSequenceFactory().create(new Coordinate[]{cp.getFrom(), cp.getTo()});
                LineString gLine = new LineString(seqCoord, this.gfac);
                lstGeom.add((Geometry)gLine);
            }
            if (lstCP.size() > 2) {
                File geoRefFile = RasterImageFormats.getGeoRefFile(this.imageFile);
                GeoRefComputer comp = this.getComputer(geoRefFile);
                String strUnit = WorkbenchContext.getInstance().getLayerManager().getTask().getDrawingUnit().getUnitAbbreviation();
                double posAcc = Math.sqrt((comp.getTransXVarianz() + comp.getTransYVarianz()) / 2.0);
                this.lblAccuracy.setText(I18N.getMessage("ui.plugin.raster.imp.GeoRefPanel.accuracy", this.df.format(posAcc), strUnit));
                this.lblAccuracy.setVisible(true);
            } else {
                this.lblAccuracy.setVisible(false);
                this.lblAccuracy.setText("");
            }
            GenericOverlayFeature fPreview = new GenericOverlayFeature(lstGeom, (Stroke)new BasicStroke(2.0f), Color.RED, (Stroke)new BasicStroke(), new Color(0, 0, 0, 0));
            GenericOverlayPlugin.addFeature(CONTROL_POINT_PREVIEW, fPreview);
            this.getLayerViewPanel().copyTo();
        }
        catch (Exception e) {
            ExceptionDialog.handleGuiException((Component)this, (Exception)e, GeoRefPanel.class);
        }
    }

    public void removeControlPointPreview() {
        GenericOverlayPlugin.removeFeature(CONTROL_POINT_PREVIEW);
        this.getLayerViewPanel().copyTo();
    }

    public void add(InputChangedListener listener) {
        this.lstListeners.add(listener);
    }

    public void remove(InputChangedListener listener) {
        if (this.lstListeners.contains(listener)) {
            this.lstListeners.remove(listener);
        }
    }

    private void fireInputChange() {
        for (InputChangedListener listener : this.lstListeners) {
            listener.inputChanged();
        }
    }

    private GeoRefComputer getComputer(File geoRefFile) throws IOException {
        if (!geoRefFile.exists()) {
            throw new IllegalArgumentException("The following world file does not exist: " + geoRefFile.toString());
        }
        List lstLines = FileUtils.readLines((File)geoRefFile);
        if (lstLines.size() < 6) {
            throw new IllegalArgumentException("Invalid format found in world file: " + geoRefFile.toString());
        }
        double pixelWidthX = Double.parseDouble((String)lstLines.get(0));
        double pixelWidthY = Double.parseDouble((String)lstLines.get(3));
        Coordinate imageInsertionPoint = new Coordinate(Double.parseDouble((String)lstLines.get(4)), Double.parseDouble((String)lstLines.get(5)));
        GeoRefComputer comp = new GeoRefComputer(imageInsertionPoint, pixelWidthX, pixelWidthY, this.getControlPoints());
        comp.setRotate(this.cboUseRotation.isSelected());
        return comp;
    }

    public void writeNewWorldFile() throws IOException {
        File geoRefFile = RasterImageFormats.getGeoRefFile(this.imageFile);
        GeoRefComputer comp = this.getComputer(geoRefFile);
        double[] arrParam = comp.getGeoRefParameters();
        ImportRasterPlugIn.writeGeoRefParameters2File(geoRefFile, arrParam, false);
    }

    @Override
    public void deactivate() {
        SwingUtilities.windowForComponent(this).setVisible(true);
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.jTable1 = new JTable();
        this.jButton1 = new JButton();
        this.jPanel1 = new JPanel();
        this.jScrollPane2 = new JScrollPane();
        this.tblRefPoints = new JTable();
        this.jPanel2 = new JPanel();
        this.butInsert = new JButton();
        this.butUpdate = new JButton();
        this.butDelete = new JButton();
        this.lblInstructions = new Label();
        this.cboUseRotation = new JCheckBox();
        this.lblAccuracy = new JLabel();
        this.jTable1.setModel(new DefaultTableModel(new Object[][]{{null, null, null, null}, {null, null, null, null}, {null, null, null, null}, {null, null, null, null}}, new String[]{"Title 1", "Title 2", "Title 3", "Title 4"}));
        this.jScrollPane1.setViewportView(this.jTable1);
        this.jButton1.setText("jButton1");
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 100, Short.MAX_VALUE));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 100, Short.MAX_VALUE));
        this.setLayout(new GridBagLayout());
        this.tblRefPoints.setModel(new DefaultTableModel(new Object[0][], new String[]{"Nummer", "Passpunkt"}){
            boolean[] canEdit;
            {
                this.canEdit = new boolean[]{true, false};
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return this.canEdit[columnIndex];
            }
        });
        this.jScrollPane2.setViewportView(this.tblRefPoints);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipadx = 351;
        gridBagConstraints.ipady = 221;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(10, 10, 10, 10);
        this.add((Component)this.jScrollPane2, gridBagConstraints);
        this.butInsert.setIcon(IconLoader.svgIcon((String)"common_add.svg"));
        this.butInsert.setMargin(new Insets(2, 2, 2, 2));
        this.butInsert.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GeoRefPanel.this.butInsertActionPerformed(evt);
            }
        });
        this.jPanel2.add(this.butInsert);
        this.butUpdate.setIcon(IconLoader.svgIcon((String)"common_edit.svg"));
        this.butUpdate.setMargin(new Insets(2, 2, 2, 2));
        this.butUpdate.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GeoRefPanel.this.butUpdateActionPerformed(evt);
            }
        });
        this.jPanel2.add(this.butUpdate);
        this.butDelete.setIcon(IconLoader.svgIcon((String)"common_delete.svg"));
        this.butDelete.setMargin(new Insets(2, 2, 2, 2));
        this.butDelete.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GeoRefPanel.this.butDeleteActionPerformed(evt);
            }
        });
        this.jPanel2.add(this.butDelete);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 10, 5, 10);
        this.add((Component)this.jPanel2, gridBagConstraints);
        this.lblInstructions.setText("W\u00e4hlen Sie mindestens zwei Punkte an diagonal gegen\u00fcber liegenden Ecken des Bildes.");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 23;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 10, 3, 3);
        this.add((Component)this.lblInstructions, gridBagConstraints);
        this.cboUseRotation.setSelected(true);
        this.cboUseRotation.setText("Bild drehen (Achtung, Bilddatei wird \u00fcberschrieben. Orginalbild sichern.)");
        this.cboUseRotation.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GeoRefPanel.this.cboUseRotationActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.cboUseRotation, gridBagConstraints);
        this.lblAccuracy.setText("Eine Passpunktgenauigkeit kann ab 3 Passpunkten angezeigt werden.");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 23;
        gridBagConstraints.insets = new Insets(10, 10, 10, 10);
        this.add((Component)this.lblAccuracy, gridBagConstraints);
    }

    private void butInsertActionPerformed(ActionEvent evt) {
        this.activateControlPointTool(0);
    }

    private void butUpdateActionPerformed(ActionEvent evt) {
        int intRowSelected = this.tblRefPoints.getSelectedRow();
        if (intRowSelected == -1) {
            GUISupport.msgbox((Component)this, (String)I18N.get("ui.plugin.raster.imp.GeoRefPanel.select-table-row"), (String)I18N.get("common.message"));
            return;
        }
        this.controlPointToolPoint = (ControlPoint)this.tblRefPoints.getModel().getValueAt(intRowSelected, 1);
        this.activateControlPointTool(1);
    }

    private void butDeleteActionPerformed(ActionEvent evt) {
        int intRowSelected = this.tblRefPoints.getSelectedRow();
        if (intRowSelected == -1) {
            GUISupport.msgbox((Component)this, (String)I18N.get("ui.plugin.raster.imp.GeoRefPanel.select-table-row"), (String)I18N.get("common.message"));
            return;
        }
        this.controlPointToolAction = 2;
        this.enableOldCursorTool();
        this.consumeControlPoint((ControlPoint)this.tblRefPoints.getModel().getValueAt(intRowSelected, 1));
    }

    private void cboUseRotationActionPerformed(ActionEvent evt) {
        this.drawControlPointPreview();
    }
}

