/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.plugin.raster.imp;

import com.vividsolutions.jump.workbench.ui.plugin.raster.imp.ControlPoint;
import de.riwagis.util.construction.ConstSupport;
import java.awt.Color;
import java.awt.color.ColorSpace;
import java.awt.image.ColorModel;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.ParameterBlock;
import java.util.ArrayList;
import java.util.List;
import javax.media.jai.InterpolationBilinear;
import javax.media.jai.JAI;
import javax.media.jai.PlanarImage;
import javax.media.jai.ROI;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.util.AffineTransformation;

public class GeoRefComputer {
    private final Coordinate imageInsertionPoint;
    private final double pixelSizeX;
    private final double pixelSizeY;
    private final List<ControlPoint> lstCP;
    private Coordinate calcImageInsertionPoint = null;
    private final List<Coordinate> lstCoordSource = new ArrayList<Coordinate>();
    private final List<Coordinate> lstCoordDest = new ArrayList<Coordinate>();
    private final List<Line> lstNetSource = new ArrayList<Line>();
    private final List<Line> lstNetDest = new ArrayList<Line>();
    private double scale = -1.0;
    private double scaleVarianz = -1.0;
    private double transX = -1.0;
    private double transXVarianz = -1.0;
    private double transY = -1.0;
    private double transYVarianz = -1.0;
    private double rotation = -1.0;
    private double rotationVarianz = -1.0;
    private boolean rotate = false;
    private boolean ready = false;

    public GeoRefComputer(Coordinate imageInsertionPoint, double pixelSizeX, double pixelSizeY, List<ControlPoint> lstCP) {
        this.imageInsertionPoint = imageInsertionPoint;
        this.pixelSizeX = pixelSizeX;
        this.pixelSizeY = pixelSizeY;
        this.lstCP = lstCP;
        if (lstCP.size() < 2) {
            throw new IllegalArgumentException("At least two control points are needed for computation.");
        }
    }

    private void fillLists() {
        this.calcImageInsertionPoint = this.imageInsertionPoint;
        for (ControlPoint cp : this.lstCP) {
            this.lstCoordSource.add(cp.getFrom());
            this.lstCoordDest.add(cp.getTo());
        }
        this.fillNet(this.lstCoordSource, this.lstNetSource);
        this.fillNet(this.lstCoordDest, this.lstNetDest);
    }

    private void fillNet(List<Coordinate> lstCoord, List<Line> lstNet2Fill) {
        for (int i = 0; i < lstCoord.size(); ++i) {
            Coordinate coordStart = lstCoord.get(i);
            for (int j = i + 1; j < lstCoord.size(); ++j) {
                lstNet2Fill.add(new Line(this, coordStart, lstCoord.get(j)));
            }
        }
    }

    private void compute() {
        if (!this.ready) {
            this.fillLists();
            if (this.rotate) {
                this.computeRotation();
            }
            this.computeScale();
            this.computeTransX();
            this.computeTransY();
            this.ready = true;
        }
    }

    private void computeRotation() {
        double sumWeight = 0.0;
        ArrayList<Double> lstRot = new ArrayList<Double>();
        ArrayList<Double> lstWeight = new ArrayList<Double>();
        for (int i = 0; i < this.lstNetSource.size(); ++i) {
            double oriSource = this.lstNetSource.get(i).getOriInRad();
            double oriDest = this.lstNetDest.get(i).getOriInRad();
            double lineRotation = oriSource - oriDest;
            double lineWeight = this.lstNetSource.get(i).getLength() + this.lstNetDest.get(i).getLength();
            lstRot.add(lineRotation);
            lstWeight.add(lineWeight);
            sumWeight += lineWeight;
        }
        double sumRot = 0.0;
        for (int i = 0; i < lstRot.size(); ++i) {
            sumRot += (Double)lstRot.get(i) * (Double)lstWeight.get(i);
        }
        this.rotation = sumRot / sumWeight;
        double sumRotVarianz = 0.0;
        for (int i = 0; i < lstRot.size(); ++i) {
            sumRotVarianz += (this.rotation - (Double)lstRot.get(i)) * (this.rotation - (Double)lstRot.get(i)) * (Double)lstWeight.get(i);
        }
        this.rotationVarianz = sumRotVarianz / sumWeight;
        AffineTransformation trans = AffineTransformation.rotationInstance((double)(-this.rotation), (double)this.calcImageInsertionPoint.x, (double)this.calcImageInsertionPoint.y);
        for (int i = 0; i < this.lstCoordSource.size(); ++i) {
            Coordinate transCoord = new Coordinate();
            trans.transform(this.lstCoordSource.get(i), transCoord);
            this.lstCoordSource.set(i, transCoord);
        }
    }

    private void computeScale() {
        double sumWeight = 0.0;
        ArrayList<Double> lstScale = new ArrayList<Double>();
        ArrayList<Double> lstWeight = new ArrayList<Double>();
        for (int i = 0; i < this.lstNetSource.size(); ++i) {
            double lengthSource = this.lstNetSource.get(i).getLength();
            double lengthDest = this.lstNetDest.get(i).getLength();
            double lineScale = lengthDest / lengthSource;
            double lineWeight = lengthSource + lengthDest;
            lstScale.add(lineScale);
            lstWeight.add(lineWeight);
            sumWeight += lineWeight;
        }
        double sumScale = 0.0;
        for (int i = 0; i < lstScale.size(); ++i) {
            sumScale += (Double)lstScale.get(i) * (Double)lstWeight.get(i);
        }
        this.scale = sumScale / sumWeight;
        double sumScaleVarianz = 0.0;
        for (int i = 0; i < lstScale.size(); ++i) {
            sumScaleVarianz += (this.scale - (Double)lstScale.get(i)) * (this.scale - (Double)lstScale.get(i)) * (Double)lstWeight.get(i);
        }
        this.scaleVarianz = sumScaleVarianz / sumWeight;
        AffineTransformation trans = AffineTransformation.translationInstance((double)(-this.calcImageInsertionPoint.x), (double)(-this.calcImageInsertionPoint.y));
        trans.scale(this.scale, this.scale);
        trans.translate(this.calcImageInsertionPoint.x, this.calcImageInsertionPoint.y);
        for (int i = 0; i < this.lstCoordSource.size(); ++i) {
            Coordinate transCoord = new Coordinate();
            trans.transform(this.lstCoordSource.get(i), transCoord);
            this.lstCoordSource.set(i, transCoord);
        }
    }

    private void computeTransX() {
        ArrayList<Double> lstTransX = new ArrayList<Double>();
        for (int i = 0; i < this.lstCoordSource.size(); ++i) {
            double dx = this.lstCoordDest.get((int)i).x - this.lstCoordSource.get((int)i).x;
            lstTransX.add(dx);
        }
        double sumTransX = 0.0;
        for (int i = 0; i < lstTransX.size(); ++i) {
            sumTransX += ((Double)lstTransX.get(i)).doubleValue();
        }
        this.transX = sumTransX / (double)lstTransX.size();
        double sumTransXVarianz = 0.0;
        for (int i = 0; i < lstTransX.size(); ++i) {
            sumTransXVarianz += (this.transX - (Double)lstTransX.get(i)) * (this.transX - (Double)lstTransX.get(i));
        }
        this.transXVarianz = sumTransXVarianz / (double)lstTransX.size();
    }

    private void computeTransY() {
        ArrayList<Double> lstTransY = new ArrayList<Double>();
        for (int i = 0; i < this.lstCoordSource.size(); ++i) {
            double dy = this.lstCoordDest.get((int)i).y - this.lstCoordSource.get((int)i).y;
            lstTransY.add(dy);
        }
        double sumTransY = 0.0;
        for (int i = 0; i < lstTransY.size(); ++i) {
            sumTransY += ((Double)lstTransY.get(i)).doubleValue();
        }
        this.transY = sumTransY / (double)lstTransY.size();
        double sumTransYVarianz = 0.0;
        for (int i = 0; i < lstTransY.size(); ++i) {
            sumTransYVarianz += (this.transY - (Double)lstTransY.get(i)) * (this.transY - (Double)lstTransY.get(i));
        }
        this.transYVarianz = sumTransYVarianz / (double)lstTransY.size();
    }

    public boolean isRotate() {
        return this.rotate;
    }

    public void setRotate(boolean rotate) {
        if (this.ready) {
            throw new IllegalStateException("Invalid state of object. Computation was already performed.");
        }
        this.rotate = rotate;
    }

    public double[] getGeoRefParameters() {
        this.compute();
        double[] arrParam = new double[]{Math.cos(this.rotation) * Math.abs(this.pixelSizeX) * this.scale, this.isRotate() ? -Math.sin(this.rotation) * Math.abs(this.pixelSizeY) * this.scale : 0.0, this.isRotate() ? -Math.sin(this.rotation) * Math.abs(this.pixelSizeX) * this.scale : 0.0, -Math.cos(this.rotation) * Math.abs(this.pixelSizeY) * this.scale, this.calcImageInsertionPoint.x + this.transX, this.calcImageInsertionPoint.y + this.transY};
        return arrParam;
    }

    public double getScale() {
        this.compute();
        return this.scale;
    }

    public double getScaleVarianz() {
        this.compute();
        return this.scaleVarianz;
    }

    public double getTransX() {
        this.compute();
        return this.transX;
    }

    public double getTransXVarianz() {
        this.compute();
        return this.transXVarianz;
    }

    public double getTransY() {
        this.compute();
        return this.transY;
    }

    public double getTransYVarianz() {
        this.compute();
        return this.transYVarianz;
    }

    public double getRotation() {
        this.compute();
        return this.rotation;
    }

    public double getRotationVarianz() {
        this.compute();
        return this.rotationVarianz;
    }

    public ROI rotateROI(ROI roi) {
        this.compute();
        ParameterBlock pb = new ParameterBlock();
        pb.add(0.0f);
        pb.add(0.0f);
        pb.add((float)this.rotation);
        pb.add(new InterpolationBilinear());
        roi = roi.performImageOp("rotate", pb, 0, null);
        return roi;
    }

    public PlanarImage rotateImage(RenderedImage imgSource) {
        this.compute();
        ColorModel cm = imgSource.getColorModel();
        ColorSpace cs = cm.getColorSpace();
        Color newColor = new Color(cs, cs.fromRGB(Color.WHITE.getColorComponents(null)), 0.0f);
        int[] comp = cm.getUnnormalizedComponents(newColor.getComponents(null), 0, null, 0);
        int numComponents = comp.length;
        double[] bgColor = new double[numComponents];
        for (int idx = 0; idx < numComponents; ++idx) {
            bgColor[idx] = comp[idx];
        }
        ParameterBlock pb = new ParameterBlock();
        pb.addSource(imgSource);
        pb.add(0.0f);
        pb.add(0.0f);
        pb.add((float)this.rotation);
        pb.add(new InterpolationBilinear());
        pb.add(bgColor);
        return JAI.create((String)"rotate", (ParameterBlock)pb);
    }

    private class Line {
        private Coordinate start = null;
        private Coordinate end = null;

        private Line(GeoRefComputer geoRefComputer, Coordinate start, Coordinate end) {
            this.start = start;
            this.end = end;
        }

        private double getLength() {
            return ConstSupport.getLength((Coordinate)this.start, (Coordinate)this.end);
        }

        private double getOriInRad() {
            return ConstSupport.getOrientation((Coordinate)this.start, (Coordinate)this.end, (int)2);
        }
    }
}

