/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.plugin.raster.imp;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.workbench.ui.cursortool.editing.DescriptionPanel;
import com.vividsolutions.jump.workbench.ui.cursortool.editing.construction.AbstractConstTool;
import com.vividsolutions.jump.workbench.ui.plugin.raster.imp.ControlPoint;
import de.riwagis.icons.IconLoader;
import java.awt.Shape;
import java.awt.geom.GeneralPath;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JPanel;
import org.locationtech.jts.geom.Coordinate;

public class ControlPointTool
extends AbstractConstTool {
    private ControlPointConsumer cpConsumer = null;

    public ControlPointTool(ControlPointConsumer cpConsumer) {
        super(2);
        this.cpConsumer = cpConsumer;
    }

    @Override
    public Icon getIcon() {
        return IconLoader.svgIcon((String)"geometry_add_line.svg");
    }

    @Override
    public String getName() {
        return I18N.get("ui.plugin.raster.imp.ControlPointTool.name");
    }

    @Override
    public void deactivate() {
        super.deactivate();
        this.cpConsumer.deactivate();
    }

    @Override
    protected Shape getShape() throws NoninvertibleTransformException {
        List<Coordinate> lstCoord = this.getCoordinates();
        GeneralPath path = new GeneralPath();
        this.drawPoints(path, lstCoord);
        Coordinate coordCursor = this.getTentativeCoordinate();
        if (lstCoord.size() > 0) {
            Point2D pointStart = this.getPanel().getViewport().toViewPoint(lstCoord.get(0));
            Point2D pointCursor = this.getPanel().getViewport().toViewPoint(coordCursor);
            path.moveTo(pointStart.getX(), pointStart.getY());
            path.lineTo(pointCursor.getX(), pointCursor.getY());
        }
        this.drawSnapCross(this.getTentativeCoordinate(), path, this.getPanel());
        return path;
    }

    @Override
    public JPanel getAssistentPanel() {
        return DescriptionPanel.getBackPanel(I18N.get("ui.plugin.raster.imp.ControlPointTool.desc"), this);
    }

    @Override
    protected void gestureFinished() throws Exception {
        if (this.getCoordinates().size() < 2) {
            return;
        }
        List<Coordinate> lstCoord = this.getCoordinates();
        ControlPoint cp = new ControlPoint(lstCoord.get(0), lstCoord.get(1));
        this.cpConsumer.consumeControlPoint(cp);
    }

    public static interface ControlPointConsumer {
        public void consumeControlPoint(ControlPoint var1);

        public void deactivate();
    }
}

