/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.plugin.raster;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.workbench.model.RasterImageLayer;
import com.vividsolutions.jump.workbench.model.RiwaJumpModelUtilities;
import com.vividsolutions.jump.workbench.model.StyleCollection;
import com.vividsolutions.jump.workbench.ui.Viewport;
import com.vividsolutions.jump.workbench.ui.renderer.style.AbstractRasterStyleRenderer;
import com.vividsolutions.jump.workbench.ui.renderer.style.StyleRenderer;
import de.riwagis.crs.CRSDefinition;
import de.riwagis.geotools.feature.ShapeFeatureSTRtree;
import de.riwagis.riwajump.data.model.datalocation.raster.RasterDataLocationSupport;
import de.riwagis.riwajump.model.event.JumpModelEvent;
import de.riwagis.riwajump.model.intelligence.IntelligenceFactory;
import de.riwagis.riwajump.model.style.RasterStyleModel;
import de.riwagis.util.exception.SystemException;
import java.awt.AlphaComposite;
import java.awt.Composite;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.nio.ByteBuffer;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.geotools.coverage.grid.io.AbstractGridCoverage2DReader;
import org.geotools.coverage.grid.io.GridCoverage2DReader;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.util.Assert;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class RasterRenderer
extends AbstractRasterStyleRenderer {
    public static final String CARTESIAN_2D_CRS_CODE = "Wildcard 2D cartesian plane in metric unit";
    private StyleCollection sCol = null;
    private final RasterStyleModel rStyle;

    private RasterRenderer(RasterStyleModel rStyle) {
        this.rStyle = rStyle;
    }

    public RasterStyleModel getModel() {
        return this.rStyle;
    }

    public void fireJumpModelChanged(JumpModelEvent modelEvent) {
    }

    @Override
    public boolean isEnabled() {
        return this.rStyle.isEnabled();
    }

    @Override
    public void initialize(StyleCollection _sCol) {
        this.sCol = _sCol;
    }

    @Override
    public List<StyleRenderer> getDecorationRenderer() {
        return null;
    }

    @Override
    public void paint(SimpleFeature f, Graphics2D g, Viewport viewport, ShapeFeatureSTRtree tree) throws Exception {
        RasterImageLayer rly = this.getRasterLayer();
        AbstractGridCoverage2DReader gcread = rly.getGridCoverageReader();
        CoordinateReferenceSystem crsSource = gcread.getCoordinateReferenceSystem();
        CRSDefinition crsDefTarget = rly.getLayerManager().getTask().getCRSDefinition();
        CoordinateReferenceSystem crsTarget = null;
        if (crsDefTarget != null) {
            crsTarget = crsDefTarget.getCRS();
        }
        if (!(crsSource == null || crsSource.getName().getCode().equalsIgnoreCase(CARTESIAN_2D_CRS_CODE) || crsTarget == null || crsTarget.getName().getCode().equalsIgnoreCase(CARTESIAN_2D_CRS_CODE) || StringUtils.equals((CharSequence)crsSource.getName().getCode(), (CharSequence)crsTarget.getName().getCode()) && StringUtils.equalsIgnoreCase((CharSequence)crsSource.getName().getCodeSpace(), (CharSequence)crsTarget.getName().getCodeSpace()))) {
            throw new SystemException(I18N.getMessage("ui.plugin.raster.RasterRenderer.error-transformation-unsupported", crsTarget.getName().toString()));
        }
        Envelope jtsEnv = viewport.getEnvelopeInModelCoordinates();
        ReferencedEnvelope envTarget = new ReferencedEnvelope(jtsEnv.getMinX(), jtsEnv.getMaxX(), jtsEnv.getMinY(), jtsEnv.getMaxY(), crsSource);
        AffineTransform modelToViewTransform = new AffineTransform(viewport.getModelToViewTransform());
        Dimension size = viewport.getPanel().getSize();
        double pixelScale = g.getTransform().getScaleX();
        BufferedImage bim = RasterDataLocationSupport.getImageFromGCReader((GridCoverage2DReader)gcread, envTarget, modelToViewTransform, size, pixelScale);
        Composite compOld = g.getComposite();
        g.setComposite(AlphaComposite.getInstance(3, (float)(this.getUserDefinedAlpha() * this.rStyle.getAlpha() / 255) / 255.0f));
        if (this.rStyle.isUseClearColor() && this.rStyle.getClearColor() != null) {
            int transparentColor = RiwaJumpModelUtilities.colorByColorModel(this.rStyle.getClearColor()).getRGB();
            for (int w = 0; w < bim.getWidth(); ++w) {
                for (int h = 0; h < bim.getHeight(); ++h) {
                    int currentColor = bim.getRGB(w, h);
                    if (currentColor != transparentColor) continue;
                    ByteBuffer bbuf = ByteBuffer.allocate(4);
                    bbuf.putInt(currentColor);
                    byte[] arrColor = bbuf.array();
                    arrColor[0] = 0;
                    bbuf.clear();
                    bbuf.put(arrColor);
                    bbuf.flip();
                    int newColor = bbuf.getInt();
                    bim.setRGB(w, h, newColor);
                }
            }
        }
        g.drawImage(bim, 0, 0, size.width, size.height, null);
        g.setComposite(compOld);
    }

    @Override
    public boolean needsRendering() {
        return true;
    }

    private RasterImageLayer getRasterLayer() {
        if (this.sCol == null) {
            Assert.shouldNeverReachHere((String)"StyleCollection is null. Style was not initialized.");
            return null;
        }
        return (RasterImageLayer)this.sCol.getLayerable();
    }

    static {
        IntelligenceFactory.register(RasterStyleModel.class, RasterRenderer::new);
    }
}

