/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.plugin.raster;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.workbench.model.RiwaJumpModelUtilities;
import com.vividsolutions.jump.workbench.model.SimpleStyleCollection;
import com.vividsolutions.jump.workbench.model.StyleCollection;
import com.vividsolutions.jump.workbench.ui.ColorChooserPanel;
import com.vividsolutions.jump.workbench.ui.GUIUtil;
import com.vividsolutions.jump.workbench.ui.TransparencyPanel;
import com.vividsolutions.jump.workbench.ui.style.AbstractStylePanel;
import de.riwagis.riwajump.model.style.RasterStyleModel;
import de.riwagis.riwajump.model.style.StyleModel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JTextField;

public class RasterImageLayerStylePanel
extends AbstractStylePanel {
    private SimpleStyleCollection sCol = null;
    private String strTitle = "RasterStyles";
    private boolean doUpdateControls = true;
    private boolean bolUseClearColor = false;
    private Color clearColor = Color.WHITE;
    private int alpha = 0;
    private JCheckBox cboClear;
    private ColorChooserPanel colorChooserPanelClear;
    private JLabel lblTransparency;
    private TransparencyPanel transparencyPanel;
    private JTextField txtTransparency;

    public RasterImageLayerStylePanel(StyleCollection _sCol) {
        this.sCol = (SimpleStyleCollection)_sCol;
        this.initComponents();
        this.i18n();
        this.init();
    }

    private void init() {
        this.txtTransparency.setText("" + (255 - this.alpha));
        this.transparencyPanel.addChangeListener(event -> {
            this.alpha = this.transparencyPanel.getAlpha();
            this.updateControls();
        });
        this.updateControls();
    }

    private void updateControls() {
        if (!this.doUpdateControls) {
            return;
        }
        this.doUpdateControls = false;
        try {
            this.cboClear.setSelected(this.bolUseClearColor);
            this.colorChooserPanelClear.setAlpha(this.alpha);
            this.colorChooserPanelClear.setColor(this.clearColor);
            this.colorChooserPanelClear.setEnabled(this.bolUseClearColor);
        }
        finally {
            this.doUpdateControls = true;
        }
    }

    private void i18n() {
        this.strTitle = I18N.get("ui.plugin.raster.RasterImageLayerStylePanel.title");
        this.cboClear.setText(I18N.get("ui.plugin.raster.RasterImageLayerStylePanel.clear-color"));
        this.lblTransparency.setText(I18N.get("ui.plugin.raster.RasterImageLayerStylePanel.trancparency"));
    }

    @Override
    public void setStyleCollection(StyleCollection _sCol) {
        this.sCol = (SimpleStyleCollection)_sCol;
        RasterStyleModel rStyle = this.sCol.getStyle(RasterStyleModel.class);
        if (rStyle == null) {
            rStyle = new RasterStyleModel();
            this.sCol.addStyle((StyleModel)rStyle);
        }
        this.setRasterStyle(rStyle);
    }

    @Override
    public String validateInput() {
        return null;
    }

    @Override
    public String getTitle() {
        return this.strTitle;
    }

    @Override
    public void updateStyles() {
        boolean firingEvents = this.sCol.getLayerable().getLayerManager().isFiringEvents();
        this.sCol.getLayerable().getLayerManager().setFiringEvents(false);
        try {
            this.sCol.removeStyle((StyleModel)this.sCol.getStyle(RasterStyleModel.class));
            this.sCol.addStyle((StyleModel)this.getRasterStyle());
        }
        finally {
            this.sCol.getLayerable().getLayerManager().setFiringEvents(firingEvents);
        }
    }

    private RasterStyleModel getRasterStyle() {
        RasterStyleModel rStyle = new RasterStyleModel();
        rStyle.setAlpha(this.alpha);
        rStyle.setClearColor(RiwaJumpModelUtilities.colorModelByColor(this.clearColor));
        rStyle.setUseClearColor(this.bolUseClearColor);
        return rStyle;
    }

    public void setRasterStyle(RasterStyleModel rStyle) {
        this.alpha = rStyle.getAlpha();
        this.clearColor = RiwaJumpModelUtilities.colorByColorModel(rStyle.getClearColor());
        this.bolUseClearColor = rStyle.isUseClearColor();
        this.txtTransparency.setText("" + (255 - this.alpha));
        this.updateControls();
    }

    private void initComponents() {
        this.cboClear = new JCheckBox();
        this.lblTransparency = new JLabel();
        this.transparencyPanel = new TransparencyPanel();
        this.txtTransparency = GUIUtil.createSyncdTextField(this.transparencyPanel.getSlider(), 3);
        this.colorChooserPanelClear = new ColorChooserPanel();
        this.setLayout(new GridBagLayout());
        this.cboClear.setText("Eine Farbe des Bildes ausblenden");
        this.cboClear.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.cboClear.setMargin(new Insets(0, 0, 0, 0));
        this.cboClear.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RasterImageLayerStylePanel.this.cboClear_onActionPerformed(evt);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(7, 8, 3, 2);
        this.add((Component)this.cboClear, gridBagConstraints);
        this.lblTransparency.setText("Transparenz des Bildes:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(9, 8, 3, 2);
        this.add((Component)this.lblTransparency, gridBagConstraints);
        this.transparencyPanel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent evt) {
                RasterImageLayerStylePanel.this.transparencyPanel_onMouseReleased(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(9, 2, 3, 2);
        this.add((Component)this.transparencyPanel, gridBagConstraints);
        this.txtTransparency.setPreferredSize(new Dimension(50, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(9, 2, 3, 2);
        this.add((Component)this.txtTransparency, gridBagConstraints);
        this.colorChooserPanelClear.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RasterImageLayerStylePanel.this.colorChooserPanelClear_onActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(7, 2, 3, 2);
        this.add((Component)this.colorChooserPanelClear, gridBagConstraints);
    }

    private void transparencyPanel_onMouseReleased(MouseEvent evt) {
    }

    private void colorChooserPanelClear_onActionPerformed(ActionEvent evt) {
        this.clearColor = this.colorChooserPanelClear.getColor();
        this.updateControls();
    }

    private void cboClear_onActionPerformed(ActionEvent evt) {
        this.bolUseClearColor = this.cboClear.isSelected();
        this.updateControls();
    }
}

