/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.plugin.raster;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.workbench.model.Layerable;
import com.vividsolutions.jump.workbench.model.RasterImageLayer;
import com.vividsolutions.jump.workbench.model.UndoableCommand;
import com.vividsolutions.jump.workbench.ui.style.LayerStylePanel;
import de.riwagis.riwajump.data.gui.datalocation.DataLocationPanel;
import de.riwagis.riwajump.data.model.datalocation.DataLocation;
import de.riwagis.riwajump.data.model.datalocation.Parameter;
import de.riwagis.riwajump.data.model.datalocation.raster.GeoTiffDataLocation;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JPanel;
import org.locationtech.jts.util.Assert;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RasterDataLocationPanel
extends JPanel
implements LayerStylePanel {
    private static final Logger LOG = LoggerFactory.getLogger(RasterDataLocationPanel.class);
    private RasterImageLayer rly = null;
    private DataLocation oldDataLoc = null;
    private DataLocation newDataLoc = null;
    private final DataLocationPanel pnlDataLocation = new DataLocationPanel(new GeoTiffDataLocation(), DataLocation.DataType.RASTER);

    public RasterDataLocationPanel(RasterImageLayer _rly) {
        this.initComponents();
        this.pnlDataLocation.showPanelWithName(false);
        this.add((Component)this.pnlDataLocation, "Center");
        this.setLayerable(_rly);
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
    }

    @Override
    public String getTitle() {
        return I18N.get("ui.plugin.raster.RasterDataLocationPanel.title");
    }

    @Override
    public final void setLayerable(Layerable layerable) {
        try {
            this.rly = (RasterImageLayer)layerable;
            this.oldDataLoc = this.rly.getDataLocation();
            this.newDataLoc = this.rly.getDataLocation().getDataLocationType().newInstance();
            List<Parameter> oldParam = this.rly.getDataLocation().getParameters();
            this.newDataLoc.setParameters(new ArrayList<Parameter>(oldParam));
            this.newDataLoc.setRootDir(this.oldDataLoc.getRootDir());
            this.pnlDataLocation.setDataLocation(this.newDataLoc);
        }
        catch (Exception e) {
            LOG.error("Error setting layerable to RasterDataLocationPanel.", (Throwable)e);
            Assert.shouldNeverReachHere((String)e.getMessage());
        }
    }

    @Override
    public UndoableCommand updateLayer() {
        this.newDataLoc = this.pnlDataLocation.getDataLocation();
        RasterDataLocationPanelUndoableCommand undo = new RasterDataLocationPanelUndoableCommand(this.rly, this.oldDataLoc, this.newDataLoc);
        return undo;
    }

    @Override
    public String validateInput() {
        this.newDataLoc = this.pnlDataLocation.getDataLocation();
        return this.newDataLoc.testConnection();
    }

    private static class RasterDataLocationPanelUndoableCommand
    extends UndoableCommand {
        private RasterImageLayer ly = null;
        private DataLocation dlOld = null;
        private DataLocation dlNew = null;

        public RasterDataLocationPanelUndoableCommand(RasterImageLayer layer, DataLocation _dlOld, DataLocation _dlNew) {
            super("RasterDataLocationPanel");
            this.ly = layer;
            this.dlOld = _dlOld;
            this.dlNew = _dlNew;
        }

        @Override
        public void execute() {
            this.ly.setDataLocation(this.dlNew);
        }

        @Override
        public void unexecute() {
            this.ly.setDataLocation(this.dlOld);
        }
    }
}

