/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.plugin.raster;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.model.AbstractLayerable;
import com.vividsolutions.jump.workbench.model.LayerManager;
import com.vividsolutions.jump.workbench.model.RasterImageLayer;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.ui.plugin.PersistentBlackboardPlugIn;
import com.vividsolutions.jump.workbench.ui.plugin.io.layer.AddLayerPlugIn;
import com.vividsolutions.jump.workbench.ui.plugin.raster.RasterDataLocationPanel;
import com.vividsolutions.jump.workbench.ui.plugin.raster.RasterImageLayerStylePanel;
import com.vividsolutions.jump.workbench.ui.style.LayerNamePanel;
import com.vividsolutions.jump.workbench.ui.style.LayerStylePanel;
import com.vividsolutions.jump.workbench.ui.style.StylePanel;
import com.vividsolutions.jump.workbench.ui.style.scale.ScaleRangeStylePanel;
import de.riwagis.riwajump.data.model.datalocation.AbstractDataLocation;
import de.riwagis.riwajump.data.model.datalocation.ParameterType;
import de.riwagis.riwajump.data.model.datalocation.Preference;
import de.riwagis.riwajump.data.model.datalocation.raster.GeoTiffDataLocation;
import java.util.ArrayList;
import java.util.List;

public class AddRasterLayerPlugIn
extends AddLayerPlugIn {
    private static final String DEFAULT_RASTER_DATALOCATION_KEY = AddRasterLayerPlugIn.class.getName() + "_DEFAULT_RASTER_DATALOCATION_KEY";

    @Override
    public String getName() {
        return I18N.get("ui.plugin.raster.AddRasterLayerPlugIn.name");
    }

    @Override
    protected Class<?> getLayerableClass() {
        return RasterImageLayer.class;
    }

    @Override
    protected StylePanel generateStylePanel(PlugInContext context, AbstractLayerable layer) throws Exception {
        RasterImageLayerStylePanel panel = new RasterImageLayerStylePanel(layer.getDefaultStyleCollection());
        return panel;
    }

    @Override
    protected List<LayerStylePanel> generateLayerPanels(PlugInContext context, AbstractLayerable layer) throws Exception {
        ArrayList<LayerStylePanel> lstPanels = new ArrayList<LayerStylePanel>();
        LayerNamePanel layerPanel = new LayerNamePanel(layer);
        lstPanels.add(0, layerPanel);
        RasterDataLocationPanel rasterDataLocPanel = new RasterDataLocationPanel((RasterImageLayer)layer);
        lstPanels.add(1, rasterDataLocPanel);
        ScaleRangeStylePanel scaleRangePanel = new ScaleRangeStylePanel(layer.cloneStyleCollections());
        lstPanels.add(2, scaleRangePanel);
        return lstPanels;
    }

    @Override
    public void initialize(PlugInContext context) throws Exception {
        AbstractDataLocation.addPreference(new Preference(this, ParameterType.FILE){

            @Override
            public String getPreference() {
                String strPref = PersistentBlackboardPlugIn.get().get(DEFAULT_RASTER_DATALOCATION_KEY, "");
                if (strPref == null) {
                    strPref = "";
                }
                return strPref;
            }

            @Override
            public void updatePreference(String strPref) {
                PersistentBlackboardPlugIn.get().put(DEFAULT_RASTER_DATALOCATION_KEY, strPref);
            }
        });
        AbstractDataLocation.addPreference(new Preference(this, ParameterType.CRS){

            @Override
            public String getPreference() {
                if (WorkbenchContext.getTask() == null) {
                    return null;
                }
                return WorkbenchContext.getTask().getCRSDefinition().getKey();
            }

            @Override
            public void updatePreference(String strPref) {
            }
        });
    }

    @Override
    protected AbstractLayerable generateLayerable(PlugInContext context) throws Exception {
        LayerManager layMngr = context.getLayerManager();
        return AddRasterLayerPlugIn.createDefaultLayer(layMngr);
    }

    public static RasterImageLayer createDefaultLayer(LayerManager layMngr) {
        String strName = I18N.get("ui.plugin.io.layer.AddNewLayerPlugIn.new-layer-name");
        RasterImageLayer layer = new RasterImageLayer(strName, layMngr, new GeoTiffDataLocation());
        return layer;
    }
}

