/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.plugin.quickinfo;

import de.riwagis.gis.context.module.quickinfo.impl.QuickInfoCategory;
import java.text.Collator;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Function;

public final class QuickInfoUtils {
    private QuickInfoUtils() {
    }

    public static Comparator<String> getPriorityCategoryComparator(List<QuickInfoCategory> quickInfos) {
        Map<String, Integer> prioritisedCategoryMap = QuickInfoUtils.mapPriorities(quickInfos);
        Collator collator = Collator.getInstance(Locale.getDefault());
        return Comparator.comparingInt(key -> prioritisedCategoryMap.getOrDefault(key, 0)).reversed().thenComparing(Function.identity(), collator);
    }

    private static Map<String, Integer> mapPriorities(List<QuickInfoCategory> quickInfos) {
        HashMap<String, Integer> priorityMap = new HashMap<String, Integer>();
        for (QuickInfoCategory cat : quickInfos) {
            String name = cat.getName();
            int priority = cat.getPriority();
            priorityMap.compute(name, (key, existingPriority) -> existingPriority == null || priority > existingPriority ? priority : existingPriority);
        }
        return priorityMap;
    }
}

