/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.plugin.quickinfo;

import com.vividsolutions.jump.workbench.model.Layer;
import java.util.Objects;
import lombok.Generated;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.filter.identity.FeatureId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class QuickInfoRecord {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(QuickInfoRecord.class);
    private final Layer layer;
    private final SimpleFeature feature;
    private final FeatureId featureID;
    private final String staticContent;
    private final boolean showTooltip;

    public QuickInfoRecord(Layer layer, SimpleFeature feature, boolean showTooltip) {
        this.layer = layer;
        this.feature = feature;
        this.featureID = feature.getIdentifier();
        this.showTooltip = showTooltip;
        this.staticContent = null;
    }

    public QuickInfoRecord(String staticContent) {
        this.layer = null;
        this.feature = null;
        this.featureID = null;
        this.showTooltip = true;
        this.staticContent = staticContent;
    }

    public Layer getLayer() {
        return this.layer;
    }

    public SimpleFeature getFeature() {
        return this.feature;
    }

    public boolean containsItem() {
        return this.layer != null && this.feature != null;
    }

    public String getStaticContent() {
        return this.staticContent;
    }

    public boolean isShowTooltip() {
        return this.showTooltip;
    }

    public int hashCode() {
        int hash = 5;
        hash = 97 * hash + Objects.hashCode(this.layer);
        hash = 97 * hash + Objects.hashCode(this.featureID);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        QuickInfoRecord other = (QuickInfoRecord)obj;
        if (!Objects.equals(this.layer, other.layer)) {
            return false;
        }
        return Objects.equals(this.featureID, other.featureID);
    }
}

