/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.plugin.quickinfo;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.util.HtmlBuilder;
import com.vividsolutions.jump.workbench.JUMPWorkbench;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.plugin.AbstractPlugIn;
import com.vividsolutions.jump.workbench.plugin.PlugIn;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.ui.DesktopPanel;
import com.vividsolutions.jump.workbench.ui.GUIUtil;
import com.vividsolutions.jump.workbench.ui.TaskFrame;
import com.vividsolutions.jump.workbench.ui.plugin.quickinfo.QuickInfoPanel;
import com.vividsolutions.jump.workbench.ui.plugin.quickinfo.QuickInfoRecord;
import com.vividsolutions.jump.workbench.ui.selection.SelectionListener;
import com.vividsolutions.jump.workbench.ui.selection.SelectionManager;
import de.riwagis.gis.context.map.LayerContext;
import java.awt.Component;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.swing.JTabbedPane;
import javax.swing.event.InternalFrameAdapter;
import javax.swing.event.InternalFrameEvent;
import lombok.Generated;
import org.opengis.feature.simple.SimpleFeature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QuickInfoPlugIn
extends AbstractPlugIn
implements PlugIn {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(QuickInfoPlugIn.class);
    private TaskFrame activeFrame;
    private QuickInfoPanel quickInfoPanel;
    private Set<LayerContext> layers4QuickInfo;
    private Set<String> layersWithoutTooltips;

    @Override
    public boolean isAvailable() {
        return JUMPWorkbench.gisContextAvailable();
    }

    @Override
    public void initialize(PlugInContext context) throws Exception {
        super.initialize(context);
        final JTabbedPane tabbedPane = context.getWorkbenchFrame().getDesktopPanel().getRightTabbedPane();
        this.quickInfoPanel = new QuickInfoPanel();
        tabbedPane.addChangeListener(e -> this.updateViewIfSelectedTab(tabbedPane));
        final SelectionListener selectionListener = () -> this.updateViewIfSelectedTab(tabbedPane);
        GUIUtil.addInternalFrameListener(context.getWorkbenchFrame().getDesktopPane(), new InternalFrameAdapter(){

            @Override
            public void internalFrameActivated(InternalFrameEvent e) {
                log.debug("Updating selection listener reference");
                if (!(e.getInternalFrame() instanceof TaskFrame)) {
                    return;
                }
                TaskFrame newActiveFrame = (TaskFrame)e.getInternalFrame();
                if (QuickInfoPlugIn.this.activeFrame != null && QuickInfoPlugIn.this.activeFrame != newActiveFrame && QuickInfoPlugIn.this.activeFrame.getLayerViewPanel() != null) {
                    QuickInfoPlugIn.this.activeFrame.getLayerViewPanel().getSelectionManager().removeSelectionListener(selectionListener);
                }
                try {
                    QuickInfoPlugIn.this.layers4QuickInfo = JUMPWorkbench.GIS_CONTEXT.getModuleApp().getLayers4QuickInfo();
                    QuickInfoPlugIn.this.layersWithoutTooltips = JUMPWorkbench.GIS_CONTEXT.getModuleApp().getLayersWithoutTooltips();
                }
                catch (Exception ex) {
                    log.error("Could not retrieve quick info layers", (Throwable)ex);
                    QuickInfoPlugIn.this.layers4QuickInfo = Set.of();
                    QuickInfoPlugIn.this.layersWithoutTooltips = Set.of();
                }
                QuickInfoPlugIn.this.activeFrame = newActiveFrame;
                QuickInfoPlugIn.this.activeFrame.getSelectionManager().addSelectionListener(selectionListener);
                Set allLayerKeys = QuickInfoPlugIn.this.activeFrame.getLayerManager().getLayers().stream().map(l -> l.getKey()).collect(Collectors.toSet());
                boolean layersWithQuickInfos = QuickInfoPlugIn.this.layers4QuickInfo.stream().anyMatch(lc -> allLayerKeys.contains(lc.getID()));
                QuickInfoPlugIn.this.quickInfoPanel.setEnabled(layersWithQuickInfos);
                int tabIndex = tabbedPane.indexOfComponent(QuickInfoPlugIn.this.quickInfoPanel);
                tabbedPane.setEnabledAt(tabIndex, layersWithQuickInfos);
                if (!layersWithQuickInfos && tabbedPane.getSelectedComponent() == QuickInfoPlugIn.this.quickInfoPanel) {
                    tabbedPane.setSelectedIndex(0);
                }
                tabbedPane.setToolTipTextAt(tabIndex, layersWithQuickInfos ? null : I18N.get("com.vividsolutions.jump.workbench.ui.plugin.quickinfo.QuickInfoPlugIn.no-quickinfo-layers-available"));
                QuickInfoPlugIn.this.updateView();
            }
        });
        tabbedPane.add((Component)this.quickInfoPanel, I18N.get("com.vividsolutions.jump.workbench.ui.plugin.quickinfo.QuickInfoPlugIn.quick-infos"));
    }

    @Override
    public String getName() {
        return I18N.get("com.vividsolutions.jump.workbench.ui.plugin.quickinfo.QuickInfoPlugIn.quick-infos");
    }

    public boolean setCurrentRecordByFeature(PlugInContext context, Layer layer, SimpleFeature feature) {
        JTabbedPane tabbedPane;
        DesktopPanel desktopPanel = context.getWorkbenchFrame().getDesktopPanel();
        if (!desktopPanel.getRightTabsVisible()) {
            desktopPanel.setRightTabsVisible(true);
        }
        if ((tabbedPane = desktopPanel.getRightTabbedPane()).getSelectedComponent() != this.quickInfoPanel) {
            tabbedPane.setSelectedComponent(this.quickInfoPanel);
        }
        return this.quickInfoPanel.setCurrentRecordByFeature(layer, feature, this.showTooltipForLayer(layer));
    }

    public Set<LayerContext> getQuickInfoLayers() {
        return this.layers4QuickInfo;
    }

    private void updateViewIfSelectedTab(JTabbedPane tabbedPane) {
        if (tabbedPane.getSelectedComponent() != this.quickInfoPanel) {
            return;
        }
        this.updateView();
    }

    private void updateView() {
        log.debug("updateView from plugin");
        if (!this.quickInfoPanel.isEnabled()) {
            return;
        }
        if (this.activeFrame == null) {
            return;
        }
        SelectionManager selectionManager = this.activeFrame.getSelectionManager();
        if (selectionManager == null) {
            return;
        }
        this.updateRecords(selectionManager, this.layers4QuickInfo);
    }

    private void updateRecords(SelectionManager selectionManager, Set<LayerContext> layers4QuickInfo) {
        this.quickInfoPanel.removeAllRecords();
        List selectedLayersWithQuickInfos = selectionManager.getLayersWithSelectedItems().stream().filter(l -> layers4QuickInfo.contains(l.getVectorLayerContext())).collect(Collectors.toList());
        if (selectedLayersWithQuickInfos.isEmpty()) {
            HtmlBuilder document = new HtmlBuilder();
            if (layers4QuickInfo.isEmpty()) {
                this.quickInfoPanel.addRecord(new QuickInfoRecord(I18N.get("com.vividsolutions.jump.workbench.ui.plugin.quickinfo.QuickInfoPlugIn.no-quickinfo-layers-available")));
            } else {
                document.addBlockElement("b", Collections.emptyMap(), I18N.get("com.vividsolutions.jump.workbench.ui.plugin.quickinfo.QuickInfoPlugIn.quick-infos-layers-available-for"));
                document.addBlockElement("ul", Collections.emptyMap(), layers4QuickInfo.stream().sorted(Comparator.comparing(LayerContext::getName)).map(l -> "<li>" + l.getName() + "</li>").collect(Collectors.joining("")));
                this.quickInfoPanel.addRecord(new QuickInfoRecord(document.build()));
            }
            return;
        }
        log.debug("New selection");
        for (Layer layer : selectedLayersWithQuickInfos) {
            for (SimpleFeature feature : selectionManager.getFeaturesWithSelectedItems(layer)) {
                this.quickInfoPanel.addRecord(new QuickInfoRecord(layer, feature, this.showTooltipForLayer(layer)));
            }
        }
    }

    private boolean showTooltipForLayer(Layer layer) {
        String layerKey = layer.getKey();
        return !this.layersWithoutTooltips.contains(layerKey);
    }
}

