/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.plugin.quickinfo;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.workbench.COpt;
import com.vividsolutions.jump.workbench.JUMPWorkbench;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.ui.LayerViewPanel;
import com.vividsolutions.jump.workbench.ui.Priorizable;
import com.vividsolutions.jump.workbench.ui.components.HyperlinkButton;
import com.vividsolutions.jump.workbench.ui.components.RecordPanel;
import com.vividsolutions.jump.workbench.ui.plugin.quickinfo.QuickInfoRecord;
import com.vividsolutions.jump.workbench.ui.plugin.quickinfo.QuickInfoUtils;
import com.vividsolutions.jump.workbench.ui.zoom.ZoomToSelectedItemsPlugIn;
import de.riwagis.gis.context.module.quickinfo.QuickInfo;
import de.riwagis.gis.context.module.quickinfo.QuickInfoList;
import de.riwagis.gis.context.module.quickinfo.QuickInfoRequest;
import de.riwagis.gis.context.module.quickinfo.impl.QuickInfoRequestImpl;
import de.riwagis.icons.IconLoader;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.geom.NoninvertibleTransformException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.CancellationException;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.border.Border;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.jdesktop.swingx.JXBusyLabel;
import org.jdesktop.swingx.JXPanel;
import org.jdesktop.swingx.JXTaskPane;
import org.jdesktop.swingx.JXTaskPaneContainer;
import org.jdesktop.swingx.VerticalLayout;
import org.locationtech.jts.geom.Geometry;
import org.opengis.feature.simple.SimpleFeature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class QuickInfoPanel
extends RecordPanel<QuickInfoRecord>
implements Priorizable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(QuickInfoPanel.class);
    public static final int RESPONSE_TIMEOUT_SECONDS = 60;
    private final JButton flashButton = new JButton();
    private final JPanel customPanel;
    private final JXBusyLabel busyLabel;
    private final JLabel errorLabel;
    private final JLabel headerLabel;
    private final JLabel noQuickInfoForFeature;
    private final JLabel staticContentLabel;
    private final JXTaskPaneContainer taskContainer;
    private final JScrollPane scrollPane;
    private final Border emptyBorder5px;
    private final ZoomToSelectedItemsPlugIn zoomToSelectedItemsPlugIn = new ZoomToSelectedItemsPlugIn();
    private final JButton refreshButton = new JButton();
    public static final int TRIGGER_INTERVAL = 200;
    private final Timer updateInfoTimer = new Timer(200, e -> {
        int index = this.getCurrentIndex();
        if (index == -1) {
            return;
        }
        this.triggerQuickInfoRequest((QuickInfoRecord)this.getRecord(index));
    });

    public QuickInfoPanel() {
        this.customPanel = new JPanel(new BorderLayout());
        this.updateInfoTimer.setRepeats(false);
        this.updateInfoTimer.setInitialDelay(200);
        this.setRecordComponent(this.customPanel);
        this.addRecordChangeListener(index -> {
            if (index == -1) {
                return;
            }
            this.updateRecordUI(null, null);
            this.updateInfoTimer.restart();
        });
        this.setName("QUICKINFO_PANEL");
        this.emptyBorder5px = BorderFactory.createEmptyBorder(5, 5, 5, 5);
        this.busyLabel = new JXBusyLabel();
        this.busyLabel.setBusy(true);
        this.busyLabel.setHorizontalTextPosition(0);
        this.busyLabel.setVerticalTextPosition(3);
        this.busyLabel.setHorizontalAlignment(0);
        this.busyLabel.setVerticalAlignment(1);
        this.busyLabel.setText(I18N.get("common.wait"));
        this.headerLabel = new JLabel();
        this.headerLabel.setBorder(this.emptyBorder5px);
        this.errorLabel = new JLabel(String.format("<html><h3>%s</h3></html>", I18N.get("com.vividsolutions.jump.workbench.ui.plugin.quickinfo.QuickInfoPanel.request-error")));
        this.errorLabel.setForeground(Color.red);
        this.errorLabel.setBorder(this.emptyBorder5px);
        this.errorLabel.setVerticalAlignment(1);
        this.noQuickInfoForFeature = new JLabel(String.format("<html>%s</html>", I18N.get("com.vividsolutions.jump.workbench.ui.plugin.quickinfo.QuickInfoPanel.no-infos-for-selection")));
        this.noQuickInfoForFeature.setBorder(this.emptyBorder5px);
        this.noQuickInfoForFeature.setVerticalAlignment(1);
        this.staticContentLabel = new JLabel();
        this.staticContentLabel.setVerticalAlignment(1);
        this.staticContentLabel.setBorder(this.emptyBorder5px);
        this.taskContainer = new JXTaskPaneContainer();
        this.taskContainer.setLayout((LayoutManager)new VerticalLayout());
        this.taskContainer.setBorder(BorderFactory.createEmptyBorder());
        this.taskContainer.setBackground(this.getBackground());
        this.scrollPane = new JScrollPane((Component)this.taskContainer);
        this.scrollPane.setBorder(BorderFactory.createEmptyBorder());
        this.refreshButton.setIcon(IconLoader.svgIcon((String)"common_reload.svg"));
        this.refreshButton.setToolTipText(I18N.get("com.vividsolutions.jump.workbench.ui.plugin.quickinfo.QuickInfoPlugIn.refresh-current-feature"));
        this.refreshButton.addActionListener(e -> this.refreshCurrentFeature());
        this.addToNavigationBar(new JSeparator(1));
        this.addToNavigationBar(this.refreshButton);
        this.flashButton.setIcon(IconLoader.svgIcon((String)"common_highlight.svg"));
        this.flashButton.setToolTipText(I18N.get("com.vividsolutions.jump.workbench.ui.plugin.quickinfo.QuickInfoPanel.flash-current-feature"));
        this.flashButton.addActionListener(e -> this.flashCurrentFeature());
        this.addToNavigationBar(new JSeparator(1));
        this.addToNavigationBar(this.flashButton);
    }

    public void updateRecordUI(QuickInfoList quickInfoList, Throwable throwable) {
        log.debug("updating panel state");
        QuickInfoRecord record = (QuickInfoRecord)this.getCurrentRecord();
        this.customPanel.removeAll();
        if (record.containsItem()) {
            this.headerLabel.setText(String.format("<html>%s%s</html>", this.getRecordTitle(record.getLayer()), this.getRecordToolTip(record)));
            this.customPanel.add((Component)this.headerLabel, "North");
            if (throwable != null) {
                this.customPanel.add((Component)this.errorLabel, "Center");
            } else if (quickInfoList == null) {
                this.customPanel.add((Component)this.busyLabel, "Center");
            } else if (quickInfoList.getQuickInfos().isEmpty()) {
                this.customPanel.add((Component)this.noQuickInfoForFeature, "Center");
            } else {
                this.taskContainer.removeAll();
                for (Map.Entry<String, JXTaskPane> entry : this.retrieveSortedTaskPanes(quickInfoList).entrySet()) {
                    this.taskContainer.add((Component)entry.getValue());
                }
                this.customPanel.add((Component)this.scrollPane, "Center");
            }
        } else {
            this.staticContentLabel.setText(record.getStaticContent());
            this.customPanel.add((Component)this.staticContentLabel, "Center");
        }
        this.customPanel.revalidate();
        this.customPanel.repaint();
    }

    public Map<String, JXTaskPane> retrieveSortedTaskPanes(QuickInfoList quickInfoList) {
        TreeMap<String, JXTaskPane> taskPanes = new TreeMap<String, JXTaskPane>(QuickInfoUtils.getPriorityCategoryComparator(quickInfoList.getQuickInfos()));
        quickInfoList.getQuickInfos().stream().collect(Collectors.groupingBy(qi -> qi.getName(), TreeMap::new, Collectors.toList())).forEach((category, categories) -> {
            List infos = categories.stream().flatMap(c -> c.getElements().stream()).collect(Collectors.toList());
            JXTaskPane categoryPane = new JXTaskPane();
            categoryPane.setTitle(category);
            categoryPane.setForeground(Color.BLACK);
            JXPanel taskPanel = (JXPanel)categoryPane.getContentPane();
            taskPanel.setOpaque(false);
            taskPanel.setBorder(this.emptyBorder5px);
            int infoCount = infos.stream().mapToInt(quickInfo -> {
                JPanel actionPanel = new JPanel();
                actionPanel.setLayout((LayoutManager)new VerticalLayout());
                categoryPane.add((Component)actionPanel);
                return this.fillInfosIntoPanel((QuickInfo)quickInfo, actionPanel, 0);
            }).sum();
            categoryPane.setToolTipText(String.format("<html><b> %s</b> - %d %s</html>", category, infoCount, I18N.get("com.vividsolutions.jump.workbench.ui.plugin.quickinfo.QuickInfoPlugIn.entries")));
            taskPanes.put((String)category, categoryPane);
        });
        return taskPanes;
    }

    private String getRecordTitle(Layer layer) {
        return String.format("<h2>%s</h2>", layer.getName());
    }

    private String getRecordToolTip(QuickInfoRecord currentRecord) {
        if (!currentRecord.isShowTooltip()) {
            return "";
        }
        String tooltipForFeature = WorkbenchContext.getInstance().getLayerViewPanel().getToolTipWriter().getTooltipForFeature(currentRecord.getLayer(), currentRecord.getFeature(), false);
        return String.format("<p>%s</p><br>", tooltipForFeature);
    }

    private void flashCurrentFeature() {
        try {
            QuickInfoRecord record = (QuickInfoRecord)this.getCurrentRecord();
            if (record.getFeature() != null) {
                Geometry featureGeom = (Geometry)record.getFeature().getDefaultGeometry();
                LayerViewPanel lvp = WorkbenchContext.getInstance().getLayerViewPanel();
                if (lvp != null) {
                    this.zoomToSelectedItemsPlugIn.flash(Arrays.asList(featureGeom), WorkbenchContext.getInstance().getLayerViewPanel());
                }
            }
        }
        catch (NoninvertibleTransformException nite) {
            log.warn("Flashing for feature failed in QuickInfoPanel", (Throwable)nite);
        }
    }

    public boolean setCurrentRecordByFeature(Layer layer, SimpleFeature feature, boolean showTooltip) {
        int index = this.setCurrentRecord(new QuickInfoRecord(layer, feature, showTooltip));
        if (index == -1) {
            return false;
        }
        this.updateAppearance();
        this.flashCurrentFeature();
        return true;
    }

    private void refreshCurrentFeature() {
        this.setCurrentIndex(this.getCurrentIndex());
    }

    private int fillInfosIntoPanel(QuickInfo quickInfo, JPanel actionPanel, int level) {
        Border indentedBorder = BorderFactory.createEmptyBorder(0, level * 10, 0, 0);
        if (StringUtils.isNotBlank((CharSequence)quickInfo.getLabel())) {
            JLabel comp = new JLabel(String.format("<html>%s</html>", quickInfo.getLabel()));
            comp.setBorder(indentedBorder);
            actionPanel.add(comp);
        }
        quickInfo.getActions().forEach(action -> {
            HyperlinkButton hyperlink = new HyperlinkButton(String.format("<html>%s</html>", action.getActionText()), () -> JUMPWorkbench.GIS_CONTEXT.getModuleApp().invokeQuickInfoAction(action));
            hyperlink.setBorder(indentedBorder);
            actionPanel.add(hyperlink);
        });
        return 1 + quickInfo.getElements().stream().mapToInt(subElement -> this.fillInfosIntoPanel((QuickInfo)subElement, actionPanel, level + 1)).sum();
    }

    private void triggerQuickInfoRequest(QuickInfoRecord record) {
        if (!record.containsItem()) {
            return;
        }
        log.debug("Invoking Quick Info Request... ");
        Layer layer = record.getLayer();
        SimpleFeature feature = record.getFeature();
        JUMPWorkbench.GIS_CONTEXT.getModuleApp().sendQuickInfoRequest((QuickInfoRequest)new QuickInfoRequestImpl(layer.getName(), layer.getKey(), (Object)feature.getID(), (Geometry)feature.getDefaultGeometry(), feature.getAttributes())).orTimeout(60L, TimeUnit.SECONDS).whenComplete((list, t) -> {
            if (t instanceof CancellationException) {
                log.debug("Request canceled. Skipping Record Update");
                return;
            }
            if (t != null) {
                log.error("Could not finish quick info request.", t);
            }
            SwingUtilities.invokeLater(() -> {
                QuickInfoRecord currentRecord = (QuickInfoRecord)this.getCurrentRecord();
                if (currentRecord != record) {
                    return;
                }
                this.updateRecordUI((QuickInfoList)list, (Throwable)t);
            });
        });
    }

    @Override
    public int getPriority() {
        if (COpt.VIEWER) {
            return 1000;
        }
        return 0;
    }

    @Override
    protected void updateAppearance() {
        boolean isEnabled;
        super.updateAppearance();
        boolean bl = isEnabled = this.getRecordCount() > 0 && ((QuickInfoRecord)this.getCurrentRecord()).getFeature() != null;
        if (this.refreshButton != null) {
            this.refreshButton.setEnabled(isEnabled);
        }
        if (this.flashButton != null) {
            this.flashButton.setEnabled(isEnabled);
        }
    }

    @Override
    protected void startButton_actionPerformed(ActionEvent e) {
        super.startButton_actionPerformed(e);
        this.flashCurrentFeature();
    }

    @Override
    protected void prevButton_actionPerformed(ActionEvent e) {
        super.prevButton_actionPerformed(e);
        this.flashCurrentFeature();
    }

    @Override
    protected void endButton_actionPerformed(ActionEvent e) {
        super.endButton_actionPerformed(e);
        this.flashCurrentFeature();
    }

    @Override
    protected void nextButton_actionPerformed(ActionEvent e) {
        super.nextButton_actionPerformed(e);
        this.flashCurrentFeature();
    }
}

