/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.plugin.print.legend.model;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.vividsolutions.jump.workbench.ui.plugin.print.legend.model.LegendEntryModel;
import de.riwagis.riwajump.model.JumpModel;
import de.riwagis.util.lang.StringComparator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

@XStreamAlias(value="legendModel")
public class LegendModel
extends JumpModel
implements Comparable<LegendModel> {
    private static final StringComparator COMP = new StringComparator();
    private String name;
    private List<LegendEntryModel> entries = new ArrayList<LegendEntryModel>();
    private transient boolean buildIn = false;

    public LegendModel(String name) {
        this.setName(name);
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.getName();
    }

    public final void setName(String name) {
        if (StringUtils.isEmpty((CharSequence)name)) {
            throw new IllegalArgumentException("Name can not be empty.");
        }
        this.name = name;
        this.fireModelChanged("name", name);
    }

    public List<LegendEntryModel> getEntries() {
        return Collections.unmodifiableList(this.entries);
    }

    public void setEntries(List<LegendEntryModel> entries) {
        this.entries = new ArrayList<LegendEntryModel>(entries);
        this.fireModelChanged("entries", entries);
    }

    public void addEntry(LegendEntryModel entry) {
        this.entries.add(entry);
        this.fireModelChanged("entries_add", (Object)entry);
    }

    public void addEntry(int index, LegendEntryModel entry) {
        this.entries.add(index, entry);
        this.fireModelChanged("entries_add", (Object)entry);
    }

    public LegendEntryModel getEntry(int index) {
        return this.entries.get(index);
    }

    public int size() {
        return this.entries.size();
    }

    public boolean removeEntry(LegendEntryModel entry) {
        boolean removed = this.entries.remove((Object)entry);
        if (removed) {
            this.fireModelChanged("entries_remove", (Object)entry);
        }
        return removed;
    }

    public boolean isBuildIn() {
        return this.buildIn;
    }

    public void setBuildIn(boolean buildIn) {
        this.buildIn = buildIn;
    }

    @Override
    public int compareTo(LegendModel o) {
        return COMP.compare((Object)this.getName(), (Object)o.getName());
    }

    public LegendModel clone() throws CloneNotSupportedException {
        LegendModel clonedLeg = (LegendModel)super.clone();
        clonedLeg.entries = new ArrayList<LegendEntryModel>();
        for (LegendEntryModel entry : this.entries) {
            clonedLeg.entries.add((LegendEntryModel)entry.clone());
        }
        return clonedLeg;
    }
}

