/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.plugin.print.legend.model;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.vividsolutions.jump.workbench.ui.plugin.print.legend.model.LegendEntryLayerModel;
import de.riwagis.riwajump.model.Range;

@XStreamAlias(value="legendEntryLayerThemeModel")
public class LegendEntryLayerThemeModel
extends LegendEntryLayerModel {
    private Object themeId;

    public LegendEntryLayerThemeModel(String name, String layerId, Object themeId) {
        super(name, layerId);
        this.setThemeId(LegendEntryLayerThemeModel.createThemeId(themeId));
    }

    private static final Object createThemeId(Object themeId) {
        if (themeId != null && themeId instanceof Range) {
            Range themeRange = (Range)themeId;
            Object objMax = themeRange.getMax();
            Object objMin = themeRange.getMin();
            if (objMax instanceof Range.PositiveInfinity) {
                return Double.MAX_VALUE;
            }
            if (objMin instanceof Range.NegativeInfinity) {
                return Double.MIN_VALUE;
            }
            if (!(objMax instanceof Number)) {
                throw new IllegalArgumentException("Invalid Range for themeId (max value)");
            }
            double maxVal = ((Number)objMax).doubleValue();
            if (!(objMin instanceof Number)) {
                throw new IllegalArgumentException("Invalid Range for themeId (min value)");
            }
            double minVal = ((Number)objMin).doubleValue();
            return (maxVal + minVal) / 2.0;
        }
        return themeId;
    }

    public Object getThemeId() {
        return this.themeId;
    }

    public void setThemeId(Object themeId) {
        this.themeId = themeId;
        this.fireModelChanged("themeId", themeId);
    }
}

