/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.plugin.print.legend.intelligence;

import de.riwagis.riwajump.symbol.AbstractSymbolStore;
import de.riwagis.util.svg.SVGSupport;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.w3c.dom.Document;

public class LegendSvgSymbolStore
extends AbstractSymbolStore {
    public static final String LEGEND_SYM_NAME = "LEGEND_SYMBOL.svg";
    private static final String[] LEGEND_SYM_NAMES = new String[]{"LEGEND_SYMBOL.svg"};
    private final byte[] svgData;

    public LegendSvgSymbolStore(byte[] svgData) {
        this.svgData = svgData;
    }

    public void renderLegendSymbol(Graphics2D g2d, int left, int top, int width, int height) throws IOException {
        Dimension svgDim = this.getSvgDimension(width, height);
        AffineTransform trans = AffineTransform.getTranslateInstance(left += (int)((svgDim.getWidth() - (double)width) / 2.0), top += (int)((svgDim.getHeight() - (double)height) / 2.0));
        this.renderSymbol(LEGEND_SYM_NAME, g2d, trans, (int)svgDim.getWidth(), null, null);
    }

    private Dimension getSvgDimension(int width, int height) throws IOException {
        double ratioFit;
        Document doc = super.getSVGDoc(LEGEND_SYM_NAME, null, null, 255, false);
        Rectangle2D svgRect = SVGSupport.getBounds((Document)doc);
        double ratioSvg = svgRect.getWidth() / svgRect.getHeight();
        if (ratioSvg > (ratioFit = (double)width / (double)height)) {
            int newHeight = (int)((double)width / ratioSvg);
            return new Dimension(width, newHeight);
        }
        int newWidth = (int)((double)height * ratioSvg);
        return new Dimension(newWidth, height);
    }

    @Override
    public InputStream getStreamByName(String strName) throws IOException {
        return new ByteArrayInputStream(this.svgData);
    }

    @Override
    public String testConnection() {
        return "";
    }

    @Override
    public String[] getSymbolNames() {
        return LEGEND_SYM_NAMES;
    }

    @Override
    public String getName() {
        return "Legend SVG Symbol Store";
    }

    @Override
    public String getDescription() {
        return "Symbol Store fore Print Legend Manager";
    }
}

