/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.plugin.print.legend.intelligence;

import com.vividsolutions.jump.workbench.model.AbstractLayerable;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.model.Layerable;
import com.vividsolutions.jump.workbench.model.RasterImageLayer;
import com.vividsolutions.jump.workbench.model.StyleCollection;
import com.vividsolutions.jump.workbench.model.Task;
import com.vividsolutions.jump.workbench.model.WMSLayer;
import com.vividsolutions.jump.workbench.ui.plugin.print.legend.LegendIO;
import com.vividsolutions.jump.workbench.ui.plugin.print.legend.intelligence.AbstractLegendEntryLayerableIntelligence;
import com.vividsolutions.jump.workbench.ui.plugin.print.legend.intelligence.LegendEntryFactory;
import com.vividsolutions.jump.workbench.ui.plugin.print.legend.model.LegendEntryLayerableModel;
import com.vividsolutions.jump.workbench.ui.plugin.print.legend.model.LegendEntryModel;
import de.riwagis.riwajump.model.intelligence.IntelligenceFactory;
import de.riwagis.riwajump.model.style.StyleModel;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics2D;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import org.apache.commons.io.IOUtils;
import org.locationtech.jts.util.Assert;

public class LegendEntryLayerableIntelligence
extends AbstractLegendEntryLayerableIntelligence<LegendEntryLayerableModel, StyleModel> {
    private LegendEntryLayerableIntelligence(LegendEntryLayerableModel model) {
        super(model);
    }

    @Override
    public StyleModel retrieveStyleModel(Task task, double scale) {
        AbstractLayerable ly = this.retrieveLayerableModel(task, scale);
        StyleCollection scol = ly.getStyleCollectionByScale(scale);
        if (scol == null) {
            return null;
        }
        Collection<StyleModel> styles = scol.getStyles();
        if (styles.isEmpty()) {
            return null;
        }
        return styles.iterator().next();
    }

    @Override
    public byte[] getSvgData2Paint() {
        byte[] svg2draw;
        block16: {
            if (this.hasSvgDataInModel()) {
                return ((LegendEntryLayerableModel)this.getModel()).getSvgData();
            }
            svg2draw = null;
            try {
                Layerable ly = (Layerable)this.retrieveLayerableModel();
                if (ly instanceof WMSLayer || ly instanceof RasterImageLayer) {
                    try (InputStream in = LegendIO.class.getResourceAsStream("raster.svg");){
                        svg2draw = IOUtils.toByteArray((InputStream)in);
                        break block16;
                    }
                }
                try (InputStream in = LegendIO.class.getResourceAsStream("vector.svg");){
                    svg2draw = IOUtils.toByteArray((InputStream)in);
                }
            }
            catch (IOException ioe) {
                Assert.shouldNeverReachHere();
            }
        }
        return svg2draw;
    }

    @Override
    public void paint(Graphics2D g, int width, Font legFont) {
        float offsetWidth = this.getOffsetWidth(legFont);
        float offsetHeight = this.getOffsetHeight(legFont);
        g.translate(offsetWidth, offsetHeight);
        Dimension dimLL = this.getLegendLabelSize(legFont);
        byte[] svgData2Paint = this.getSvgData2Paint();
        if (svgData2Paint != null) {
            this.paintSvgImage(svgData2Paint, g, dimLL.width / 2, dimLL.height / 2, dimLL.width, dimLL.height);
        }
        this.paintLegendText(g, legFont, width, offsetWidth, dimLL, offsetHeight);
        g.translate(-offsetWidth, -offsetHeight);
    }

    static {
        IntelligenceFactory.register(LegendEntryLayerableModel.class, LegendEntryLayerableIntelligence::new);
        LegendEntryFactory fac = new LegendEntryFactory(){

            @Override
            protected LegendEntryModel createModel(Object taskModel, Object context, double scale) {
                if (taskModel instanceof Layerable && !taskModel.getClass().equals(Layer.class) && context == null) {
                    return new LegendEntryLayerableModel(((Layerable)taskModel).getName(), ((Layerable)taskModel).getKey());
                }
                return null;
            }

            @Override
            protected boolean isFactoryFor(Object taskModel, Object context, double scale) {
                if (taskModel instanceof Layerable && !taskModel.getClass().equals(Layer.class) && context == null) {
                    Layerable ly = (Layerable)taskModel;
                    StyleCollection sCol = ly.getStyleCollectionByScale(scale);
                    return sCol != null;
                }
                return false;
            }
        };
        LegendEntryFactory.registerFactory(fac);
    }
}

