/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.plugin.print.legend.intelligence;

import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.model.Layerable;
import com.vividsolutions.jump.workbench.model.StyleCollection;
import com.vividsolutions.jump.workbench.model.Task;
import com.vividsolutions.jump.workbench.ui.plugin.print.legend.intelligence.AbstractLegendEntryLayerIntelligence;
import com.vividsolutions.jump.workbench.ui.plugin.print.legend.intelligence.LegendEntryFactory;
import com.vividsolutions.jump.workbench.ui.plugin.print.legend.model.LegendEntryLayerModel;
import com.vividsolutions.jump.workbench.ui.plugin.print.legend.model.LegendEntryModel;
import de.riwagis.riwajump.model.intelligence.IntelligenceFactory;
import de.riwagis.riwajump.model.style.BasicStyleModel;
import de.riwagis.riwajump.model.style.ColorThemingStyleModel;

public class LegendEntryLayerIntelligence
extends AbstractLegendEntryLayerIntelligence<LegendEntryLayerModel> {
    private LegendEntryLayerIntelligence(LegendEntryLayerModel model) {
        super(model);
    }

    @Override
    public BasicStyleModel retrieveStyleModel(Task task, double scale) {
        Layer ly = (Layer)this.retrieveLayerableModel(task, scale);
        StyleCollection scol = ly.getStyleCollectionByScale(scale);
        if (scol == null) {
            return null;
        }
        BasicStyleModel bsModel = scol.getStyle(BasicStyleModel.class);
        if (!bsModel.isEnabled()) {
            ColorThemingStyleModel ctModel = scol.getStyle(ColorThemingStyleModel.class);
            if (ctModel == null) {
                return null;
            }
            bsModel = ctModel.getDefaultStyle();
        }
        return bsModel;
    }

    static {
        IntelligenceFactory.register(LegendEntryLayerModel.class, LegendEntryLayerIntelligence::new);
        LegendEntryFactory fac = new LegendEntryFactory(){

            @Override
            protected LegendEntryModel createModel(Object taskModel, Object context, double scale) {
                if (taskModel instanceof Layer && context == null) {
                    return new LegendEntryLayerModel(((Layerable)taskModel).getName(), ((Layerable)taskModel).getKey());
                }
                return null;
            }

            @Override
            protected boolean isFactoryFor(Object taskModel, Object context, double scale) {
                if (taskModel instanceof Layer && context == null) {
                    Layer ly = (Layer)taskModel;
                    StyleCollection sCol = ly.getStyleCollectionByScale(scale);
                    if (sCol == null) {
                        return false;
                    }
                    BasicStyleModel basStyle = sCol.getStyle(BasicStyleModel.class);
                    return basStyle != null && basStyle.isEnabled();
                }
                return false;
            }
        };
        LegendEntryFactory.registerFactory(fac);
    }
}

