/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.plugin.print.legend.intelligence;

import com.vividsolutions.jump.workbench.model.Category;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.model.Layerable;
import com.vividsolutions.jump.workbench.model.StyleCollection;
import com.vividsolutions.jump.workbench.model.Task;
import com.vividsolutions.jump.workbench.ui.plugin.print.legend.intelligence.LegendEntryFactory;
import com.vividsolutions.jump.workbench.ui.plugin.print.legend.intelligence.LegendEntryIntelligence;
import com.vividsolutions.jump.workbench.ui.plugin.print.legend.model.LegendEntryHeaderModel;
import com.vividsolutions.jump.workbench.ui.plugin.print.legend.model.LegendEntryModel;
import de.riwagis.riwajump.model.intelligence.IntelligenceFactory;
import de.riwagis.riwajump.model.style.ColorThemingStyleModel;
import de.riwagis.riwajump.model.style.StyleModel;
import java.awt.Font;
import java.awt.Graphics2D;
import org.apache.commons.lang3.ObjectUtils;

public class LegendEntryHeaderIntelligence
extends LegendEntryIntelligence<LegendEntryHeaderModel, Object, StyleModel> {
    private LegendEntryHeaderIntelligence(LegendEntryHeaderModel model) {
        super(model);
    }

    @Override
    public Object retrieveLayerableModel(Task task, double scale) {
        return null;
    }

    @Override
    public StyleModel retrieveStyleModel(Task task, double scale) {
        return null;
    }

    @Override
    public boolean isVisible(Task task, double scale) {
        return true;
    }

    @Override
    protected float getOffsetWidth(Font legFont) {
        return legFont.getSize2D() / 2.0f;
    }

    @Override
    protected float getOffsetHeight(Font legFont) {
        return legFont.getSize2D() / 4.0f;
    }

    @Override
    protected float getFontSize(Font legFont) {
        if (((LegendEntryHeaderModel)this.getModel()).getLevel() == 1) {
            return legFont.getSize2D() + legFont.getSize2D() / 8.0f;
        }
        return legFont.getSize2D() + legFont.getSize2D() / 14.0f;
    }

    @Override
    public int getHeight4Width(Graphics2D g, int width, Font legFont) {
        int offsetWidthX2 = (int)(this.getOffsetWidth(legFont) * 2.0f);
        int offsetHeightX2 = (int)(this.getOffsetHeight(legFont) * 2.0f);
        return this.getHeight4WidthLabel(g, width - offsetWidthX2, legFont) + offsetHeightX2;
    }

    @Override
    public void paint(Graphics2D g, int width, Font legFont) {
        g.setFont(this.getFont4Paint(legFont));
        float offsetWidth = this.getOffsetWidth(legFont);
        float offsetHeight = this.getOffsetHeight(legFont);
        String[] rows = this.getLabelRows(g, width - (int)(2.0f * offsetWidth), legFont);
        int height = g.getFontMetrics().getHeight();
        int ascent = g.getFontMetrics().getAscent();
        for (int i = 0; i < rows.length; ++i) {
            g.drawString(rows[i], offsetWidth, (float)(i * height + ascent) + offsetHeight);
        }
    }

    static {
        IntelligenceFactory.register(LegendEntryHeaderModel.class, LegendEntryHeaderIntelligence::new);
        LegendEntryFactory fac = new LegendEntryFactory(){

            private void getCategoryName(Category cat, StringBuilder sb) {
                if (cat.getParentCategory().getParentCategory() != null) {
                    this.getCategoryName(cat.getParentCategory(), sb);
                }
                if (sb.length() > 0) {
                    sb.append(" - ");
                }
                sb.append(cat.getName());
            }

            @Override
            protected LegendEntryModel createModel(Object taskModel, Object context, double scale) {
                if (taskModel instanceof Layer && context == null) {
                    return new LegendEntryHeaderModel(((Layerable)taskModel).getName(), 2);
                }
                if (taskModel instanceof Category) {
                    StringBuilder sbCatName = new StringBuilder();
                    this.getCategoryName((Category)taskModel, sbCatName);
                    return new LegendEntryHeaderModel(sbCatName.toString(), 1);
                }
                if (taskModel instanceof String) {
                    return new LegendEntryHeaderModel(ObjectUtils.toString((Object)taskModel), 1);
                }
                return null;
            }

            @Override
            protected boolean isFactoryFor(Object taskModel, Object context, double scale) {
                if (taskModel instanceof Category) {
                    return true;
                }
                if (taskModel instanceof String) {
                    return true;
                }
                if (taskModel instanceof Layer && context == null) {
                    Layer ly = (Layer)taskModel;
                    StyleCollection sCol = ly.getStyleCollectionByScale(scale);
                    if (sCol == null) {
                        return false;
                    }
                    ColorThemingStyleModel thStyle = sCol.getStyle(ColorThemingStyleModel.class);
                    return thStyle != null && thStyle.isEnabled();
                }
                return false;
            }
        };
        LegendEntryFactory.registerFactory(fac);
    }
}

