/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.plugin.print.legend.intelligence;

import com.vividsolutions.jump.workbench.model.AbstractLayerable;
import com.vividsolutions.jump.workbench.model.StyleCollection;
import com.vividsolutions.jump.workbench.model.Task;
import com.vividsolutions.jump.workbench.ui.plugin.print.legend.intelligence.LegendEntryIntelligence;
import com.vividsolutions.jump.workbench.ui.plugin.print.legend.intelligence.LegendSvgSymbolStore;
import com.vividsolutions.jump.workbench.ui.plugin.print.legend.model.AbstractLegendEntryLayerableModel;
import de.riwagis.riwajump.model.style.StyleModel;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics2D;
import java.io.IOException;

public abstract class AbstractLegendEntryLayerableIntelligence<LM extends AbstractLegendEntryLayerableModel, SM extends StyleModel>
extends LegendEntryIntelligence<LM, AbstractLayerable, SM> {
    protected AbstractLegendEntryLayerableIntelligence(LM model) {
        super(model);
    }

    @Override
    public AbstractLayerable retrieveLayerableModel(Task task, double scale) {
        AbstractLegendEntryLayerableModel legModel = (AbstractLegendEntryLayerableModel)this.getModel();
        return (AbstractLayerable)task.getLayerManager().getLayerableByKey(legModel.getLayerId());
    }

    @Override
    public boolean isVisible(Task task, double scale) {
        AbstractLayerable ly = this.retrieveLayerableModel(task, scale);
        if (ly != null && ly.isVisible() && ly.getCategory().isVisibleOnScreen()) {
            return this.retrieveStyleModel(task, scale) != null;
        }
        return false;
    }

    @Override
    protected float getOffsetWidth(Font legFont) {
        return legFont.getSize2D() / 2.0f;
    }

    @Override
    protected float getOffsetHeight(Font legFont) {
        return legFont.getSize2D() / 5.0f;
    }

    protected StyleCollection retrieveStyleCollection() {
        return ((AbstractLayerable)this.retrieveLayerableModel()).getStyleCollectionByScale(this.getRenderScale());
    }

    protected Dimension getLegendLabelSize(Font legFont) {
        int fontSize = legFont.getSize();
        return new Dimension((int)((double)fontSize * 3.5), (int)((double)fontSize * 1.8));
    }

    @Override
    protected float getFontSize(Font legFont) {
        return legFont.getSize2D();
    }

    @Override
    public int getHeight4Width(Graphics2D g, int width, Font legFont) {
        int offsetWidthX2 = (int)(this.getOffsetWidth(legFont) * 2.0f);
        int offsetHeightX2 = (int)(this.getOffsetHeight(legFont) * 2.0f);
        Dimension dimLL = this.getLegendLabelSize(legFont);
        int widthLabelAndText = width - offsetWidthX2;
        int widthText = widthLabelAndText - (dimLL.width + (int)this.getOffsetWidth(legFont));
        int labelHeight = this.getHeight4WidthLabel(g, widthText, legFont) + offsetHeightX2;
        return Math.max(labelHeight, dimLL.height + offsetHeightX2);
    }

    public byte[] getSvgData2Paint() {
        return ((AbstractLegendEntryLayerableModel)this.getModel()).getSvgData();
    }

    public boolean hasSvgDataInModel() {
        return ((AbstractLegendEntryLayerableModel)this.getModel()).getSvgData() != null;
    }

    public void paintSvgImage(byte[] svgData2Paint, Graphics2D g2d, int left, int top, int width, int height) {
        try {
            if (svgData2Paint == null) {
                return;
            }
            LegendSvgSymbolStore legSymStore = new LegendSvgSymbolStore(svgData2Paint);
            legSymStore.renderLegendSymbol(g2d, left, top, width, height);
        }
        catch (IOException ioe) {
            throw new RuntimeException(String.format("Error rendering svg legend image for layer: %s", ((AbstractLegendEntryLayerableModel)this.getModel()).getLayerId()), ioe);
        }
    }

    protected void paintLegendText(Graphics2D g, Font legFont, int width, float offsetWidth, Dimension dimLL, float offsetHeight) {
        g.setColor(Color.BLACK);
        g.setFont(this.getFont4Paint(legFont));
        int widthLabelAndText = width - (int)(2.0f * offsetWidth);
        int widthText = widthLabelAndText - (dimLL.width + (int)this.getOffsetWidth(legFont));
        String[] rows = this.getLabelRows(g, widthText, legFont);
        int height = g.getFontMetrics().getHeight();
        int ascent = g.getFontMetrics().getAscent();
        for (int i = 0; i < rows.length; ++i) {
            g.drawString(rows[i], (float)dimLL.width + offsetWidth, (float)(i * height + ascent));
        }
    }
}

