/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.plugin.print.legend;

import com.vividsolutions.jump.workbench.model.Category;
import com.vividsolutions.jump.workbench.model.Layerable;
import com.vividsolutions.jump.workbench.model.WithScale;
import com.vividsolutions.jump.workbench.ui.layertree.sublayervalues.ColorThemingValue;
import com.vividsolutions.jump.workbench.ui.plugin.print.legend.LegendTransferable;
import com.vividsolutions.jump.workbench.ui.plugin.print.legend.intelligence.LegendEntryFactory;
import com.vividsolutions.jump.workbench.ui.plugin.print.legend.model.LegendEntryModel;
import java.awt.datatransfer.Transferable;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.TransferHandler;
import javax.swing.tree.TreePath;

public class LegendTreeTransferHandler
extends TransferHandler {
    private final WithScale withScale;

    LegendTreeTransferHandler(WithScale dlg) {
        this.withScale = dlg;
    }

    public static final List<LegendEntryModel> createTransferData(JTree lyTree, WithScale withScale) {
        ArrayList<LegendEntryModel> lstEntries = new ArrayList<LegendEntryModel>();
        TreePath[] arrTreeSelection = lyTree.getSelectionPaths();
        if (arrTreeSelection != null) {
            for (TreePath path : arrTreeSelection) {
                LegendEntryModel legModel;
                Object obj = path.getLastPathComponent();
                if (!(obj instanceof Category) && !(obj instanceof Layerable) && !(obj instanceof ColorThemingValue) || (legModel = LegendEntryFactory.createLegendModel(obj, null, withScale.getScale())) == null) continue;
                lstEntries.add(legModel);
            }
        }
        return lstEntries;
    }

    @Override
    protected void exportDone(JComponent source, Transferable data, int action) {
    }

    @Override
    protected Transferable createTransferable(JComponent c) {
        List<LegendEntryModel> lstEntries = new ArrayList<LegendEntryModel>();
        if (c instanceof JTree) {
            JTree lyTree = (JTree)c;
            lstEntries = LegendTreeTransferHandler.createTransferData(lyTree, this.withScale);
        }
        return new LegendTransferable(lstEntries);
    }

    @Override
    public int getSourceActions(JComponent c) {
        return 1;
    }
}

