/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.plugin.print.legend;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.task.LayerView;
import com.vividsolutions.jump.workbench.ui.Viewport;
import com.vividsolutions.jump.workbench.ui.plugin.print.PrintDraft;
import com.vividsolutions.jump.workbench.ui.plugin.print.legend.intelligence.LegendEntryIntelligence;
import com.vividsolutions.jump.workbench.ui.plugin.print.legend.model.LegendEntryHeaderModel;
import com.vividsolutions.jump.workbench.ui.plugin.print.legend.model.LegendEntryModel;
import com.vividsolutions.jump.workbench.ui.plugin.print.legend.model.LegendModel;
import de.riwagis.riwajump.model.style.StyleModel;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.geom.Dimension2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRRenderable;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.type.ImageTypeEnum;
import net.sf.jasperreports.renderers.AbstractRenderToImageDataRenderer;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LegendRenderer
extends AbstractRenderToImageDataRenderer
implements JRRenderable {
    private static final Logger LOG = LoggerFactory.getLogger(LegendRenderer.class);
    private static final int DEFAULT_VALUE_COLUMNS = 1;
    private static final String PARAM_NAME_COLUMNS = "columns";
    private static final String DEFAULT_VALUE_FONTNAME = "SansSerif";
    private static final String PARAM_NAME_FONTNAME = "fontname";
    private static final int DEFAULT_VALUE_FONTSIZE = 11;
    private static final String PARAM_NAME_FONTSIZE = "fontsize";
    private static final boolean DEFAULT_VALUE_STARTONTOP = true;
    private static final String PARAM_NAME_STARTONTOP = "startontop";
    private static final boolean DEFAULT_VALUE_GROWWITHSIZE = true;
    private static final String PARAM_NAME_GROWWITHSIZE = "growwithsize";
    private final LayerView lv;
    private final PrintDraft draft;
    private final LegendModel legend;
    private final double scale;
    private boolean exceptionOnError = false;

    public LegendRenderer(LayerView _lv, PrintDraft draft, LegendModel legend, double scale) {
        this.lv = _lv;
        this.legend = legend;
        this.draft = draft;
        this.scale = scale;
    }

    private Map<String, String> getLegParams() {
        Map<String, String> mapLegParams = this.draft.getMapParameters().get("MAP_LEGEND");
        if (mapLegParams == null) {
            return new HashMap<String, String>();
        }
        return mapLegParams;
    }

    private boolean getLegendParameter(String paramName, boolean defaultValue) {
        boolean param = defaultValue;
        String paramValue = this.getLegParams().get(paramName);
        if (!StringUtils.isEmpty((CharSequence)paramValue)) {
            param = Boolean.parseBoolean(paramValue);
        }
        return param;
    }

    private int getLegendParameter(String paramName, int defaultValue) {
        int param = defaultValue;
        String paramValue = this.getLegParams().get(paramName);
        if (!StringUtils.isEmpty((CharSequence)paramValue)) {
            try {
                param = Integer.parseInt(paramValue);
            }
            catch (NumberFormatException nfe) {
                LOG.error(String.format("Error reading parameter %s for legend from draft %s. Using default value: %s.", paramName, this.draft.getOriginalReportFile().getAbsolutePath(), defaultValue), (Throwable)nfe);
            }
        }
        return param;
    }

    private String getLegendParameter(String paramName, String defaultValue) {
        if (this.getLegParams().containsKey(paramName)) {
            String paramValue = this.getLegParams().get(paramName);
            return ObjectUtils.toString((Object)paramValue);
        }
        return defaultValue;
    }

    public void setExceptionOnError(boolean b) {
        this.exceptionOnError = b;
    }

    public boolean getExceptionOnError() {
        return this.exceptionOnError;
    }

    public byte getType() {
        return 1;
    }

    public byte getImageType() {
        return ImageTypeEnum.UNKNOWN.getValue();
    }

    public Dimension2D getDimension() throws JRException {
        return null;
    }

    public byte[] getImageData() throws JRException {
        return new byte[0];
    }

    public void render(Graphics2D grx, Rectangle2D rectangle) throws JRException {
        int colIndex;
        grx.setRenderingHint(Viewport.KEY_IS4PRINT, Viewport.VALUE_IS4PRINT);
        AffineTransform origTrans = grx.getTransform();
        int printWidth = (int)rectangle.getWidth();
        int printHeight = (int)rectangle.getHeight();
        int columns = this.getLegendParameter(PARAM_NAME_COLUMNS, 1);
        boolean startontop = this.getLegendParameter(PARAM_NAME_STARTONTOP, true);
        boolean growwithsize = this.getLegendParameter(PARAM_NAME_GROWWITHSIZE, true);
        if (columns > 1) {
            startontop = true;
            growwithsize = false;
        }
        int colWidth = printWidth / columns;
        List<LegendEntryModel> legEntries = this.legend.getEntries();
        ArrayList<LegendEntryModel> legEntries2Render = new ArrayList<LegendEntryModel>();
        for (int i = 0; i < legEntries.size(); ++i) {
            LegendEntryModel legModel = legEntries.get(i);
            if (legModel instanceof LegendEntryHeaderModel) {
                LegendEntryHeaderModel legHeaderModel = (LegendEntryHeaderModel)legModel;
                if (!this.drawHeader(legHeaderModel, legEntries)) continue;
                legEntries2Render.add(legModel);
                continue;
            }
            if (this.retrieveStyleModel(legModel) == null) continue;
            legEntries2Render.add(legModel);
        }
        if (legEntries2Render.isEmpty()) {
            return;
        }
        int fontsize = this.getLegendParameter(PARAM_NAME_FONTSIZE, 11);
        String fontname = this.getLegendParameter(PARAM_NAME_FONTNAME, DEFAULT_VALUE_FONTNAME);
        Font legFont = new Font(fontname, 0, fontsize);
        boolean heightOK = false;
        double scaleX = grx.getTransform().getScaleX();
        HashMap<LegendEntryModel, Integer> heightCache = new HashMap<LegendEntryModel, Integer>();
        int sumHeight = 0;
        while (!heightOK) {
            sumHeight = 0;
            colIndex = 0;
            heightCache.clear();
            if (scaleX < 0.5) {
                grx.setTransform(origTrans);
                int textWidth = grx.getFontMetrics().stringWidth(I18N.get("ui.plugin.print.legend.LegendRenderer.area-too-small"));
                int textHeight = grx.getFontMetrics().getHeight();
                double newScale = (double)printWidth / (double)textWidth;
                grx.scale(newScale, newScale);
                grx.setColor(Color.white);
                grx.fillRect(0, 0, textWidth, textHeight);
                grx.setColor(Color.black);
                grx.drawString(I18N.get("ui.plugin.print.legend.LegendRenderer.area-too-small"), 0, (int)((double)textHeight * newScale));
                return;
            }
            for (LegendEntryModel legEntry : legEntries2Render) {
                LegendEntryIntelligence legEntryIntelligence = (LegendEntryIntelligence)legEntry.getIntelligence();
                legEntryIntelligence.setRenderTask(this.lv.getLayerManager().getTask());
                legEntryIntelligence.setRenderScale(this.scale);
                int entryHeight = legEntryIntelligence.getHeight4Width(grx, (int)((double)colWidth / scaleX), legFont);
                heightCache.put(legEntry, entryHeight);
                if (!((double)(sumHeight += entryHeight) > (double)printHeight / scaleX)) continue;
                if (++colIndex > columns - 1) break;
                sumHeight = entryHeight;
            }
            if ((double)sumHeight <= (double)printHeight / scaleX) {
                heightOK = true;
                continue;
            }
            grx.scale(0.95, 0.95);
            scaleX = grx.getTransform().getScaleX();
        }
        AffineTransform transformation4Paint = grx.getTransform();
        grx.setTransform(origTrans);
        int topRect = 0;
        int topLegend = 0;
        if (!startontop) {
            topLegend = printHeight - (int)((double)sumHeight * scaleX);
            if (growwithsize && scaleX == 1.0) {
                topRect = topLegend;
            }
        }
        int height = printHeight;
        if (growwithsize && scaleX == 1.0) {
            height = sumHeight;
        }
        grx.setStroke(new BasicStroke(0.5f));
        grx.setColor(Color.white);
        grx.fillRect(0, topRect, printWidth, height);
        grx.setColor(Color.black);
        grx.drawRect(0, topRect, printWidth, height);
        if (columns > 1) {
            for (int i = 1; i < columns; ++i) {
                int x = i * colWidth;
                grx.drawLine(x, 10, x, printHeight - 10);
            }
        }
        grx.setTransform(transformation4Paint);
        grx.translate(0, topLegend);
        sumHeight = 0;
        colIndex = 0;
        for (LegendEntryModel legEntry : legEntries2Render) {
            LegendEntryIntelligence legEntryIntelligence = (LegendEntryIntelligence)legEntry.getIntelligence();
            legEntryIntelligence.setRenderTask(this.lv.getLayerManager().getTask());
            legEntryIntelligence.setRenderScale(this.scale);
            int entryHeight = (Integer)heightCache.get((Object)legEntry);
            boolean changeColumn = this.isColumnChangeUseful(legEntry, legEntries2Render, heightCache, colIndex, sumHeight += entryHeight, columns, printHeight, scaleX);
            if ((double)sumHeight > (double)printHeight / scaleX || changeColumn) {
                sumHeight = entryHeight;
                grx.translate((double)colWidth / scaleX, -grx.getTransform().getTranslateY() / scaleX);
                ++colIndex;
            }
            legEntryIntelligence.paint(grx, (int)((double)colWidth / scaleX), legFont);
            grx.translate(0, entryHeight);
        }
        grx.setTransform(origTrans);
    }

    public Dimension2D getDimension(JasperReportsContext jasperReportsContext) throws JRException {
        return this.getDimension();
    }

    private StyleModel retrieveStyleModel(LegendEntryModel legModel) {
        LegendEntryIntelligence legIntelligence = (LegendEntryIntelligence)legModel.getIntelligence();
        if (legIntelligence.isVisible(this.lv.getLayerManager().getTask(), this.scale)) {
            return legIntelligence.retrieveStyleModel(this.lv.getLayerManager().getTask(), this.scale);
        }
        return null;
    }

    private boolean drawHeader(LegendEntryHeaderModel legHeaderModel, List<LegendEntryModel> legEntries) {
        int startIndex;
        if (legHeaderModel.isDisplayWhenNoChilds()) {
            return true;
        }
        for (int j = startIndex = legEntries.indexOf((Object)legHeaderModel) + 1; j < legEntries.size(); ++j) {
            LegendEntryModel legModelInner = legEntries.get(j);
            if (legModelInner instanceof LegendEntryHeaderModel) {
                LegendEntryHeaderModel legHeaderModelInner = (LegendEntryHeaderModel)legModelInner;
                if (legHeaderModelInner.getLevel() <= legHeaderModel.getLevel()) break;
                if (!legHeaderModelInner.isDisplayWhenNoChilds()) continue;
                return true;
            }
            if (this.retrieveStyleModel(legModelInner) == null) continue;
            return true;
        }
        return false;
    }

    public void render(JasperReportsContext jasperReportsContext, Graphics2D grx, Rectangle2D rectangle) throws JRException {
        this.render(grx, rectangle);
    }

    private boolean isColumnChangeUseful(LegendEntryModel legEntry2Check, List<LegendEntryModel> legEntries2Render, Map<LegendEntryModel, Integer> heightCache, int colIndex, int sumHeight, int columns, int printHeight, double scaleX) {
        if (legEntry2Check instanceof LegendEntryHeaderModel && columns > 1 && colIndex != columns - 1) {
            LegendEntryHeaderModel legEntryHeader = (LegendEntryHeaderModel)legEntry2Check;
            if ((double)sumHeight > (double)printHeight / scaleX * 0.5) {
                LegendEntryHeaderModel legEntrySubHeader;
                LegendEntryModel legEntry;
                int headerLevel = legEntryHeader.getLevel();
                int index2start = legEntries2Render.indexOf((Object)legEntry2Check);
                int headerRegionSize = heightCache.get((Object)legEntry2Check);
                for (int i = index2start; !(i >= legEntries2Render.size() || (legEntry = legEntries2Render.get(i)) instanceof LegendEntryHeaderModel && i != index2start && (legEntrySubHeader = (LegendEntryHeaderModel)legEntry).getLevel() <= headerLevel); ++i) {
                    headerRegionSize += heightCache.get((Object)legEntry2Check).intValue();
                }
                if ((double)(sumHeight + headerRegionSize) < (double)printHeight / scaleX) {
                    return false;
                }
                ++colIndex;
                int sumHeight4Check = 0;
                for (int i = index2start; i < legEntries2Render.size(); ++i) {
                    LegendEntryModel legEntry2 = legEntries2Render.get(i);
                    int entryHeight = heightCache.get((Object)legEntry2);
                    if (!((double)(sumHeight4Check += entryHeight) > (double)printHeight / scaleX)) continue;
                    sumHeight4Check = entryHeight;
                    ++colIndex;
                }
                return colIndex < columns;
            }
        }
        return false;
    }
}

