/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.plugin.print.legend;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.model.Category;
import com.vividsolutions.jump.workbench.model.Layerable;
import com.vividsolutions.jump.workbench.model.Task;
import com.vividsolutions.jump.workbench.model.WithScale;
import com.vividsolutions.jump.workbench.plugin.EnableCheck;
import com.vividsolutions.jump.workbench.ui.MultiInputDialog;
import com.vividsolutions.jump.workbench.ui.layertree.FirableTreeModelWrapper;
import com.vividsolutions.jump.workbench.ui.layertree.LayerTree;
import com.vividsolutions.jump.workbench.ui.layertree.LayerTreeCellRenderer;
import com.vividsolutions.jump.workbench.ui.layertree.LayerTreeModel;
import com.vividsolutions.jump.workbench.ui.layertree.LayerTreeModelFilter;
import com.vividsolutions.jump.workbench.ui.plugin.PersistentBlackboardPlugIn;
import com.vividsolutions.jump.workbench.ui.plugin.print.legend.EditLayerableEntryDialog;
import com.vividsolutions.jump.workbench.ui.plugin.print.legend.LegendEntryListCellRenderer;
import com.vividsolutions.jump.workbench.ui.plugin.print.legend.LegendIO;
import com.vividsolutions.jump.workbench.ui.plugin.print.legend.LegendListTransferHandler;
import com.vividsolutions.jump.workbench.ui.plugin.print.legend.LegendModelComboBoxEditor;
import com.vividsolutions.jump.workbench.ui.plugin.print.legend.LegendModelListCellRenderer;
import com.vividsolutions.jump.workbench.ui.plugin.print.legend.LegendTreeTransferHandler;
import com.vividsolutions.jump.workbench.ui.plugin.print.legend.model.AbstractLegendEntryLayerableModel;
import com.vividsolutions.jump.workbench.ui.plugin.print.legend.model.LegendEntryHeaderModel;
import com.vividsolutions.jump.workbench.ui.plugin.print.legend.model.LegendEntryModel;
import com.vividsolutions.jump.workbench.ui.plugin.print.legend.model.LegendModel;
import de.riwagis.icons.IconLoader;
import de.riwagis.util.file.FileSupport;
import de.riwagis.util.gui.ExceptionDialog;
import de.riwagis.util.gui.GUISupport;
import de.riwagis.util.gui.models.ListComboBoxModel;
import de.riwagis.util.gui.models.ListListModel;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DropMode;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.ListModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TreeModelEvent;
import javax.swing.filechooser.FileFilter;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LegendManagerDialog
extends JDialog
implements WithScale {
    private static final Logger LOG = LoggerFactory.getLogger(LegendManagerDialog.class);
    private static final String LAST_EXPORT_IMPORT_FILE_BLACKBOARD_KEY = LegendManagerDialog.class.getName() + "_LAST_EXPORT_IMPORT_DIR";
    private LegendModel leg = null;
    private final Task task;
    private final LayerTreeModel treeModel;
    private double scale = 1000.0;
    private boolean legendModified = false;
    private boolean blockCmbLegendEvent = false;
    private final NumberFormat df = new DecimalFormat();
    private final NumberFormat nf = NumberFormat.getIntegerInstance();
    private final LayerTreeModelFilter treeFilter = new LayerTreeModelFilter(){

        @Override
        public boolean doDisplay(Object element) {
            if (LegendManagerDialog.this.cboVisibleLayers.isSelected()) {
                if (element instanceof Category) {
                    Category cat = (Category)element;
                    if (!cat.isVisible()) {
                        return false;
                    }
                    for (Layerable ly : cat.getAllLayerables()) {
                        if (!ly.isVisible()) continue;
                        return true;
                    }
                    return false;
                }
                if (element instanceof Layerable) {
                    Layerable ly = (Layerable)element;
                    return ly.isVisible();
                }
            }
            return true;
        }
    };
    private JButton butAddLegend;
    private JButton butAddToLegend;
    private JButton butClose;
    private JButton butCopyLegend;
    private JButton butCreateHeader;
    private JButton butDeleteLegend;
    private JButton butDownInLegend;
    private JButton butEditEntry;
    private JButton butExportLegend;
    private JButton butImportLegend;
    private JButton butRemoveEntry;
    private JButton butRenameLegend;
    private JButton butSave;
    private JButton butUpInLegend;
    private JCheckBox cboVisibleLayers;
    private JComboBox<LegendModel> cmbLegendList;
    private JComboBox<String> cmbScale;
    private JSeparator jSeparator1;
    private JToolBar.Separator jSeparator2;
    private JToolBar.Separator jSeparator3;
    private JToolBar.Separator jSeparator4;
    private JLabel lblLegendList;
    private JLabel lblScale;
    private JList<LegendEntryModel> lstLegend;
    private JPanel pnlLegendList;
    private JPanel pnlSaveClose;
    private JPanel pnlScale;
    private JScrollPane scpLayer;
    private JScrollPane scpLegend;
    private JSeparator sep1;
    private JToolBar tbaLegend;
    private JToolBar tbaLegendManager;
    private JTree treeLayer;

    public LegendManagerDialog(Frame parent) {
        this(parent, (Task)null);
    }

    public LegendManagerDialog(Frame parent, Task task) {
        super(parent, true);
        this.task = task;
        this.treeModel = new LayerTreeModel(this.task);
        this.treeModel.addListFilter(this.treeFilter);
        this.treeModel.setWithScale(this);
        this.initComponents();
        this.setSize(500, 600);
        GUISupport.centreOnScreen((Component)this);
        this.i18n();
        this.init();
    }

    @Override
    public int getScaleType() {
        return 1;
    }

    @Override
    public double getScale() {
        return this.scale;
    }

    public void setScale(double scale) {
        this.scale = scale;
        this.updateControls(false);
    }

    private void i18n() {
        this.setTitle(I18N.get("ui.plugin.print.legend.LegendManagerDialog.title"));
        this.lblLegendList.setText(I18N.get("ui.plugin.print.legend.LegendManagerDialog.legend"));
        this.cboVisibleLayers.setText(I18N.get("ui.plugin.print.legend.LegendManagerDialog.visible"));
        this.butClose.setText(I18N.get("common.close"));
        this.butSave.setText(I18N.get("common.save"));
        this.butAddLegend.setIcon(IconLoader.svgIcon((String)"common_add.svg"));
        this.butAddLegend.setText("");
        this.butAddLegend.setToolTipText(I18N.get("ui.plugin.print.legend.LegendManagerDialog.add-legend"));
        this.butAddLegend.setMargin(new Insets(0, 0, 0, 0));
        this.butRenameLegend.setIcon(IconLoader.svgIcon((String)"common_edit.svg"));
        this.butRenameLegend.setText("");
        this.butRenameLegend.setToolTipText(I18N.get("ui.plugin.print.legend.LegendManagerDialog.rename-legend"));
        this.butRenameLegend.setMargin(new Insets(0, 0, 0, 0));
        this.butDeleteLegend.setIcon(IconLoader.svgIcon((String)"common_delete.svg"));
        this.butDeleteLegend.setText("");
        this.butDeleteLegend.setToolTipText(I18N.get("ui.plugin.print.legend.LegendManagerDialog.delete-legend"));
        this.butDeleteLegend.setMargin(new Insets(0, 0, 0, 0));
        this.butExportLegend.setIcon(IconLoader.svgIcon((String)"legend_export.svg"));
        this.butExportLegend.setText("");
        this.butExportLegend.setToolTipText(I18N.get("ui.plugin.print.legend.LegendManagerDialog.export-legend"));
        this.butExportLegend.setMargin(new Insets(0, 0, 0, 0));
        this.butImportLegend.setIcon(IconLoader.svgIcon((String)"legend_import.svg"));
        this.butImportLegend.setText("");
        this.butImportLegend.setToolTipText(I18N.get("ui.plugin.print.legend.LegendManagerDialog.import-legend"));
        this.butImportLegend.setMargin(new Insets(0, 0, 0, 0));
        this.butCopyLegend.setIcon(IconLoader.svgIcon((String)"common_copy.svg"));
        this.butCopyLegend.setText("");
        this.butCopyLegend.setToolTipText(I18N.get("ui.plugin.print.legend.LegendManagerDialog.copy-legend"));
        this.butCopyLegend.setMargin(new Insets(0, 0, 0, 0));
        this.butCreateHeader.setIcon(IconLoader.svgIcon((String)"common_add.svg"));
        this.butCreateHeader.setText("");
        this.butCreateHeader.setToolTipText(I18N.get("ui.plugin.print.legend.LegendManagerDialog.create-header"));
        this.butCreateHeader.setMargin(new Insets(0, 0, 0, 0));
        this.butEditEntry.setIcon(IconLoader.svgIcon((String)"common_edit.svg"));
        this.butEditEntry.setText("");
        this.butEditEntry.setToolTipText(I18N.get("ui.plugin.print.legend.LegendManagerDialog.edit-legend-entry"));
        this.butEditEntry.setMargin(new Insets(0, 0, 0, 0));
        this.butRemoveEntry.setIcon(IconLoader.svgIcon((String)"common_delete.svg"));
        this.butRemoveEntry.setText("");
        this.butRemoveEntry.setToolTipText(I18N.get("ui.plugin.print.legend.LegendManagerDialog.remove-legend-entry"));
        this.butRemoveEntry.setMargin(new Insets(0, 0, 0, 0));
        this.butAddToLegend.setText("");
        this.butAddToLegend.setMargin(new Insets(0, 0, 0, 0));
        this.butAddToLegend.setIcon(IconLoader.svgIconSmall((String)"show_next.svg"));
        this.butUpInLegend.setText("");
        this.butUpInLegend.setMargin(new Insets(0, 0, 0, 0));
        this.butUpInLegend.setIcon(IconLoader.svgIconSmall((String)"common_triangle_up.svg"));
        this.butDownInLegend.setText("");
        this.butDownInLegend.setMargin(new Insets(0, 0, 0, 0));
        this.butDownInLegend.setIcon(IconLoader.svgIconSmall((String)"common_triangle_down.svg"));
    }

    private void init() {
        this.cmbLegendList.setRenderer(new LegendModelListCellRenderer());
        this.cmbLegendList.setEditor(new LegendModelComboBoxEditor());
        this.cmbLegendList.setEditable(true);
        this.lstLegend.setCellRenderer(new LegendEntryListCellRenderer(this.task, this));
        this.refillLegendList();
        LayerTreeCellRenderer renderer = (LayerTreeCellRenderer)this.treeLayer.getCellRenderer();
        renderer.setWithScale(this);
        this.scpLayer.getVerticalScrollBar().setUnitIncrement(20);
        this.treeLayer.setShowsRootHandles(true);
        this.treeLayer.setTransferHandler(new LegendTreeTransferHandler(this));
        this.lstLegend.setTransferHandler(new LegendListTransferHandler());
    }

    private void updateTree() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                FirableTreeModelWrapper model = (FirableTreeModelWrapper)LegendManagerDialog.this.treeLayer.getModel();
                TreeModelEvent structureChangedEvent = new TreeModelEvent((Object)this, new Object[]{model.getRoot()});
                model.fireTreeStructureChanged(structureChangedEvent);
            }
        });
        this.lstLegend.setCellRenderer(new LegendEntryListCellRenderer(this.task, this));
    }

    private void updateLegendList(boolean reinitRenderer) {
        this.refillLegendEntries();
        if (reinitRenderer) {
            this.lstLegend.setCellRenderer(new LegendEntryListCellRenderer(this.task, this));
        }
    }

    private void saveLegend() {
        if (this.leg.isBuildIn()) {
            throw new RuntimeException("Legend is buildIn and can not be saved. Should never reach here.");
        }
        this.leg.setEntries(this.getLstLegendModel().getList());
        LegendIO.getInstance().saveUserLegends();
        this.legendModified = false;
    }

    private boolean checkSaveLegend() {
        if (this.legendModified && this.leg != null && !this.leg.isBuildIn() && this.cmbLegendList.getItemCount() > 0) {
            int option = JOptionPane.showConfirmDialog(this, I18N.getMessage("ui.plugin.print.legend.LegendManagerDialog.save-legend-question", this.leg.getName()), I18N.get("ui.plugin.print.legend.LegendManagerDialog.save-legend-title"), 1);
            switch (option) {
                case 0: {
                    this.saveLegend();
                    return true;
                }
                case 1: {
                    return true;
                }
            }
            return false;
        }
        return true;
    }

    private void refillLegendList() {
        LegendIO legIO = LegendIO.getInstance();
        List<LegendModel> lstLegends = legIO.getUserLegends();
        if (lstLegends.isEmpty()) {
            LegendModel newLeg = new LegendModel(I18N.get("ui.plugin.print.legend.LegendManagerDialog.new-legend"));
            legIO.addUserLegend(newLeg);
            lstLegends = legIO.getUserLegends();
        }
        ListComboBoxModel cmbLegendModel = new ListComboBoxModel(lstLegends, false, null);
        this.cmbLegendList.setModel((ComboBoxModel<LegendModel>)cmbLegendModel);
        if (this.cmbLegendList.getItemCount() > 0) {
            this.setLegendModelSelected(lstLegends.get(0));
            this.leg = (LegendModel)this.cmbLegendList.getSelectedItem();
        }
        this.refillLegendEntries();
        this.legendModified = false;
    }

    private void refillLegendEntries() {
        if (this.leg == null) {
            return;
        }
        ListListModel<LegendEntryModel> lstLegendModel = new ListListModel<LegendEntryModel>(this.leg.getEntries()){

            public void removeListObject(LegendEntryModel obj) {
                if (LegendManagerDialog.this.leg == null || LegendManagerDialog.this.leg.isBuildIn()) {
                    throw new RuntimeException("Legend can not be modified.");
                }
                super.removeListObject((Object)obj);
            }

            public void replaceListObject(LegendEntryModel oldObj, LegendEntryModel newObj) {
                if (LegendManagerDialog.this.leg == null || LegendManagerDialog.this.leg.isBuildIn()) {
                    throw new RuntimeException("Legend can not be modified.");
                }
                super.replaceListObject((Object)oldObj, (Object)newObj);
            }

            public void addListObject(LegendEntryModel obj) {
                if (LegendManagerDialog.this.leg == null || LegendManagerDialog.this.leg.isBuildIn()) {
                    throw new RuntimeException("Legend can not be modified.");
                }
                super.addListObject((Object)obj);
            }

            public void addListObject(LegendEntryModel obj, int index) {
                if (LegendManagerDialog.this.leg == null || LegendManagerDialog.this.leg.isBuildIn()) {
                    throw new RuntimeException("Legend can not be modified.");
                }
                super.addListObject((Object)obj, index);
            }
        };
        lstLegendModel.addListDataListener(new ListDataListener(){

            @Override
            public void intervalAdded(ListDataEvent e) {
                LegendManagerDialog.this.legendModified = true;
            }

            @Override
            public void intervalRemoved(ListDataEvent e) {
                LegendManagerDialog.this.legendModified = true;
            }

            @Override
            public void contentsChanged(ListDataEvent e) {
                LegendManagerDialog.this.legendModified = true;
            }
        });
        this.lstLegend.setModel((ListModel<LegendEntryModel>)lstLegendModel);
    }

    public void setLegendModelSelected(LegendModel leg) {
        if (leg == null) {
            return;
        }
        this.cmbLegendList.setSelectedItem(leg);
        this.cmbLegendList.getEditor().setItem(leg);
    }

    public LegendModel getLegendModelSelected() {
        return this.leg;
    }

    private void updateControls(boolean updateLegendList) {
        this.cmbScale.setSelectedItem("1 : " + this.nf.format(this.scale));
        this.updateTree();
        if (updateLegendList) {
            this.updateLegendList(false);
        }
        this.updateEnabledState();
    }

    private void updateEnabledState() {
        boolean isBuildIn = true;
        if (this.leg != null) {
            isBuildIn = this.leg.isBuildIn();
        }
        this.butSave.setEnabled(!isBuildIn);
        this.butRenameLegend.setEnabled(!isBuildIn);
        this.butDeleteLegend.setEnabled(!isBuildIn);
        this.lblScale.setEnabled(!isBuildIn);
        this.cmbScale.setEnabled(!isBuildIn);
        this.treeLayer.setEnabled(!isBuildIn);
        this.lstLegend.setEnabled(!isBuildIn);
        this.cboVisibleLayers.setEnabled(!isBuildIn);
        this.butAddToLegend.setEnabled(!isBuildIn);
        this.butUpInLegend.setEnabled(!isBuildIn);
        this.butDownInLegend.setEnabled(!isBuildIn);
        this.butCreateHeader.setEnabled(!isBuildIn);
        this.butEditEntry.setEnabled(!isBuildIn);
        this.butRemoveEntry.setEnabled(!isBuildIn);
        if (this.lstLegend.getSelectedIndices().length == 1) {
            this.butEditEntry.setEnabled(true);
        } else {
            this.butEditEntry.setEnabled(false);
        }
        if (this.lstLegend.getSelectedIndices().length > 0) {
            this.butRemoveEntry.setEnabled(true);
        } else {
            this.butRemoveEntry.setEnabled(false);
        }
    }

    private boolean editLegendHeader(LegendEntryHeaderModel legHeader, boolean newHeader) {
        MultiInputDialog miDialog = new MultiInputDialog((Window)this, I18N.get("ui.plugin.print.legend.LegendManagerDialog.header-title-edit"), true);
        miDialog.setTitle(I18N.get("ui.plugin.print.legend.LegendManagerDialog.header-title-insert"));
        miDialog.addTextField(I18N.get("ui.plugin.print.legend.LegendManagerDialog.header-name"), legHeader.getName(), 30, new EnableCheck[0], null);
        ArrayList<Integer> lstLevels = new ArrayList<Integer>();
        lstLevels.add(1);
        lstLevels.add(2);
        miDialog.addComboBox(I18N.get("ui.plugin.print.legend.LegendManagerDialog.header-level"), legHeader.getLevel(), lstLevels, null);
        miDialog.addCheckBox(I18N.get("ui.plugin.print.legend.LegendManagerDialog.header-display-nochild"), legHeader.isDisplayWhenNoChilds(), I18N.get("ui.plugin.print.legend.LegendManagerDialog.header-display-nochild-tooltip"));
        GUISupport.centreOnScreen((Component)miDialog);
        miDialog.setVisible(true);
        if (miDialog.wasOKPressed()) {
            String headerName = miDialog.getText(I18N.get("ui.plugin.print.legend.LegendManagerDialog.header-name"));
            if (!StringUtils.isEmpty((CharSequence)headerName)) {
                legHeader.setName(headerName);
            }
            legHeader.setLevel(miDialog.getInteger(I18N.get("ui.plugin.print.legend.LegendManagerDialog.header-level")));
            legHeader.setDisplayWhenNoChilds(miDialog.getBoolean(I18N.get("ui.plugin.print.legend.LegendManagerDialog.header-display-nochild")));
        }
        return miDialog.wasOKPressed();
    }

    private ListListModel<LegendEntryModel> getLstLegendModel() {
        return (ListListModel)this.lstLegend.getModel();
    }

    private void initComponents() {
        this.tbaLegendManager = new JToolBar();
        this.butAddLegend = new JButton();
        this.butRenameLegend = new JButton();
        this.butCopyLegend = new JButton();
        this.butDeleteLegend = new JButton();
        this.jSeparator2 = new JToolBar.Separator();
        this.butExportLegend = new JButton();
        this.butImportLegend = new JButton();
        this.pnlLegendList = new JPanel();
        this.lblLegendList = new JLabel();
        this.cmbLegendList = new JComboBox();
        this.sep1 = new JSeparator();
        this.tbaLegend = new JToolBar();
        this.jSeparator3 = new JToolBar.Separator();
        this.butCreateHeader = new JButton();
        this.butEditEntry = new JButton();
        this.butRemoveEntry = new JButton();
        this.jSeparator4 = new JToolBar.Separator();
        this.cboVisibleLayers = new JCheckBox();
        this.scpLayer = new JScrollPane();
        this.treeLayer = new LayerTree(this.scpLayer, WorkbenchContext.getInstance(), this.treeModel, false, false, false);
        this.scpLegend = new JScrollPane();
        this.lstLegend = new JList();
        this.butAddToLegend = new JButton();
        this.butUpInLegend = new JButton();
        this.butDownInLegend = new JButton();
        this.pnlSaveClose = new JPanel();
        this.butSave = new JButton();
        this.butClose = new JButton();
        this.jSeparator1 = new JSeparator();
        this.pnlScale = new JPanel();
        this.lblScale = new JLabel();
        this.cmbScale = new JComboBox();
        this.setDefaultCloseOperation(0);
        this.setTitle("Legendenmanager");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                LegendManagerDialog.this.formWindowClosing(evt);
            }
        });
        this.getContentPane().setLayout(new GridBagLayout());
        this.tbaLegendManager.setFloatable(false);
        this.tbaLegendManager.setRollover(true);
        this.butAddLegend.setText("add");
        this.butAddLegend.setFocusable(false);
        this.butAddLegend.setHorizontalTextPosition(0);
        this.butAddLegend.setVerticalTextPosition(3);
        this.butAddLegend.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LegendManagerDialog.this.butAddLegendActionPerformed(evt);
            }
        });
        this.tbaLegendManager.add(this.butAddLegend);
        this.butRenameLegend.setText("rename");
        this.butRenameLegend.setFocusable(false);
        this.butRenameLegend.setHorizontalTextPosition(0);
        this.butRenameLegend.setVerticalTextPosition(3);
        this.butRenameLegend.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LegendManagerDialog.this.butRenameLegendActionPerformed(evt);
            }
        });
        this.tbaLegendManager.add(this.butRenameLegend);
        this.butCopyLegend.setText("copy");
        this.butCopyLegend.setFocusable(false);
        this.butCopyLegend.setHorizontalTextPosition(0);
        this.butCopyLegend.setVerticalTextPosition(3);
        this.butCopyLegend.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LegendManagerDialog.this.butCopyLegendActionPerformed(evt);
            }
        });
        this.tbaLegendManager.add(this.butCopyLegend);
        this.butDeleteLegend.setText("delete");
        this.butDeleteLegend.setFocusable(false);
        this.butDeleteLegend.setHorizontalTextPosition(0);
        this.butDeleteLegend.setVerticalTextPosition(3);
        this.butDeleteLegend.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LegendManagerDialog.this.butDeleteLegendActionPerformed(evt);
            }
        });
        this.tbaLegendManager.add(this.butDeleteLegend);
        this.tbaLegendManager.add(this.jSeparator2);
        this.butExportLegend.setText("export");
        this.butExportLegend.setFocusable(false);
        this.butExportLegend.setHorizontalTextPosition(0);
        this.butExportLegend.setVerticalTextPosition(3);
        this.butExportLegend.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LegendManagerDialog.this.butExportLegendActionPerformed(evt);
            }
        });
        this.tbaLegendManager.add(this.butExportLegend);
        this.butImportLegend.setText("import");
        this.butImportLegend.setFocusable(false);
        this.butImportLegend.setHorizontalTextPosition(0);
        this.butImportLegend.setVerticalTextPosition(3);
        this.butImportLegend.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LegendManagerDialog.this.butImportLegendActionPerformed(evt);
            }
        });
        this.tbaLegendManager.add(this.butImportLegend);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        this.getContentPane().add((Component)this.tbaLegendManager, gridBagConstraints);
        this.pnlLegendList.setLayout(new GridBagLayout());
        this.lblLegendList.setText("Legende:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 22;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.pnlLegendList.add((Component)this.lblLegendList, gridBagConstraints);
        this.cmbLegendList.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LegendManagerDialog.this.cmbLegendListActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.pnlLegendList.add(this.cmbLegendList, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.getContentPane().add((Component)this.pnlLegendList, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.getContentPane().add((Component)this.sep1, gridBagConstraints);
        this.tbaLegend.setFloatable(false);
        this.tbaLegend.setRollover(true);
        this.tbaLegend.add(this.jSeparator3);
        this.butCreateHeader.setText("jButton7");
        this.butCreateHeader.setFocusable(false);
        this.butCreateHeader.setHorizontalTextPosition(0);
        this.butCreateHeader.setVerticalTextPosition(3);
        this.butCreateHeader.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LegendManagerDialog.this.butCreateHeaderActionPerformed(evt);
            }
        });
        this.tbaLegend.add(this.butCreateHeader);
        this.butEditEntry.setText("jButton8");
        this.butEditEntry.setFocusable(false);
        this.butEditEntry.setHorizontalTextPosition(0);
        this.butEditEntry.setVerticalTextPosition(3);
        this.butEditEntry.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LegendManagerDialog.this.butEditEntryActionPerformed(evt);
            }
        });
        this.tbaLegend.add(this.butEditEntry);
        this.butRemoveEntry.setText("jButton9");
        this.butRemoveEntry.setFocusable(false);
        this.butRemoveEntry.setHorizontalTextPosition(0);
        this.butRemoveEntry.setVerticalTextPosition(3);
        this.butRemoveEntry.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LegendManagerDialog.this.butRemoveEntryActionPerformed(evt);
            }
        });
        this.tbaLegend.add(this.butRemoveEntry);
        this.tbaLegend.add(this.jSeparator4);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        this.getContentPane().add((Component)this.tbaLegend, gridBagConstraints);
        this.cboVisibleLayers.setText("sichtbar");
        this.cboVisibleLayers.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LegendManagerDialog.this.cboVisibleLayersActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(0, 3, 0, 3);
        this.getContentPane().add((Component)this.cboVisibleLayers, gridBagConstraints);
        this.scpLayer.setHorizontalScrollBarPolicy(31);
        this.treeLayer.setDragEnabled(true);
        this.scpLayer.setViewportView(this.treeLayer);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.getContentPane().add((Component)this.scpLayer, gridBagConstraints);
        this.lstLegend.setDragEnabled(true);
        this.lstLegend.setDropMode(DropMode.INSERT);
        this.lstLegend.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                LegendManagerDialog.this.lstLegendMouseClicked(evt);
            }
        });
        this.lstLegend.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                LegendManagerDialog.this.lstLegendValueChanged(evt);
            }
        });
        this.scpLegend.setViewportView(this.lstLegend);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 3.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.getContentPane().add((Component)this.scpLegend, gridBagConstraints);
        this.butAddToLegend.setText(">");
        this.butAddToLegend.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LegendManagerDialog.this.butAddToLegendActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.getContentPane().add((Component)this.butAddToLegend, gridBagConstraints);
        this.butUpInLegend.setText("up");
        this.butUpInLegend.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LegendManagerDialog.this.butUpInLegendActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 20;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.getContentPane().add((Component)this.butUpInLegend, gridBagConstraints);
        this.butDownInLegend.setText("down");
        this.butDownInLegend.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LegendManagerDialog.this.butDownInLegendActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 19;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.getContentPane().add((Component)this.butDownInLegend, gridBagConstraints);
        this.butSave.setText("Speichern");
        this.butSave.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LegendManagerDialog.this.butSaveActionPerformed(evt);
            }
        });
        this.pnlSaveClose.add(this.butSave);
        this.butClose.setText("Schlie\u00dfen");
        this.butClose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LegendManagerDialog.this.butCloseActionPerformed(evt);
            }
        });
        this.pnlSaveClose.add(this.butClose);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.getContentPane().add((Component)this.pnlSaveClose, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.getContentPane().add((Component)this.jSeparator1, gridBagConstraints);
        this.pnlScale.setLayout(new GridBagLayout());
        this.lblScale.setText("Ma\u00dfstab:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 22;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.pnlScale.add((Component)this.lblScale, gridBagConstraints);
        this.cmbScale.setEditable(true);
        this.cmbScale.setModel(new DefaultComboBoxModel<String>(new String[]{"1 : 100", "1 : 250", "1 : 500", "1 : 1000", "1 : 2500", "1 : 5000", "1 : 10000", "1 : 25000", "1 : 50000", "1 : 100000", "1 : 250000", "1 : 500000"}));
        this.cmbScale.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LegendManagerDialog.this.cmbScaleActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.pnlScale.add(this.cmbScale, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 23;
        this.getContentPane().add((Component)this.pnlScale, gridBagConstraints);
        this.pack();
    }

    private void cmbLegendListActionPerformed(ActionEvent evt) {
        if (this.blockCmbLegendEvent) {
            return;
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                LegendManagerDialog.this.blockCmbLegendEvent = true;
                try {
                    if (LegendManagerDialog.this.checkSaveLegend()) {
                        LegendModel legCandidate = (LegendModel)LegendManagerDialog.this.cmbLegendList.getSelectedItem();
                        if (legCandidate != LegendManagerDialog.this.leg) {
                            LegendManagerDialog.this.leg = legCandidate;
                            LegendManagerDialog.this.legendModified = false;
                            LegendManagerDialog.this.updateControls(true);
                        }
                    } else {
                        LegendManagerDialog.this.setLegendModelSelected(LegendManagerDialog.this.leg);
                    }
                }
                finally {
                    LegendManagerDialog.this.blockCmbLegendEvent = false;
                }
            }
        });
    }

    private void butAddLegendActionPerformed(ActionEvent evt) {
        if (!this.checkSaveLegend()) {
            return;
        }
        String legendName = GUISupport.inputbox((Component)this, (String)I18N.get("ui.plugin.print.legend.LegendManagerDialog.insert-legend-name"), (String)I18N.get("ui.plugin.print.legend.LegendManagerDialog.default-legend-name"));
        if (StringUtils.isBlank((CharSequence)legendName)) {
            return;
        }
        LegendModel legNew = new LegendModel(legendName);
        LegendIO.getInstance().addUserLegend(legNew);
        LegendIO.getInstance().saveUserLegends();
        this.refillLegendList();
        this.setLegendModelSelected(legNew);
    }

    private void butRenameLegendActionPerformed(ActionEvent evt) {
        if (this.leg == null || this.cmbLegendList.getItemCount() == 0) {
            return;
        }
        String legendName = GUISupport.inputbox((Component)this, (String)I18N.get("ui.plugin.print.legend.LegendManagerDialog.insert-legend-name"), (String)this.leg.getName());
        if (StringUtils.isBlank((CharSequence)legendName)) {
            return;
        }
        this.leg.setName(legendName);
        LegendIO.getInstance().saveUserLegends();
        this.cmbLegendList.repaint();
        this.cmbLegendList.getEditor().setItem(this.cmbLegendList.getSelectedItem());
    }

    private void butCopyLegendActionPerformed(ActionEvent evt) {
        if (!this.checkSaveLegend()) {
            return;
        }
        if (this.leg == null || this.cmbLegendList.getItemCount() == 0) {
            return;
        }
        String legendName = GUISupport.inputbox((Component)this, (String)I18N.get("ui.plugin.print.legend.LegendManagerDialog.insert-legend-name"), (String)this.leg.getName());
        if (StringUtils.isEmpty((CharSequence)legendName)) {
            return;
        }
        LegendModel clonedLeg = (LegendModel)this.leg.cloneModel();
        clonedLeg.setName(legendName);
        clonedLeg.setBuildIn(false);
        LegendIO.getInstance().addUserLegend(clonedLeg);
        LegendIO.getInstance().saveUserLegends();
        this.refillLegendList();
        this.setLegendModelSelected(clonedLeg);
    }

    private void butDeleteLegendActionPerformed(ActionEvent evt) {
        if (this.leg == null || this.cmbLegendList.getItemCount() == 0) {
            return;
        }
        boolean doDelete = GUISupport.yesnobox((Component)this, (String)I18N.get("ui.plugin.print.legend.LegendManagerDialog.delete-legend-question"), (String)I18N.get("common.message"));
        if (doDelete) {
            LegendIO.getInstance().removeUserLegend(this.leg);
            LegendIO.getInstance().saveUserLegends();
            this.refillLegendList();
        }
    }

    private void butExportLegendActionPerformed(ActionEvent evt) {
        if (!this.checkSaveLegend()) {
            return;
        }
        if (this.leg == null || this.cmbLegendList.getItemCount() == 0) {
            return;
        }
        FileFilter legFileFilter = GUISupport.createFileFilter((String)I18N.get("ui.plugin.print.legend.LegendManagerDialog.file-filter"), (String[])new String[]{"leg"});
        JFileChooser fChoose = GUISupport.createJFileChooserOverwritePrompting();
        fChoose.setFileFilter(legFileFilter);
        fChoose.setDialogTitle(I18N.get("ui.plugin.print.legend.LegendManagerDialog.choose-export-file"));
        fChoose.setFileSelectionMode(0);
        fChoose.setMultiSelectionEnabled(false);
        fChoose.setAcceptAllFileFilterUsed(false);
        File lastFile = (File)PersistentBlackboardPlugIn.get().get(LAST_EXPORT_IMPORT_FILE_BLACKBOARD_KEY, (Object)null);
        if (lastFile != null && lastFile.getParentFile().exists() && lastFile.getParentFile().isDirectory()) {
            File candidateFile = new File(lastFile.getParentFile(), FileSupport.removeIllegalCharsFromFilename((String)(this.leg.getName() + ".leg")));
            fChoose.setSelectedFile(candidateFile);
        }
        if (fChoose.showSaveDialog(this) == 0) {
            File selFile = fChoose.getSelectedFile();
            selFile = FileSupport.addExtension((File)selFile, (String)"leg");
            ArrayList<LegendModel> lstLeg2Export = new ArrayList<LegendModel>();
            lstLeg2Export.add(this.leg);
            try {
                LegendIO.saveLegendsToFile(lstLeg2Export, selFile);
            }
            catch (IOException e) {
                ExceptionDialog.handleGuiException((Component)this, (Exception)e, this.getClass());
            }
            PersistentBlackboardPlugIn.get().put(LAST_EXPORT_IMPORT_FILE_BLACKBOARD_KEY, selFile);
        }
    }

    private void butImportLegendActionPerformed(ActionEvent evt) {
        if (!this.checkSaveLegend()) {
            return;
        }
        FileFilter legFileFilter = GUISupport.createFileFilter((String)I18N.get("ui.plugin.print.legend.LegendManagerDialog.file-filter"), (String[])new String[]{"leg"});
        JFileChooser fChoose = GUISupport.createJFileChooser((boolean)true);
        fChoose.setFileFilter(legFileFilter);
        fChoose.setDialogTitle(I18N.get("ui.plugin.print.legend.LegendManagerDialog.choose-import-file"));
        fChoose.setFileSelectionMode(0);
        fChoose.setMultiSelectionEnabled(false);
        fChoose.setAcceptAllFileFilterUsed(false);
        File lastFile = (File)PersistentBlackboardPlugIn.get().get(LAST_EXPORT_IMPORT_FILE_BLACKBOARD_KEY, (Object)null);
        if (lastFile != null) {
            fChoose.setSelectedFile(lastFile);
        }
        if (fChoose.showOpenDialog(this) == 0) {
            File selFile = fChoose.getSelectedFile();
            try {
                List<LegendModel> lstLegs2Import = LegendIO.loadLegendsFromFile(selFile);
                if (lstLegs2Import == null || lstLegs2Import.isEmpty()) {
                    return;
                }
                LegendModel lastLegImported = lstLegs2Import.get(0);
                for (LegendModel leg2Import : lstLegs2Import) {
                    LegendIO.getInstance().addUserLegend(leg2Import);
                    lastLegImported = leg2Import;
                }
                LegendIO.getInstance().saveUserLegends();
                this.refillLegendList();
                this.setLegendModelSelected(lastLegImported);
            }
            catch (IOException e) {
                ExceptionDialog.handleGuiException((Component)this, (Exception)e, this.getClass());
            }
            PersistentBlackboardPlugIn.get().put(LAST_EXPORT_IMPORT_FILE_BLACKBOARD_KEY, selFile);
        }
    }

    private void cboVisibleLayersActionPerformed(ActionEvent evt) {
        this.updateTree();
    }

    private void cmbScaleActionPerformed(ActionEvent evt) {
        String strScale = (String)this.cmbScale.getSelectedItem();
        String[] arrScale = strScale.split("\\:");
        if (arrScale.length > 2) {
            this.scale = 1000.0;
        } else {
            strScale = arrScale.length == 2 ? arrScale[1] : arrScale[0];
        }
        try {
            this.scale = this.df.parse(strScale.trim()).doubleValue();
        }
        catch (Exception e) {
            LOG.error("error while scaling", (Throwable)e);
        }
        this.updateControls(false);
    }

    private void butAddToLegendActionPerformed(ActionEvent evt) {
        List<LegendEntryModel> lstEntries = LegendTreeTransferHandler.createTransferData(this.treeLayer, this);
        LegendListTransferHandler.addEntries2List(this.lstLegend, lstEntries, this.lstLegend.getModel().getSize());
    }

    private void butRemoveEntryActionPerformed(ActionEvent evt) {
        ListListModel<LegendEntryModel> listModel = this.getLstLegendModel();
        List<LegendEntryModel> lstSelection = this.lstLegend.getSelectedValuesList();
        for (LegendEntryModel entry : lstSelection) {
            listModel.removeListObject((Object)entry);
        }
    }

    private void butUpInLegendActionPerformed(ActionEvent evt) {
        ListListModel<LegendEntryModel> listModel = this.getLstLegendModel();
        int[] arrSelectionIndex = this.lstLegend.getSelectedIndices();
        if (arrSelectionIndex.length == 0) {
            return;
        }
        List<LegendEntryModel> lstSelection = this.lstLegend.getSelectedValuesList();
        for (LegendEntryModel entry : lstSelection) {
            listModel.removeListObject((Object)entry);
        }
        Arrays.sort(arrSelectionIndex);
        int index = arrSelectionIndex[0];
        --index;
        int indexStart = index = Math.max(0, index);
        for (LegendEntryModel entry : lstSelection) {
            listModel.addListObject((Object)entry, index);
            ++index;
        }
        int indexEnd = --index;
        this.lstLegend.getSelectionModel().addSelectionInterval(indexStart, indexEnd);
    }

    private void butDownInLegendActionPerformed(ActionEvent evt) {
        ListListModel<LegendEntryModel> listModel = this.getLstLegendModel();
        int[] arrSelectionIndex = this.lstLegend.getSelectedIndices();
        if (arrSelectionIndex.length == 0) {
            return;
        }
        List<LegendEntryModel> lstSelection = this.lstLegend.getSelectedValuesList();
        for (LegendEntryModel entry : lstSelection) {
            listModel.removeListObject((Object)entry);
        }
        Arrays.sort(arrSelectionIndex);
        int index = arrSelectionIndex[0];
        ++index;
        int indexStart = index = Math.min(this.lstLegend.getModel().getSize(), index);
        for (LegendEntryModel entry : lstSelection) {
            listModel.addListObject((Object)entry, index);
            ++index;
        }
        int indexEnd = --index;
        this.lstLegend.getSelectionModel().addSelectionInterval(indexStart, indexEnd);
    }

    private void lstLegendMouseClicked(MouseEvent evt) {
        if (evt.getClickCount() == 2 && this.lstLegend.getSelectedValuesList().size() == 1) {
            this.butEditEntryActionPerformed(null);
        }
    }

    private void butEditEntryActionPerformed(ActionEvent evt) {
        if (this.lstLegend.getSelectedValuesList().size() == 1) {
            ListListModel<LegendEntryModel> listModel = this.getLstLegendModel();
            LegendEntryModel legEntry = (LegendEntryModel)((Object)listModel.getElementAt(this.lstLegend.getSelectedIndex()));
            if (legEntry instanceof LegendEntryHeaderModel) {
                LegendEntryHeaderModel legHeader = (LegendEntryHeaderModel)legEntry;
                this.editLegendHeader(legHeader, false);
            } else if (legEntry instanceof AbstractLegendEntryLayerableModel) {
                AbstractLegendEntryLayerableModel legLy = (AbstractLegendEntryLayerableModel)legEntry;
                EditLayerableEntryDialog editLeg = new EditLayerableEntryDialog((Dialog)this, legLy);
                GUISupport.centreOnScreen((Component)editLeg);
                editLeg.setVisible(true);
                if (editLeg.wasOkPressed()) {
                    if (!StringUtils.isEmpty((CharSequence)editLeg.getLegendName())) {
                        legLy.setName(editLeg.getLegendName());
                    }
                    legLy.setSvgData(editLeg.getLegendSvgData());
                }
            } else {
                Object newName = JOptionPane.showInputDialog(this, I18N.get("ui.plugin.print.legend.LegendManagerDialog.change-name"), I18N.get("ui.plugin.print.legend.LegendManagerDialog.change-name-title"), -1, null, null, legEntry.getName());
                if (newName != null) {
                    legEntry.setName(newName.toString());
                }
            }
            listModel.replaceListObject((Object)legEntry, (Object)legEntry);
        }
    }

    private void butCreateHeaderActionPerformed(ActionEvent evt) {
        LegendEntryHeaderModel legHeader = new LegendEntryHeaderModel(I18N.get("ui.plugin.print.legend.LegendManagerDialog.header-new-name"), 1);
        boolean addToModel = this.editLegendHeader(legHeader, true);
        if (addToModel) {
            ListListModel<LegendEntryModel> listModel = this.getLstLegendModel();
            listModel.addListObject((Object)legHeader);
        }
    }

    private void lstLegendValueChanged(ListSelectionEvent evt) {
        this.updateEnabledState();
    }

    private void formWindowClosing(WindowEvent evt) {
        if (this.checkSaveLegend()) {
            this.dispose();
        }
    }

    private void butSaveActionPerformed(ActionEvent evt) {
        this.saveLegend();
    }

    private void butCloseActionPerformed(ActionEvent evt) {
        if (this.checkSaveLegend()) {
            this.setVisible(false);
        }
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                LegendManagerDialog dialog = new LegendManagerDialog((Frame)new JFrame(), null);
                dialog.addWindowListener(new WindowAdapter(this){

                    @Override
                    public void windowClosing(WindowEvent e) {
                        System.exit(0);
                    }
                });
                dialog.setVisible(true);
            }
        });
    }
}

