/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.plugin.print.legend;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import com.thoughtworks.xstream.io.xml.CompactWriter;
import com.vividsolutions.jump.workbench.JUMPWorkbench;
import com.vividsolutions.jump.workbench.ui.plugin.print.legend.model.LegendModel;
import com.vividsolutions.jump.workbench.ui.plugin.print.legend.model.XStreamUtilLegend;
import de.riwagis.service.directory.DirectoryService;
import de.riwagis.service.directory.ProjectType;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.IOCase;
import org.apache.commons.io.filefilter.WildcardFileFilter;

public class LegendIO {
    private static final Pattern UNIQUE_LEGENDNAME = Pattern.compile("^(.*)_([0-9]+)$");
    public static final String FILE_EXTENSION_LEG = "leg";
    public static final FilenameFilter LEGEND_IO_FILENAMEFILTER = new WildcardFileFilter("*.leg", IOCase.INSENSITIVE);
    private static final String USER_LEG_FILENAME = "userlegends.leg";
    private static final String PRESET_LEG_DIRNAME = "legends";
    private static LegendIO singleton = null;
    private List<LegendModel> lstLegUser = null;

    private LegendIO() {
    }

    public static synchronized LegendIO getInstance() {
        if (singleton == null) {
            singleton = new LegendIO();
        }
        return singleton;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addUserLegend(LegendModel leg) {
        LegendIO legendIO = this;
        synchronized (legendIO) {
            LegendIO.addLegendWithUniqueName(this.lstLegUser, leg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean removeUserLegend(LegendModel leg) {
        LegendIO legendIO = this;
        synchronized (legendIO) {
            return this.lstLegUser.remove(leg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void saveUserLegends() {
        LegendIO legendIO = this;
        synchronized (legendIO) {
            try {
                ArrayList<LegendModel> legends2Save = new ArrayList<LegendModel>();
                for (LegendModel leg : this.lstLegUser) {
                    if (leg.isBuildIn()) continue;
                    legends2Save.add(leg);
                }
                File userLegFile = new File(DirectoryService.getInstance().getProjectDirectory(ProjectType.JUMP), USER_LEG_FILENAME);
                LegendIO.saveLegendsToFile(legends2Save, userLegFile);
            }
            catch (IOException e) {
                throw new RuntimeException("Error saving user legends", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final List<LegendModel> getUserLegends() {
        LegendIO legendIO = this;
        synchronized (legendIO) {
            try {
                if (this.lstLegUser == null) {
                    File[] legFiles;
                    File legendDir;
                    File userLegFile = new File(DirectoryService.getInstance().getProjectDirectory(ProjectType.JUMP), USER_LEG_FILENAME);
                    ArrayList<LegendModel> lstLegsLoaded = new ArrayList();
                    if (userLegFile.exists()) {
                        lstLegsLoaded = LegendIO.loadLegendsFromFile(userLegFile);
                    }
                    if ((legendDir = new File(PRESET_LEG_DIRNAME)).exists() && (legFiles = legendDir.listFiles(LEGEND_IO_FILENAMEFILTER)) != null) {
                        for (File legFile : legFiles) {
                            List<LegendModel> lstLegsFromFile = LegendIO.loadLegendsFromFile(legFile);
                            for (LegendModel leg : lstLegsFromFile) {
                                leg.setBuildIn(true);
                                LegendIO.addLegendWithUniqueName(lstLegsLoaded, leg);
                            }
                        }
                    }
                    if (JUMPWorkbench.GIS_CONTEXT != null) {
                        String[] arrFiles = JUMPWorkbench.GIS_CONTEXT.getModuleApp().getFileList("legend");
                        for (String fileName : arrFiles) {
                            File legFile = JUMPWorkbench.GIS_CONTEXT.getModuleApp().getFile("legend", fileName);
                            List<LegendModel> lstLegsFromFile = LegendIO.loadLegendsFromFile(legFile);
                            for (LegendModel leg : lstLegsFromFile) {
                                leg.setBuildIn(true);
                                LegendIO.addLegendWithUniqueName(lstLegsLoaded, leg);
                            }
                        }
                    }
                    Collections.sort(lstLegsLoaded);
                    this.lstLegUser = lstLegsLoaded;
                }
            }
            catch (Exception e) {
                throw new RuntimeException("Error loading user legends", e);
            }
            return Collections.unmodifiableList(this.lstLegUser);
        }
    }

    public static final void saveLegendsToFile(List<LegendModel> lstLeg, File legFile) throws IOException {
        XStream legXStream = XStreamUtilLegend.getLegendXStream();
        try (OutputStreamWriter legWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(legFile, false), "UTF-8");){
            legXStream.marshal(lstLeg, (HierarchicalStreamWriter)new CompactWriter((Writer)legWriter));
        }
    }

    public static final List<LegendModel> loadLegendsFromFile(File legFile) throws IOException {
        List list;
        XStream legXStream = XStreamUtilLegend.getLegendXStream();
        InputStreamReader lstReader = new InputStreamReader((InputStream)new FileInputStream(legFile), "UTF-8");
        try {
            List lstLeg = (List)legXStream.fromXML((Reader)lstReader);
            Collections.sort(lstLeg);
            list = lstLeg;
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((Reader)lstReader).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (UnsupportedEncodingException e) {
                throw new IOException(e);
            }
        }
        ((Reader)lstReader).close();
        return list;
    }

    public static LegendModel addLegendWithUniqueName(List<LegendModel> lstLeg, LegendModel leg) {
        String newName = leg.getName();
        while (LegendIO.doesListContainLegendWithName(lstLeg, newName)) {
            newName = LegendIO.buildNextName(newName);
        }
        leg.setName(newName);
        lstLeg.add(leg);
        Collections.sort(lstLeg);
        return leg;
    }

    public static String buildNextName(String legendName) {
        Matcher m = UNIQUE_LEGENDNAME.matcher(legendName);
        if (m.matches()) {
            int numLastPart = Integer.parseInt(m.group(2)) + 1;
            return String.format("%s_%d", m.group(1), numLastPart);
        }
        return String.format("%s_%d", legendName, 1);
    }

    private static boolean doesListContainLegendWithName(List<LegendModel> lstLeg, String name) {
        for (LegendModel legInList : lstLeg) {
            if (!legInList.getName().equalsIgnoreCase(name)) continue;
            return true;
        }
        return false;
    }
}

