/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.plugin.print.legend;

import com.vividsolutions.jump.workbench.model.Layerable;
import com.vividsolutions.jump.workbench.model.WithScale;
import com.vividsolutions.jump.workbench.ui.layertree.LayerNameRenderer;
import com.vividsolutions.jump.workbench.ui.layertree.LegendLabelPanel;
import com.vividsolutions.jump.workbench.ui.layertree.RendererUtil;
import com.vividsolutions.jump.workbench.ui.plugin.print.legend.intelligence.AbstractLegendEntryLayerableIntelligence;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.image.BufferedImage;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;

public class LegendEntrySvgListCellRenderer
extends JPanel
implements ListCellRenderer<AbstractLegendEntryLayerableIntelligence> {
    private static final BufferedImage EMTPY_IMG = new BufferedImage(1, 1, 2);
    private final GridBagLayout gridBagLayout = new GridBagLayout();
    private final JLabel label = new JLabel();
    private final LegendLabelPanel llPanel = new LegendLabelPanel();
    private Layerable ly = null;
    private WithScale withScale = null;

    public LegendEntrySvgListCellRenderer() {
        this.jbInit();
    }

    public void setLayerable(Layerable ly) {
        this.ly = ly;
    }

    public void setWithScale(WithScale withScale) {
        this.withScale = withScale;
        this.llPanel.setWithScale(withScale);
    }

    @Override
    public Component getListCellRendererComponent(JList list, AbstractLegendEntryLayerableIntelligence value, int index, boolean isSelected, boolean cellHasFocus) {
        if (value == null) {
            this.label.setText("");
            this.llPanel.setImage(EMTPY_IMG);
            return this;
        }
        this.label.setText(value.getModel().getName());
        if (isSelected) {
            this.setOpaque(true);
            this.label.setForeground(list.getSelectionForeground());
            this.label.setBackground(list.getSelectionBackground());
            this.setForeground(list.getSelectionForeground());
            this.setBackground(list.getSelectionBackground());
        } else {
            this.setOpaque(false);
            this.label.setForeground(list.getForeground());
            this.label.setBackground(list.getBackground());
            this.setForeground(list.getForeground());
            this.setBorder(BorderFactory.createMatteBorder(1, 1, 1, 1, Color.LIGHT_GRAY));
        }
        if (!RendererUtil.isValidForScale(this.ly, this.withScale)) {
            this.label.setForeground(LayerNameRenderer.GREY);
        }
        BufferedImage bImg = new BufferedImage(60, 22, 2);
        value.paintSvgImage(value.getSvgData2Paint(), bImg.createGraphics(), bImg.getWidth() / 2, bImg.getHeight() / 2, bImg.getWidth(), bImg.getHeight());
        this.llPanel.setImage(bImg);
        return this;
    }

    private final void jbInit() {
        this.setLayout(this.gridBagLayout);
        this.label.setOpaque(false);
        this.llPanel.setOpaque(false);
        this.add((Component)this.label, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(2, 2, 2, 2), 0, 0));
        this.add((Component)this.llPanel, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 1, 1), 0, 0));
        this.setBorder(BorderFactory.createMatteBorder(0, 1, 1, 0, Color.LIGHT_GRAY));
    }
}

